/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.ui.dialogs.EditAUFDialog;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.Messages;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.ui.PlatformUI;

public class AufNewHandler
extends AbstractHandler
implements IHandler {
    public static final String CMD_ID = "ch.elexis.core.ui.commands.AufNew";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional pat = ContextServiceHolder.get().getActivePatient();
        if (!pat.isPresent()) {
            SWTHelper.showError(Messages.AUF2_NoPatientSelected, Messages.AUF2_PleaseDoSelectPatient);
            return null;
        }
        ICoverage fall = ContextServiceHolder.get().getRootContext().getTyped(ICoverage.class).orElse(null);
        if (fall == null) {
            Optional kons = ContextServiceHolder.get().getRootContext().getTyped(IEncounter.class);
            if (kons.isPresent() && !(fall = ((IEncounter)kons.get()).getCoverage()).getPatient().equals(pat.get())) {
                kons = null;
            }
            if (kons == null) {
                kons = EncounterServiceHolder.get().getLatestEncounter((IPatient)pat.get());
                fall = ((IEncounter)kons.get()).getCoverage();
            }
        }
        if (fall == null) {
            SWTHelper.showError(Messages.AUF2_noCaseSelected, Messages.AUF2_selectCase);
            return null;
        }
        EditAUFDialog dlg = new EditAUFDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, fall);
        if (dlg.open() == 0) {
            return dlg.getAuf();
        }
        return null;
    }
}

