/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.model.adapter.internal;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractModelAdapterFactory;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQueryCursor;
import java.util.Optional;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.slf4j.LoggerFactory;

public class QueryCursor<T>
implements IQueryCursor<T> {
    private Cursor cursor;
    private AbstractModelAdapterFactory adapterFactory;
    private Class<?> interfaceClazz;
    private boolean adapt;

    public QueryCursor(ScrollableCursor cursor, AbstractModelAdapterFactory adapterFactory, Class<?> interfaceClazz) {
        this.cursor = cursor;
        this.adapterFactory = adapterFactory;
        this.interfaceClazz = interfaceClazz;
        this.adapt = adapterFactory != null && interfaceClazz != null;
    }

    public void close() {
        try {
            this.cursor.close();
        }
        catch (DatabaseException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error closing cursor", (Throwable)e);
        }
    }

    public boolean hasNext() {
        return this.cursor.hasNext();
    }

    public T next() {
        if (this.adapt) {
            Optional<Identifiable> adapter = this.adapterFactory.getModelAdapter((EntityWithId)this.cursor.next(), this.interfaceClazz, true);
            return (T)adapter.get();
        }
        return (T)this.cursor.next();
    }

    public int size() {
        return this.cursor.size();
    }

    public void clear() {
        this.cursor.clear();
    }
}

