/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.issue;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.interfaces.INumericEnum;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;

public enum Type implements INumericEnum,
ILocalizedEnum
{
    COMMON(0),
    PRINT(1),
    PRINT_DRUG_STICKER(2),
    SEND_DOCUMENT(3),
    READ_DOCUMENT(4),
    CHECK_LAB_RESULT(5),
    MAKE_APPOINTMENT(6),
    DISPENSE_MEDICATION(7),
    PROCESS_SERVICE_RECORDING(8);

    private final int numeric;

    private Type(int numeric) {
        this.numeric = numeric;
    }

    @Override
    public int numericValue() {
        return this.numeric;
    }

    @Override
    public String getLocaleText() {
        try {
            return ResourceBundle.getBundle("ch.elexis.core.l10n.messages").getString(String.valueOf(Type.class.getSimpleName()) + "_" + this.name());
        }
        catch (Exception e) {
            return this.name();
        }
    }

    public static Type byNumericSafe(String actionTypeIn) {
        if (StringUtils.isNotBlank((CharSequence)actionTypeIn)) {
            try {
                int numeric = Integer.parseInt(actionTypeIn);
                Type[] typeArray = Type.values();
                int n = typeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Type actionType = typeArray[n2];
                    if (actionType.numericValue() == numeric) {
                        return actionType;
                    }
                    ++n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return COMMON;
    }
}

