/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail;

import ch.elexis.core.mail.internal.DocumentConverterServiceHolder;
import ch.elexis.core.mail.internal.DocumentStoreServiceHolder;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IImage;
import ch.elexis.core.services.IDocumentConverter;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.utils.CoreUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentsUtil {
    private static final Logger logger = LoggerFactory.getLogger(AttachmentsUtil.class);
    private static File attachmentsFolder;

    private static synchronized File getAttachmentsFolder() {
        if (attachmentsFolder == null) {
            File tmpDir = CoreUtil.getTempDir();
            attachmentsFolder = new File(tmpDir, "_att" + System.currentTimeMillis() + "_");
            attachmentsFolder.mkdir();
        }
        return attachmentsFolder;
    }

    private static Optional<File> getTempFile(IDocument iDocument) {
        Optional converted;
        String extension = iDocument.getExtension();
        Optional<IDocumentConverter> converterService = DocumentConverterServiceHolder.get();
        if (converterService.isPresent() && converterService.get().isAvailable() && extension != null && !extension.toLowerCase().endsWith("pdf") && (converted = DocumentConverterServiceHolder.get().get().convertToPdf(iDocument)).isPresent()) {
            return converted;
        }
        File tmpFile = new File(AttachmentsUtil.getAttachmentsFolder(), AttachmentsUtil.getFileName(iDocument));
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream fout = new FileOutputStream(tmpFile);){
                Optional content = DocumentStoreServiceHolder.getService().loadContent(iDocument);
                if (content.isPresent()) {
                    IOUtils.copy((InputStream)((InputStream)content.get()), (OutputStream)fout);
                    ((InputStream)content.get()).close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Could not export IDocument.", (Throwable)e);
        }
        if (tmpFile != null && tmpFile.exists()) {
            return Optional.of(tmpFile);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File getTempFile(IImage iImage) {
        File tmpFile;
        block15: {
            tmpFile = new File(AttachmentsUtil.getAttachmentsFolder(), AttachmentsUtil.getFileName(iImage));
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    FileOutputStream fout = new FileOutputStream(tmpFile);
                    try {
                        try (ByteArrayInputStream content = new ByteArrayInputStream(iImage.getImage());){
                            IOUtils.copy((InputStream)content, (OutputStream)fout);
                        }
                        if (fout == null) break block15;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fout == null) throw throwable;
                        fout.close();
                        throw throwable;
                    }
                    fout.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException e) {
                logger.error("Could not export IImage.", (Throwable)e);
            }
        }
        if (tmpFile == null) return null;
        if (!tmpFile.exists()) return null;
        return tmpFile;
    }

    private static String getFileName(IImage iImage) {
        return iImage.getTitle();
    }

    private static String getFileName(IDocument iDocument) {
        StringBuilder ret = new StringBuilder();
        ret.append(iDocument.getPatient().getCode()).append("_");
        ret.append(iDocument.getPatient().getLastName()).append(" ");
        ret.append(iDocument.getPatient().getFirstName()).append("_");
        String title = iDocument.getTitle();
        if (iDocument.getExtension() != null && title.endsWith(iDocument.getExtension())) {
            title = title.substring(0, title.lastIndexOf(46));
        }
        ret.append(title).append("_");
        ret.append(new SimpleDateFormat("ddMMyyyy_HHmmss").format(iDocument.getLastchanged()));
        String extension = iDocument.getExtension();
        if (extension != null && extension.indexOf(46) != -1) {
            extension = extension.substring(extension.lastIndexOf(46) + 1);
        }
        ret.append(".").append(extension);
        return ret.toString().replaceAll("[^a-z\u00fc\u00e4\u00f6A-Z\u00dc\u00c4\u00d60-9 _\\.\\-]", "");
    }

    public static String getAttachmentsString(List<File> attachments) {
        StringBuilder sb = new StringBuilder();
        for (File file : attachments) {
            if (sb.length() > 0) {
                sb.append(":::");
            }
            sb.append(file.getAbsolutePath());
        }
        return sb.toString();
    }

    public static List<File> getAttachmentsFiles(String attachments) {
        ArrayList<File> ret = new ArrayList<File>();
        if (attachments != null && !attachments.isEmpty()) {
            String[] parts;
            String[] stringArray = parts = attachments.split(":::");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                ret.add(new File(string));
                ++n2;
            }
        }
        return ret;
    }

    public static String toAttachments(String documents) {
        String[] parts;
        StringJoiner sj = new StringJoiner(":::");
        String[] stringArray = parts = documents.split(":::");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Optional loaded = StoreToStringServiceHolder.get().loadFromString(string);
            if (loaded.isPresent() && loaded.get() instanceof IDocument) {
                AttachmentsUtil.getTempFile((IDocument)loaded.get()).ifPresent(f -> sj.add(f.getAbsolutePath()));
            }
            ++n2;
        }
        return sj.toString();
    }

    public static String toAttachment(String document) {
        Optional<File> file;
        Optional loaded = StoreToStringServiceHolder.get().loadFromString(document);
        if (loaded.isPresent() && loaded.get() instanceof IDocument && (file = AttachmentsUtil.getTempFile((IDocument)loaded.get())).isPresent()) {
            return file.get().getAbsolutePath();
        }
        return "?";
    }

    public static String getDocumentsString(List<IDocument> iDocuments) {
        StringJoiner sj = new StringJoiner(":::");
        for (IDocument object : iDocuments) {
            if (!(object instanceof IDocument)) continue;
            sj.add(StoreToStringServiceHolder.getStoreToString((Object)object));
        }
        return sj.toString();
    }

    public static File getAttachmentsFile(IImage iImage) {
        return AttachmentsUtil.getTempFile(iImage);
    }
}

