/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import java.time.LocalDate;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;

public interface ICondition
extends IFinding {
    public ConditionCategory getCategory();

    public void setCategory(ConditionCategory var1);

    public ConditionStatus getStatus();

    public void setStatus(ConditionStatus var1);

    public List<ICoding> getCoding();

    public void setCoding(List<ICoding> var1);

    public void setDateRecorded(LocalDate var1);

    public Optional<LocalDate> getDateRecorded();

    public void setStart(String var1);

    public Optional<String> getStart();

    public void setEnd(String var1);

    public Optional<String> getEnd();

    public void addNote(String var1);

    public void removeNote(String var1);

    public List<String> getNotes();

    public static enum ConditionCategory {
        UNKNOWN("unknown"),
        PROBLEMLISTITEM("problem-list-item"),
        ENCOUNTERDIAGNOSIS("encounter-diagnosis");

        private String code;

        private ConditionCategory(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public String getLocalized() {
            try {
                String localized = ResourceBundle.getBundle("ch.elexis.core.l10n.messages").getString(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "_" + this.name());
                return localized;
            }
            catch (MissingResourceException e) {
                return this.toString();
            }
        }
    }

    public static enum ConditionStatus {
        UNKNOWN,
        RECURRENCE,
        ACTIVE,
        RELAPSE,
        INACTIVE,
        REMISSION,
        RESOLVED;


        public String getLocalized() {
            try {
                String localized = ResourceBundle.getBundle("ch.elexis.core.l10n.messages").getString(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "_" + this.name());
                return localized;
            }
            catch (MissingResourceException e) {
                return this.toString();
            }
        }
    }
}

