/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroup;
import org.eclipse.nebula.widgets.nattable.group.model.RowGroupModel;

public class RowGroup<T>
implements IRowGroup<T> {
    private String groupName;
    private boolean collapsed;
    private boolean collapseable;
    private final RowGroupModel<T> rowGroupModel;
    private List<T> rowMembers;
    private List<T> staticRowMembers;
    private List<IRowGroup<T>> childGroups;
    private IRowGroup<T> parentGroup;
    private Map<String, Object> data;
    private static final String DEFAULT_DATA_KEY = "defaultKey";

    public RowGroup(RowGroupModel<T> rowGroupModel, String groupName) {
        this.rowGroupModel = rowGroupModel;
        this.init(groupName, false);
        this.collapseable = true;
    }

    public RowGroup(RowGroupModel<T> rowGroupModel, String groupName, boolean collapsed) {
        this.rowGroupModel = rowGroupModel;
        this.init(groupName, collapsed);
    }

    private void init(String groupName, boolean collapsed) {
        this.groupName = groupName;
        this.collapsed = collapsed;
        this.collapseable = true;
        this.rowMembers = Collections.synchronizedList(new ArrayList());
        this.staticRowMembers = Collections.synchronizedList(new ArrayList());
        this.childGroups = Collections.synchronizedList(new ArrayList());
        this.data = new HashMap<String, Object>();
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public Object getData() {
        return this.data.get(DEFAULT_DATA_KEY);
    }

    @Override
    public Object getData(String key) {
        return this.data.get(key);
    }

    @Override
    public void setData(Object data) {
        this.data.put(DEFAULT_DATA_KEY, data);
    }

    @Override
    public void setData(String key, Object data) {
        this.data.put(key, data);
    }

    @Override
    public boolean isCollapsed() {
        return this.collapsed;
    }

    @Override
    public boolean isCollapseable() {
        return this.collapseable;
    }

    public void setCollapseable(boolean collapseable) {
        this.collapseable = collapseable;
    }

    @Override
    public void collapse() {
        if (this.isCollapseable() && !this.isCollapsed()) {
            this.collapsed = true;
            this.rowGroupModel.notifyListeners();
        }
    }

    @Override
    public void expand() {
        if (this.isCollapseable() && this.isCollapsed()) {
            this.collapsed = false;
            this.rowGroupModel.notifyListeners();
        }
    }

    private void addMemberRowAndCache(List<T> rows, T row) {
        rows.add(row);
        this.rowGroupModel.addMemberRow(row, this);
    }

    @Override
    public void addMemberRow(T row) {
        this.addMemberRowAndCache(this.rowMembers, row);
        this.rowGroupModel.notifyListeners();
    }

    @Override
    public void addStaticMemberRow(T row) {
        this.addMemberRowAndCache(this.staticRowMembers, row);
        this.rowGroupModel.notifyListeners();
    }

    @Override
    public void addMemberRows(List<T> rows) {
        for (T row : rows) {
            this.addMemberRowAndCache(this.rowMembers, row);
        }
        this.rowGroupModel.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMemberRowFromCache(T row) {
        boolean removed = false;
        if (row != null) {
            removed = this.rowMembers.remove(row);
            if (!removed) {
                removed = this.staticRowMembers.remove(row);
            }
            if (removed) {
                this.rowGroupModel.removeMemberRow(row);
                if (this.getOwnMemberRows(false).isEmpty() && this.getRowGroups().isEmpty()) {
                    for (T staticRow : this.getOwnStaticMemberRows()) {
                        this.rowGroupModel.removeMemberRow(staticRow);
                    }
                    this.staticRowMembers.clear();
                    this.rowGroupModel.removeRowGroup(this);
                    if (this.parentGroup != null) {
                        this.parentGroup.removeRowGroup(this);
                    }
                }
            } else {
                List<IRowGroup<T>> list = this.childGroups;
                synchronized (list) {
                    for (IRowGroup<T> rowGroup : this.childGroups) {
                        removed = ((RowGroup)rowGroup).removeMemberRow(row);
                        if (!removed) continue;
                        if (!rowGroup.getOwnMemberRows(false).isEmpty()) break;
                        this.childGroups.remove(rowGroup);
                        break;
                    }
                }
            }
        }
        return removed;
    }

    @Override
    public boolean removeMemberRow(T row) {
        boolean removed = this.removeMemberRowFromCache(row);
        if (removed) {
            this.rowGroupModel.notifyListeners();
        }
        return removed;
    }

    @Override
    public void removeMemberRows(List<T> rows) {
        boolean removed = false;
        for (T row : rows) {
            removed |= this.removeMemberRowFromCache(row);
        }
        if (removed) {
            this.rowGroupModel.notifyListeners();
        }
    }

    @Override
    public IRowGroup<T> getParentGroup() {
        return this.parentGroup;
    }

    @Override
    public void setParentGroup(IRowGroup<T> parentGroup) {
        this.parentGroup = parentGroup;
    }

    @Override
    public void addRowGroup(IRowGroup<T> rowGroup) {
        rowGroup.setParentGroup(this);
        this.childGroups.add(rowGroup);
        this.rowGroupModel.notifyListeners();
    }

    @Override
    public boolean removeRowGroup(IRowGroup<T> rowGroup) {
        rowGroup.setParentGroup(null);
        rowGroup.clear();
        boolean removed = this.childGroups.remove(rowGroup);
        this.rowGroupModel.notifyListeners();
        return removed;
    }

    @Override
    public List<IRowGroup<T>> getRowGroups() {
        return Collections.unmodifiableList(this.childGroups);
    }

    @Override
    public List<T> getOwnMemberRows(boolean includeStaticRows) {
        ArrayList<T> rows = new ArrayList<T>(this.rowMembers);
        if (includeStaticRows) {
            rows.addAll(this.staticRowMembers);
        }
        return Collections.unmodifiableList(rows);
    }

    @Override
    public List<T> getOwnStaticMemberRows() {
        return Collections.unmodifiableList(this.staticRowMembers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List<IRowGroup<T>> list = this.childGroups;
        synchronized (list) {
            for (IRowGroup<T> rowGroup : this.childGroups) {
                rowGroup.clear();
            }
        }
        list = this.rowMembers;
        synchronized (list) {
            for (Object row : new ArrayList<T>(this.rowMembers)) {
                this.removeMemberRow(row);
            }
        }
        list = this.staticRowMembers;
        synchronized (list) {
            for (Object row : new ArrayList<T>(this.staticRowMembers)) {
                this.removeMemberRow(row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> getMemberRows(boolean includeStaticRows) {
        ArrayList<T> memberRows = new ArrayList<T>();
        List<IRowGroup<T>> list = this.childGroups;
        synchronized (list) {
            for (IRowGroup<T> rowGroup : this.childGroups) {
                memberRows.addAll(rowGroup.getMemberRows(includeStaticRows));
            }
        }
        memberRows.addAll(this.getOwnMemberRows(includeStaticRows));
        return Collections.unmodifiableList(memberRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> getStaticMemberRows() {
        ArrayList<T> staticMemberRows = new ArrayList<T>();
        List<IRowGroup<T>> list = this.childGroups;
        synchronized (list) {
            for (IRowGroup<T> rowGroup : this.childGroups) {
                staticMemberRows.addAll(rowGroup.getStaticMemberRows());
            }
        }
        staticMemberRows.addAll(this.getOwnStaticMemberRows());
        return Collections.unmodifiableList(staticMemberRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRowGroup<T> getRowGroupForRow(T row) {
        IRowGroup<T> group = null;
        if (this.getOwnMemberRows(true).contains(row)) {
            group = this;
        } else {
            List<IRowGroup<T>> list = this.childGroups;
            synchronized (list) {
                for (IRowGroup<T> rowGroup : this.childGroups) {
                    group = rowGroup.getRowGroupForRow(row);
                    if (group != null) break;
                }
            }
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        boolean empty = true;
        List<IRowGroup<T>> list = this.childGroups;
        synchronized (list) {
            for (IRowGroup<T> rowGroup : this.childGroups) {
                empty &= rowGroup.isEmpty();
            }
        }
        return empty && this.rowMembers.size() + this.staticRowMembers.size() == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Name      : %s\n", this.getGroupName()));
        sb.append(String.format("Collapsed : %s\n", this.isCollapsed()));
        sb.append("Members   : \n");
        for (T t : this.getOwnMemberRows(false)) {
            sb.append(String.format("%s", t.toString()));
        }
        for (T t : this.getOwnStaticMemberRows()) {
            sb.append(String.format("*%s", t.toString()));
        }
        if (!this.childGroups.isEmpty()) {
            sb.append(String.format("Start Child Groups for [%s] :- \n", this.getGroupName()));
            for (IRowGroup iRowGroup : this.childGroups) {
                sb.append(iRowGroup.toString());
            }
            sb.append(String.format("End Child Groups for [%s]\n", this.getGroupName()));
        }
        return sb.toString();
    }
}

