/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.importer.div.rs232;

import ch.elexis.core.ui.importer.div.rs232.PortEventListener;
import ch.elexis.core.ui.importer.div.rs232.SerialConnectionException;
import ch.elexis.core.ui.importer.div.rs232.SerialParameters;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import gnu.io.CommPortIdentifier;
import gnu.io.DriverManager;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
implements PortEventListener {
    private static final String simulate = null;
    private static Logger log = LoggerFactory.getLogger(Connection.class);
    private CommPortIdentifier portId;
    private SerialPort sPort;
    private boolean bOpen;
    private OutputStream os;
    private InputStream is;
    private final ComPortListener listener;
    private final String myPort;
    private final String[] mySettings;
    private final String name;
    private int frameStart;
    private int frameEnd;
    private int overhang;
    private int checksumBytes;
    private long endTime;
    private int timeToWait;
    private static final int PASS_THRU = 0;
    private static final int AWAIT_START = 1;
    private static final int AWAIT_END = 2;
    private static final int AWAIT_CHECKSUM = 3;
    private static final int AWAIT_LINE = 4;
    private static byte lineSeparator;
    private int state = 0;
    private final StringBuilder sbFrame = new StringBuilder();
    private final StringBuilder sbLine = new StringBuilder();
    private Thread watchdogThread;
    private static boolean isInitialized;

    static {
        if (!isInitialized) {
            DriverManager.getInstance().loadDrivers();
            isInitialized = true;
        }
    }

    public Connection(String portName, String port, String settings, ComPortListener l) {
        this.listener = l;
        this.myPort = port;
        this.mySettings = settings.split(",");
        this.name = portName;
    }

    public boolean connect() {
        SerialParameters sp = new SerialParameters();
        sp.setPortName(this.myPort);
        sp.setBaudRate(this.mySettings[0]);
        sp.setDatabits(this.mySettings[1]);
        sp.setParity(this.mySettings[2]);
        sp.setStopbits(this.mySettings[3]);
        if (this.mySettings.length >= 5 && this.mySettings[4] != null) {
            sp.setFlowControlIn(Integer.parseInt(this.mySettings[4]));
        }
        if (this.mySettings.length >= 6 && this.mySettings[5] != null) {
            sp.setFlowControlOut(Integer.parseInt(this.mySettings[5]));
        }
        try {
            if (simulate != null) {
                final Connection mine = this;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(1000L);
                            String in = FileTool.readTextFile((File)new File(simulate)).replaceAll("\\r\\n", "\r");
                            Connection.this.listener.gotChunk(mine, in);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }).start();
            } else {
                this.sbLine.setLength(0);
                this.openConnection(sp);
            }
            return true;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            ex.printStackTrace();
            return false;
        }
    }

    public void openConnection(SerialParameters parameters) throws SerialConnectionException {
        try {
            this.portId = CommPortIdentifier.getPortIdentifier((String)parameters.getPortName());
        }
        catch (NoSuchPortException e) {
            throw new SerialConnectionException(e.getMessage());
        }
        try {
            this.sPort = (SerialPort)this.portId.open(this.name, 30000);
        }
        catch (PortInUseException e) {
            throw new SerialConnectionException(e.getMessage(), e);
        }
        try {
            this.setConnectionParameters(parameters);
        }
        catch (SerialConnectionException e) {
            this.sPort.close();
            throw e;
        }
        try {
            this.os = this.sPort.getOutputStream();
            this.is = this.sPort.getInputStream();
        }
        catch (IOException e) {
            this.sPort.close();
            throw new SerialConnectionException("Error opening i/o streams");
        }
        try {
            this.sPort.addEventListener((SerialPortEventListener)this);
        }
        catch (TooManyListenersException e) {
            this.sPort.close();
            throw new SerialConnectionException("too many listeners added");
        }
        this.sPort.notifyOnDataAvailable(true);
        this.sPort.notifyOnBreakInterrupt(true);
        try {
            this.sPort.enableReceiveTimeout(30);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            // empty catch block
        }
        this.bOpen = true;
    }

    public void setConnectionParameters(SerialParameters parameters) throws SerialConnectionException {
        int oldBaudRate = this.sPort.getBaudRate();
        int oldDatabits = this.sPort.getDataBits();
        int oldStopbits = this.sPort.getStopBits();
        int oldParity = this.sPort.getParity();
        try {
            this.sPort.setSerialPortParams(parameters.getBaudRate(), parameters.getDatabits(), parameters.getStopbits(), parameters.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            parameters.setBaudRate(oldBaudRate);
            parameters.setDatabits(oldDatabits);
            parameters.setStopbits(oldStopbits);
            parameters.setParity(oldParity);
            throw new SerialConnectionException("Unsupported parameter");
        }
        try {
            this.sPort.setFlowControlMode(parameters.getFlowControlIn() | parameters.getFlowControlOut());
        }
        catch (UnsupportedCommOperationException e) {
            throw new SerialConnectionException("Unsupported flow control");
        }
    }

    public void awaitFrame(int start, int end, int following, int timeout) {
        this.state = 1;
        this.frameStart = start;
        this.frameEnd = end;
        this.overhang = following;
        this.endTime = System.currentTimeMillis() + (long)(timeout * 1000);
        this.watchdogThread = new Thread(new Watchdog());
        this.timeToWait = timeout;
        this.checksumBytes = this.overhang;
        this.watchdogThread.start();
    }

    public void readLine(byte delimiter, int timeout) {
        lineSeparator = delimiter;
        this.state = 4;
        this.endTime = System.currentTimeMillis() + (long)(timeout * 1000);
        this.watchdogThread = new Thread(new Watchdog());
        this.timeToWait = timeout;
        this.watchdogThread.start();
    }

    public void serialEvent(SerialPortEvent e) {
        if (e.getEventType() == 10) {
            this.state = 0;
            this.watchdogThread.interrupt();
            this.listener.gotBreak(this);
        } else {
            try {
                switch (this.state) {
                    case 0: {
                        this.sbFrame.setLength(0);
                        try {
                            int newData;
                            while ((newData = this.is.read()) != -1) {
                                this.sbFrame.append((char)newData);
                            }
                        }
                        catch (IOException ioe) {
                            log.debug("Catching " + ioe.getMessage() + " | See https://redmine.medelexis.ch/issues/3311");
                        }
                        this.listener.gotChunk(this, this.sbFrame.toString());
                        break;
                    }
                    case 1: {
                        int newData;
                        while ((newData = this.is.read()) != -1) {
                            if (newData != this.frameStart) continue;
                            this.state = 2;
                            this.sbFrame.append((char)this.frameStart);
                            this.serialEvent(e);
                        }
                        break;
                    }
                    case 2: {
                        int newData;
                        while ((newData = this.is.read()) != -1) {
                            this.sbFrame.append((char)newData);
                            if (newData != this.frameEnd) continue;
                            this.state = 3;
                            this.serialEvent(e);
                        }
                        this.endTime = System.currentTimeMillis() + (long)this.timeToWait;
                        break;
                    }
                    case 3: {
                        int newData;
                        while (this.overhang > 0 && (newData = this.is.read()) != -1) {
                            this.sbFrame.append((char)newData);
                            --this.overhang;
                        }
                        if (this.overhang == 0) {
                            this.listener.gotChunk(this, this.sbFrame.toString());
                            this.sbFrame.setLength(0);
                            this.watchdogThread.interrupt();
                            this.state = 1;
                            this.overhang = this.checksumBytes;
                            this.serialEvent(e);
                        }
                        break;
                    }
                    case 4: {
                        int newData;
                        while ((newData = this.is.read()) != -1) {
                            if (newData == lineSeparator) {
                                String res = this.sbLine.toString();
                                this.sbLine.setLength(0);
                                this.listener.gotChunk(this, res);
                                continue;
                            }
                            this.sbLine.append((char)newData);
                        }
                        break block2;
                    }
                }
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
            }
        }
    }

    public void close() {
        this.close(5000);
    }

    public void close(final int sleepTime) {
        if (this.watchdogThread != null && this.watchdogThread.isAlive()) {
            this.watchdogThread.interrupt();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(sleepTime);
                    Connection.this.sPort.close();
                    Connection.this.bOpen = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    public boolean isOpen() {
        return this.bOpen;
    }

    public void sendBreak() {
        if (this.sPort != null) {
            this.sPort.sendBreak(1000);
        } else {
            ExHandler.handle((Throwable)new Throwable("sPort is null"));
        }
    }

    public boolean send(String data) {
        try {
            this.os.write(data.getBytes());
            return true;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return false;
        }
    }

    public static String[] getComPorts() {
        ArrayList<String> p = new ArrayList<String>();
        try {
            Enumeration ports = CommPortIdentifier.getPortIdentifiers();
            while (ports.hasMoreElements()) {
                CommPortIdentifier port = (CommPortIdentifier)ports.nextElement();
                p.add(port.getName());
            }
        }
        catch (LinkageError error) {
            SWTHelper.showError((String)"COM Port Initialization Error", (String)(String.valueOf(error.getMessage()) + "\nPlease see log file and/or https://wiki.elexis.info/SerialConfiguration."));
            log.error("COM Port Initialization", (Throwable)error);
        }
        return p.toArray(new String[0]);
    }

    public String getName() {
        return this.name;
    }

    public String getMyPort() {
        return this.myPort;
    }

    public static interface ComPortListener {
        public void gotChunk(Connection var1, String var2);

        public void gotBreak(Connection var1);

        public void timeout();
    }

    class Watchdog
    implements Runnable {
        Watchdog() {
        }

        @Override
        public void run() {
            while (System.currentTimeMillis() < Connection.this.endTime) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
            Connection.this.listener.timeout();
        }
    }
}

