/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.ui.util.Log;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class LaborOrderPulldownMenuCreator
implements IMenuCreator {
    private final String LAB_ORDER_SELECTED_ACTION_ID = "ch.elexis.core.ui.LaborOrder.selectedId";
    private static Log log = Log.get((String)"LaborOrderPulldownMenuCreator");
    List<IAction> actions = new Vector<IAction>();
    Menu menu = null;
    IAction selectedAction = null;

    public LaborOrderPulldownMenuCreator(Shell shell) {
        this.init(shell);
    }

    private void init(Shell shell) {
        List orderActions = Extensions.getClasses((List)Extensions.getExtensions((String)"ch.elexis.core.ui.LaborOrder"), (String)"ToolbarAction", (boolean)false);
        for (IAction action : orderActions) {
            if (action.getId() != null && action.getImageDescriptor() != null && action.getText() != null) {
                this.actions.add(action);
                continue;
            }
            log.log(MessageFormat.format("Missing #id, #imagedescriptor or #text for LaborOrder action: {0}", action.getText()), 3);
        }
        if (this.actions != null && this.actions.size() > 0) {
            String selectedId = CoreHub.localCfg.get("ch.elexis.core.ui.LaborOrder.selectedId", null);
            if (selectedId != null) {
                for (IAction action : this.actions) {
                    if (!selectedId.equals(action.getId())) continue;
                    this.selectedAction = action;
                }
            }
            if (this.selectedAction == null) {
                this.selectedAction = this.actions.get(0);
            }
        }
    }

    public IAction getSelected() {
        return this.selectedAction;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private void select(Control parent, IAction action, Image image) {
        ToolBar toolBar;
        if (parent instanceof ToolBar && (toolBar = (ToolBar)parent).getItemCount() > 0) {
            ToolItem toolItem = toolBar.getItem(0);
            toolItem.setImage(image);
            toolItem.setHotImage(image);
            toolItem.setToolTipText(action.getToolTipText());
            this.selectedAction = action;
            CoreHub.localCfg.set("ch.elexis.core.ui.LaborOrder.selectedId", this.selectedAction.getId());
        }
    }

    public Menu getMenu(final Control parent) {
        if (this.menu == null) {
            this.menu = new Menu(parent);
            for (final IAction action : this.actions) {
                MenuItem menuItem = new MenuItem(this.menu, 8);
                final Image image = action.getImageDescriptor().createImage();
                menuItem.setImage(image);
                menuItem.setText(action.getText());
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        LaborOrderPulldownMenuCreator.this.select(parent, action, image);
                        action.run();
                    }
                });
            }
        }
        return this.menu;
    }

    public IAction getAction() {
        int buttonStyle = 4;
        if (this.actions.size() == 1) {
            buttonStyle = 1;
        }
        Action dropDownAction = new Action("Dropdown", buttonStyle){

            public void run() {
                LaborOrderPulldownMenuCreator.this.getSelected().run();
            }
        };
        dropDownAction.setMenuCreator((IMenuCreator)this);
        return dropDownAction;
    }
}

