/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.importers.multifile.strategy;

import ch.elexis.core.importer.div.importers.HL7Parser;
import ch.elexis.core.importer.div.importers.ILabContactResolver;
import ch.elexis.core.importer.div.importers.IPersistenceHandler;
import ch.elexis.core.importer.div.importers.multifile.strategy.FileImportStrategyUtil;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategy;
import ch.elexis.core.model.ILabOrder;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

public class DefaultHL7ImportStrategy
implements IFileImportStrategy {
    private boolean testMode;
    private boolean moveAfterImport;
    private ILabContactResolver labContactResolver;
    public static final String CFG_IMPORT_ENCDATA = "hl7Parser/importencdata";

    @Override
    public Result<Object> execute(IVirtualFilesystemService.IVirtualFilesystemHandle file, Map<String, Object> context, HL7Parser hl7Parser, IPersistenceHandler persistenceHandler) throws IOException {
        List<ILabOrder> orders;
        Object resultObj;
        IVirtualFilesystemService.IVirtualFilesystemHandle fhAfterMove;
        Result<?> result = null;
        if (this.testMode) {
            result = this.labContactResolver != null ? hl7Parser.importFile(file, null, null, this.labContactResolver, true) : hl7Parser.importFile(file.getAbsolutePath(), true);
            if (this.moveAfterImport) {
                fhAfterMove = FileImportStrategyUtil.moveAfterImport(result.isOK(), file);
                result.addMessage(779, result.isOK() ? Result.SEVERITY.OK : Result.SEVERITY.WARNING, "url", (Object)fhAfterMove.getAbsolutePath());
            }
        } else {
            result = this.labContactResolver != null ? hl7Parser.importFile(file, null, null, this.labContactResolver, false) : hl7Parser.importFile(file.getAbsolutePath(), false);
            if (this.moveAfterImport) {
                fhAfterMove = FileImportStrategyUtil.moveAfterImport(result.isOK(), file);
                result.addMessage(779, result.isOK() ? Result.SEVERITY.OK : Result.SEVERITY.WARNING, "url", (Object)fhAfterMove.getAbsolutePath());
            }
        }
        if ((resultObj = result.get()) instanceof String && (orders = persistenceHandler.getLabOrdersByOrderId((String)resultObj)) != null && !orders.isEmpty()) {
            ILabOrder order = orders.get(0);
            context.put("patient", order.getPatient());
            context.put("labid", order.getResult().getOrigin().getId());
            context.put("group", order.getItem().getGroup());
            context.put("prio", order.getItem().getPriority());
            context.put("time", this.getDate(order.getResult()));
        }
        return result;
    }

    private TimeTool getDate(ILabResult result) {
        LocalDateTime observationTime = result.getObservationTime();
        if (observationTime == null) {
            return new TimeTool(result.getDate());
        }
        return new TimeTool(observationTime);
    }

    @Override
    public void setTestMode(boolean testing) {
        this.testMode = testing;
    }

    @Override
    public IFileImportStrategy setMoveAfterImport(boolean value) {
        this.moveAfterImport = value;
        return this;
    }

    @Override
    public IFileImportStrategy setLabContactResolver(ILabContactResolver resolver) {
        this.labContactResolver = resolver;
        return this;
    }
}

