/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.interfaces.IDiagnose;
import ch.elexis.core.data.interfaces.events.MessageEvent;
import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IDiagnosisReference;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IFreeTextDiagnosis;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.dialogs.FreeTextDiagnoseDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.util.GenericObjectDropTarget;
import ch.elexis.data.FreeTextDiagnose;
import ch.elexis.data.Konsultation;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.statushandlers.StatusManager;

public class DiagnosenDisplay
extends Composite
implements IUnlockable {
    private Table table;
    private TableViewer viewer;
    private final GenericObjectDropTarget dropTarget;
    private IEncounter actEncounter;
    private ToolBar toolBar;
    private TableColumnLayout tableLayout;

    @Optional
    @Inject
    public void udpateEncounter(@UIEventTopic(value="info/elexis/model/update") IEncounter encounter) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed() && encounter != null && encounter.equals(this.actEncounter)) {
            this.viewer.setInput((Object)this.actEncounter.getDiagnoses());
        }
    }

    public void setEnabled(boolean enabled) {
        this.toolBar.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public DiagnosenDisplay(final IWorkbenchPage page, Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        final Label label = new Label((Composite)this, 0);
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)label.getDisplay());
        label.setFont(boldFont);
        label.setText(Messages.DiagnosenDisplay_Diagnoses);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        ToolBarManager toolBarManager = new ToolBarManager(131072);
        Action newAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_NEW.getImageDescriptor();
            }

            public void run() {
                try {
                    page.showView("ch.elexis.DiagnosenView");
                    CodeSelectorHandler.getInstance().setCodeSelectorTarget(DiagnosenDisplay.this.dropTarget);
                }
                catch (Exception ex) {
                    ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.ui", 0, String.valueOf(Messages.DiagnosenDisplay_ErrorStartingCodeSystem) + ex.getMessage(), ex, 2);
                    StatusManager.getManager().handle((IStatus)status, 2);
                }
            }
        };
        newAction.setToolTipText(Messages.DiagnosenDisplay_AddDiagnosis);
        toolBarManager.add((IAction)newAction);
        Action textAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_DOCUMENT_TEXT.getImageDescriptor();
            }

            public void run() {
                String freeText;
                FreeTextDiagnoseDialog ftDialog = new FreeTextDiagnoseDialog(Display.getDefault().getActiveShell());
                if (ftDialog.open() == 0 && StringUtils.isNotBlank((CharSequence)(freeText = ftDialog.getText()))) {
                    IFreeTextDiagnosis diagnosis = (IFreeTextDiagnosis)CoreModelServiceHolder.get().create(IFreeTextDiagnosis.class);
                    diagnosis.setText(freeText);
                    CoreModelServiceHolder.get().save((Identifiable)diagnosis);
                    DiagnosenDisplay.this.actEncounter.addDiagnosis((IDiagnosis)diagnosis);
                    CoreModelServiceHolder.get().save((Identifiable)DiagnosenDisplay.this.actEncounter);
                    DiagnosenDisplay.this.viewer.setInput((Object)DiagnosenDisplay.this.actEncounter.getDiagnoses());
                }
            }
        };
        toolBarManager.add((IAction)textAction);
        textAction.setToolTipText(Messages.DiagnosenDisplay_AddTextDiagnosis);
        this.toolBar = toolBarManager.createControl((Composite)this);
        this.toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.tableLayout = new TableColumnLayout();
        Composite tableComposite = new Composite((Composite)this, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        tableComposite.setLayout((Layout)this.tableLayout);
        this.viewer = new TableViewer(tableComposite, 68354);
        this.table = this.viewer.getTable();
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setMenu(this.createDgMenu());
        this.createColumns();
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IStructuredSelection selection;
                int clickedIndex = -1;
                int width = 0;
                TableColumn[] columns = DiagnosenDisplay.this.table.getColumns();
                int i = 0;
                while (i < columns.length) {
                    TableColumn tc = columns[i];
                    if (width < e.x && e.x < width + tc.getWidth()) {
                        clickedIndex = i;
                        break;
                    }
                    width += tc.getWidth();
                    ++i;
                }
                if (clickedIndex != -1 && clickedIndex == 3 && !(selection = DiagnosenDisplay.this.viewer.getStructuredSelection()).isEmpty()) {
                    if (selection.getFirstElement() instanceof IDiagnosis) {
                        DiagnosenDisplay.this.actEncounter.removeDiagnosis((IDiagnosis)selection.getFirstElement());
                        CoreModelServiceHolder.get().save((Identifiable)DiagnosenDisplay.this.actEncounter);
                    }
                    DiagnosenDisplay.this.setEncounter(DiagnosenDisplay.this.actEncounter);
                }
            }
        });
        this.dropTarget = new GenericObjectDropTarget(Messages.DiagnosenDisplay_DiagnoseTarget, (Control)this.table, new DropReceiver()){

            @Override
            protected Control getHighLightControl() {
                return DiagnosenDisplay.this;
            }
        };
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int width = DiagnosenDisplay.this.getBounds().width;
                int labelWidth = label.getBounds().width;
                int toolBarWidth = DiagnosenDisplay.this.toolBar.getBounds().width;
                if (width < labelWidth + toolBarWidth) {
                    if (label.getVisible()) {
                        GridData labeldata = (GridData)label.getLayoutData();
                        labeldata.exclude = true;
                        label.setVisible(false);
                        GridData toolData = (GridData)DiagnosenDisplay.this.toolBar.getLayoutData();
                        toolData.grabExcessHorizontalSpace = true;
                    }
                } else if (!label.getVisible()) {
                    GridData labeldata = (GridData)label.getLayoutData();
                    labeldata.exclude = false;
                    label.setVisible(true);
                    GridData toolData = (GridData)DiagnosenDisplay.this.toolBar.getLayoutData();
                    toolData.grabExcessHorizontalSpace = false;
                }
            }
        });
    }

    public void clear() {
        this.actEncounter = null;
        this.viewer.setInput(Collections.emptyList());
    }

    public void setEncounter(IEncounter encounter) {
        this.actEncounter = encounter;
        this.table.getColumn(0).setWidth(0);
        if (this.viewer != null && encounter != null) {
            this.viewer.setInput((Object)encounter.getDiagnoses());
        }
    }

    private void createColumns() {
        String[] titles = new String[]{"", Messages.Display_Column_Code, Messages.Display_Column_Designation, ""};
        int[] nArray = new int[4];
        nArray[1] = 15;
        nArray[2] = 70;
        nArray[3] = 15;
        int[] weights = nArray;
        TableViewerColumn col = this.createTableViewerColumn(titles[0], weights[0], 0, 16384);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }
        });
        col = this.createTableViewerColumn(titles[1], weights[1], 1, 16384);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDiagnose) {
                    IDiagnose diagnosis = (IDiagnose)element;
                    if (!(diagnosis instanceof FreeTextDiagnose)) {
                        return diagnosis.getCode();
                    }
                } else if (element instanceof IDiagnosis) {
                    IDiagnosisReference diagnosisRef;
                    IDiagnosis diagnosis = (IDiagnosis)element;
                    if (diagnosis instanceof IDiagnosisReference && (diagnosisRef = (IDiagnosisReference)element).getReferredClass().toLowerCase().contains("freetext")) {
                        return "";
                    }
                    return diagnosis.getCode();
                }
                return "";
            }
        });
        col = this.createTableViewerColumn(titles[2], weights[2], 2, 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDiagnose) {
                    IDiagnose diagnosis = (IDiagnose)element;
                    return diagnosis.getText();
                }
                if (element instanceof IDiagnosis) {
                    IDiagnosis diagnosis = (IDiagnosis)element;
                    return diagnosis.getText();
                }
                return "";
            }
        });
        col = this.createTableViewerColumn(titles[3], weights[3], 3, 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                return Images.IMG_DELETE.getImage();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int weight, int colNumber, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(false);
        this.tableLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight));
        return viewerColumn;
    }

    private Menu createDgMenu() {
        MenuManager contextMenuManager = new MenuManager();
        contextMenuManager.setRemoveAllWhenShown(true);
        contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                final IStructuredSelection selection = DiagnosenDisplay.this.viewer.getStructuredSelection();
                if (!selection.isEmpty()) {
                    manager.add((IAction)new Action(){

                        public ImageDescriptor getImageDescriptor() {
                            return Images.IMG_DELETE.getImageDescriptor();
                        }

                        public String getText() {
                            return Messages.DiagnosenDisplay_RemoveDiagnoses;
                        }

                        public void run() {
                            for (Object object : selection.toList()) {
                                if (!(object instanceof IDiagnosis)) continue;
                                (this).DiagnosenDisplay.this.actEncounter.removeDiagnosis((IDiagnosis)object);
                                CoreModelServiceHolder.get().save((Identifiable)(this).DiagnosenDisplay.this.actEncounter);
                            }
                            DiagnosenDisplay.this.setEncounter((this).DiagnosenDisplay.this.actEncounter);
                        }
                    });
                }
            }
        });
        return contextMenuManager.createContextMenu((Control)this.table);
    }

    @Override
    public void setUnlocked(boolean unlocked) {
        this.setEnabled(unlocked);
        this.redraw();
    }

    private final class DropReceiver
    implements GenericObjectDropTarget.IReceiver {
        private DropReceiver() {
        }

        @Override
        public void dropped(List<Object> list, DropTargetEvent e) {
            if (this.accept(list)) {
                for (Object object : list) {
                    if (object instanceof IDiagnose) {
                        Konsultation actKons = Konsultation.load((String)DiagnosenDisplay.this.actEncounter.getId());
                        actKons.addDiagnose((IDiagnose)object);
                        continue;
                    }
                    if (!(object instanceof IDiagnosis)) continue;
                    IDiagnosis diagnosis = (IDiagnosis)object;
                    if (EncounterServiceHolder.get().isEditable(DiagnosenDisplay.this.actEncounter)) {
                        DiagnosenDisplay.this.actEncounter.addDiagnosis(diagnosis);
                        CoreModelServiceHolder.get().save((Identifiable)DiagnosenDisplay.this.actEncounter);
                        continue;
                    }
                    MessageEvent.fireError((String)"Fall geschlossen", (String)"Diese Konsultation geh\u00f6rt zu einem abgeschlossenen Fall");
                }
                DiagnosenDisplay.this.viewer.setInput((Object)DiagnosenDisplay.this.actEncounter.getDiagnoses());
            }
        }

        @Override
        public boolean accept(List<Object> list) {
            if (DiagnosenDisplay.this.actEncounter == null) {
                return false;
            }
            for (Object object : list) {
                if (object instanceof IDiagnose || object instanceof IDiagnosis) continue;
                return false;
            }
            return true;
        }
    }
}

