/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util.viewers;

import ch.elexis.core.ui.util.Messages;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;

public class DefaultContentProvider
implements ViewerConfigurer.ICommonViewerContentProvider {
    protected Class source;
    protected CommonViewer cv;
    protected String[] order = null;
    protected boolean reverse = false;

    public DefaultContentProvider(CommonViewer c, Class clazz) {
        this.source = clazz;
        this.cv = c;
    }

    public DefaultContentProvider(CommonViewer c, Class clazz, String[] o, boolean rev) {
        this.source = clazz;
        this.cv = c;
        this.order = o;
        this.reverse = rev;
    }

    @Override
    public void startListening() {
        ViewerConfigurer.ControlFieldProvider cfp = this.cv.getConfigurer().getControlFieldProvider();
        if (cfp != null) {
            cfp.addChangeListener(this);
        }
    }

    @Override
    public void stopListening() {
        ViewerConfigurer.ControlFieldProvider cfp = this.cv.getConfigurer().getControlFieldProvider();
        if (cfp != null) {
            cfp.removeChangeListener(this);
        }
    }

    public Object[] getElements(Object inputElement) {
        List list;
        ViewerConfigurer.ControlFieldProvider cfp;
        Query qbe = new Query(this.source);
        if (this.order != null) {
            qbe.orderBy(this.reverse, this.order);
        }
        if ((cfp = this.cv.getConfigurer().getControlFieldProvider()) != null) {
            cfp.setQuery((Query<? extends PersistentObject>)qbe);
        }
        if ((list = qbe.execute()) == null) {
            return new String[]{Messages.NoDataAvailable};
        }
        return list.toArray();
    }

    public void dispose() {
        this.stopListening();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    @Override
    public void changed(HashMap<String, String> values) {
        this.cv.notify(CommonViewer.Message.update);
        if (this.cv.getConfigurer().getControlFieldProvider().isEmpty()) {
            this.cv.notify(CommonViewer.Message.empty);
        } else {
            this.cv.notify(CommonViewer.Message.notempty);
        }
    }

    @Override
    public void reorder(String field) {
        this.cv.notify(CommonViewer.Message.update);
    }

    @Override
    public void selected() {
    }

    @Override
    public void init() {
    }
}

