/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.e4.jface.preference.URIFieldEditor;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.services.LocalDocumentServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.data.Brief;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.LoggerFactory;

public class Texterstellung
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ControlDecoration externPathDeco;
    private Label allExtern;

    public Texterstellung() {
        super(1);
        this.setPreferenceStore(new SettingsPreferenceStore(CoreHub.localCfg));
        this.setDescription(Messages.Texterstellung_TextProcessor);
    }

    protected void createFieldEditors() {
        List list = Extensions.getExtensions((String)"ch.elexis.core.ui.Text");
        this.addField((FieldEditor)new BooleanFieldEditor("briefe/Textmodul_Support_Legacy", Messages.Texterstellung_Support_Legacy, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("briefe/rename_with_f2", Messages.Texterstellung_Rename_with_F2, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("briefe/Textmodul_Edit_Local", Messages.Texterstellung_texteditlocaldesc, this.getFieldEditorParent()));
        if (LocalDocumentServiceHolder.getService().isPresent()) {
            final ILocalDocumentService documentService = LocalDocumentServiceHolder.getService().get();
            Composite compBackupDir = new Composite(this.getFieldEditorParent(), 0);
            compBackupDir.setLayout((Layout)new GridLayout(2, false));
            compBackupDir.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            new Label(compBackupDir, 0).setText(Messages.Texterstellung_backupdir);
            Text backupDir = new Text(compBackupDir, 2048);
            backupDir.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            backupDir.setText(String.valueOf(documentService.getDocumentCachePath()) + File.separator + "backup");
            backupDir.setEditable(false);
            Button restore = new Button(compBackupDir, 8);
            restore.setText("wiederherstellen");
            restore.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Texterstellung.this.restoreLocalDocuments(documentService);
                }
            });
        }
        String[][] rows = new String[list.size()][];
        int i = 0;
        for (IConfigurationElement ice : list) {
            rows[i] = new String[2];
            rows[i][1] = ice.getAttribute("name");
            rows[i][0] = String.valueOf(Integer.toString(i)) + " : " + rows[i][1];
            ++i;
        }
        this.addField((FieldEditor)new RadioGroupFieldEditor("briefe/Textmodul", Messages.Texterstellung_ExternalProgram, 2, rows, this.getFieldEditorParent()));
        Composite compExtern = new Composite(this.getFieldEditorParent(), 0);
        compExtern.setLayout((Layout)new GridLayout(2, false));
        compExtern.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        final Button check = new Button(compExtern, 32);
        check.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        check.setText(Messages.Texterstellung_external_save);
        check.setSelection(ConfigServiceHolder.getGlobal((String)"briefe/Textmodul_Extern_File", (boolean)false));
        check.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigServiceHolder.setGlobal((String)"briefe/Textmodul_Extern_File", (boolean)check.getSelection());
                Texterstellung.this.allExtern.setEnabled(check.getSelection());
                if (Texterstellung.this.externPathDeco != null) {
                    Texterstellung.this.externPathDeco.hide();
                }
            }
        });
        Composite comp = new Composite(compExtern, 0);
        comp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Combo comboOs = new Combo(comp, 0);
        ComboViewer cvOs = new ComboViewer(comboOs);
        comboOs.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        cvOs.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        cvOs.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((CoreUtil.OS)element).name();
            }
        });
        cvOs.setInput((Object)CoreUtil.OS.values());
        URIFieldEditor storePath = new URIFieldEditor("briefe/Textmodul_Extern_File_Path", "", comp);
        storePath.setPreferenceStore((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL));
        storePath.setEmptyStringAllowed(true);
        this.addField((FieldEditor)storePath);
        cvOs.addSelectionChangedListener(event -> {
            String preferenceName;
            CoreUtil.OS selection = (CoreUtil.OS)event.getStructuredSelection().getFirstElement();
            switch (selection) {
                case MAC: {
                    preferenceName = "briefe/Textmodul_Extern_File_Path_MAC";
                    break;
                }
                case WINDOWS: {
                    preferenceName = "briefe/Textmodul_Extern_File_Path_WINDOWS";
                    break;
                }
                case LINUX: {
                    preferenceName = "briefe/Textmodul_Extern_File_Path_LINUX";
                    break;
                }
                default: {
                    preferenceName = "briefe/Textmodul_Extern_File_Path";
                }
            }
            storePath.store();
            storePath.setPreferenceName(preferenceName);
            storePath.load();
        });
        this.allExtern = new Label(compExtern, 64);
        this.allExtern.setText(Messages.Texterstellung_save_all_letters_externally);
        this.allExtern.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        cvOs.setSelection((ISelection)new StructuredSelection((Object)CoreUtil.getOperatingSystemType()));
    }

    public void init(IWorkbench workbench) {
    }

    private void restoreLocalDocuments(ILocalDocumentService documentService) {
        File backupDir = new File(String.valueOf(documentService.getDocumentCachePath()) + File.separator + "backup");
        if (backupDir.exists()) {
            HashMap<File, Brief> existing = new HashMap<File, Brief>();
            File[] fileArray = backupDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                Brief loaded;
                File file = fileArray[n2];
                String id = this.getBriefId(file);
                if (StringUtils.isNotBlank((CharSequence)id) && (loaded = Brief.load((String)id)).exists()) {
                    existing.put(file, loaded);
                }
                ++n2;
            }
            if (existing.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Briefe wiederherstellen", (String)"Es wurden keine wiederherstellbaren Briefe gefunden");
            } else {
                Date fileFrom = new Date(existing.keySet().stream().mapToLong(f -> f.lastModified()).min().getAsLong());
                Date fileTo = new Date(existing.keySet().stream().mapToLong(f -> f.lastModified()).max().getAsLong());
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)"Briefe wiederherstellen", (String)("Sollen die " + existing.size() + " Briefe aus Datei(en) vom " + dateFormat.format(fileFrom) + " bis " + dateFormat.format(fileTo) + " wiederhergestellt werden?"))) {
                    for (File backupFile : existing.keySet()) {
                        Brief brief = (Brief)existing.get(backupFile);
                        try {
                            Throwable throwable = null;
                            Object var11_15 = null;
                            try (FileInputStream fin = new FileInputStream(backupFile);){
                                byte[] contentToStore = new byte[(int)backupFile.length()];
                                fin.read(contentToStore);
                                brief.save(contentToStore, FilenameUtils.getExtension((String)backupFile.getName()));
                                backupFile.delete();
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error restoring local backup", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private String getBriefId(File file) {
        String filename = file.getName();
        int startIndex = filename.lastIndexOf(91);
        int endIndex = filename.lastIndexOf(93);
        if (startIndex != -1 && endIndex != -1 && startIndex < endIndex) {
            return filename.substring(startIndex + 1, endIndex);
        }
        return null;
    }
}

