/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.rgw.tools.StringTool;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.commands.ParameterValuesException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handler {
    protected static Logger log = LoggerFactory.getLogger(Handler.class);
    private static final String STR_MONITOR = "monitor";
    private static final String STR_PARAM = "param";
    private static HashMap<String, Object> paramMap = new HashMap();
    public static final String DEFAULTPARAM = "ch.elexis.commands.defaultParameter";

    public static Object executeWithProgress(IViewSite origin, String commandID, Object param, IProgressMonitor monitor) {
        HashMap<String, Object> hp = new HashMap<String, Object>();
        hp.put(STR_PARAM, param);
        hp.put(STR_MONITOR, monitor);
        return Handler.execute(origin, commandID, hp);
    }

    public static Object execute(IViewSite origin, String commandID, Object param) {
        HashMap<String, Object> hp = new HashMap<String, Object>();
        if (param != null) {
            hp.put(STR_PARAM, param);
        }
        return Handler.execute(origin, commandID, hp);
    }

    public static Object getParam(ExecutionEvent eev) {
        HashMap map;
        Map params = eev.getParameters();
        String np = (String)params.get(DEFAULTPARAM);
        if (np != null && (map = (HashMap)Handler.getParam(np)) != null) {
            return map.get(STR_PARAM);
        }
        return null;
    }

    public static IProgressMonitor getMonitor(ExecutionEvent eev) {
        Map params = eev.getParameters();
        String np = (String)params.get(DEFAULTPARAM);
        HashMap map = (HashMap)Handler.getParam(np);
        if (map != null) {
            return (IProgressMonitor)map.get(STR_MONITOR);
        }
        return null;
    }

    public static Object getParam(String paramName) {
        Object ret = paramMap.get(paramName);
        if (ret != null) {
            paramMap.remove(paramName);
        }
        return ret;
    }

    private static Object execute(IViewSite origin, String commandID, Map<String, Object> params) {
        if (origin == null) {
            log.error("origin is null");
            return null;
        }
        IHandlerService handlerService = (IHandlerService)origin.getService(IHandlerService.class);
        ICommandService cmdService = (ICommandService)origin.getService(ICommandService.class);
        try {
            Command command = cmdService.getCommand(commandID);
            String name = StringTool.unique((String)"CommandHandler");
            paramMap.put(name, params);
            Parameterization px = new Parameterization((IParameter)new DefaultParameter(), name);
            ParameterizedCommand parmCommand = new ParameterizedCommand(command, new Parameterization[]{px});
            return handlerService.executeCommand(parmCommand, null);
        }
        catch (Exception ex) {
            throw new RuntimeException("add.command not found");
        }
    }

    static class DefaultParameter
    implements IParameter {
        DefaultParameter() {
        }

        public String getId() {
            return Handler.DEFAULTPARAM;
        }

        public String getName() {
            return Handler.STR_PARAM;
        }

        public IParameterValues getValues() throws ParameterValuesException {
            return new IParameterValues(){

                public Map getParameterValues() {
                    return new HashMap();
                }
            };
        }

        public boolean isOptional() {
            return true;
        }
    }
}

