/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.model;

import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ContextServiceHolder;
import java.util.Map;

public abstract class AbstractBeanAdapter<T extends IFinding> {
    protected T finding;
    protected boolean autoSave;

    protected void init() {
        if (ContextServiceHolder.get().getActivePatient().isPresent()) {
            this.finding.setPatientId(((IPatient)ContextServiceHolder.get().getActivePatient().get()).getId());
        }
    }

    public AbstractBeanAdapter<T> autoSave(boolean value) {
        this.autoSave = value;
        return this;
    }

    public String getText() {
        return this.finding.getText().orElse("");
    }

    public void setText(String text) {
        this.finding.setText(text);
        this.autoSave();
    }

    public void addStringExtension(String theUrl, String theValue) {
        this.finding.addStringExtension(theUrl, theValue);
        this.autoSave();
    }

    public Map<String, String> getStringExtensions() {
        return this.finding.getStringExtensions();
    }

    public String getLabel() {
        return this.finding.getLabel();
    }

    protected void autoSave() {
        if (this.autoSave) {
            this.save();
        }
    }

    protected void save() {
        FindingsServiceComponent.getService().saveFinding(this.finding);
    }
}

