/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.id.ElexisIdGenerator;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="TARMED_GROUP")
@EntityListeners(value={EntityWithIdListener.class})
public class TarmedGroup
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    public static final Object SERVICES_SEPARATOR = "|";
    protected Long lastupdate;
    @Id
    @GeneratedValue(generator="system-uuid")
    @Column(unique=true, nullable=false, length=25)
    private String id = ElexisIdGenerator.generateId();
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted = false;
    @Column(length=32)
    private String groupName;
    @Column(name="services")
    @Lob
    private String rawServices;
    @Column(length=3)
    private String law;
    @Column
    private LocalDate validFrom;
    @Column
    private LocalDate validTo;
    static final long serialVersionUID = -3795526948389864656L;

    public String getGroupName() {
        return this._persistence_get_groupName();
    }

    public void setGroupName(String groupName) {
        this._persistence_set_groupName(groupName);
    }

    public String getRawServices() {
        return this._persistence_get_rawServices();
    }

    public void setRawServices(String rawServices) {
        this._persistence_set_rawServices(rawServices);
    }

    public String getLaw() {
        return this._persistence_get_law();
    }

    public void setLaw(String law) {
        this._persistence_set_law(law);
    }

    public LocalDate getValidFrom() {
        return this._persistence_get_validFrom();
    }

    public void setValidFrom(LocalDate validFrom) {
        this._persistence_set_validFrom(validFrom);
    }

    public LocalDate getValidTo() {
        return this._persistence_get_validTo();
    }

    public void setValidTo(LocalDate validTo) {
        this._persistence_set_validTo(validTo);
    }

    @Transient
    public String getCode() {
        return this.getGroupName();
    }

    @Transient
    public boolean validAt(TimeTool validTime) {
        TimeTool validFrom = new TimeTool(this.getValidFrom());
        TimeTool validTo = new TimeTool(this.getValidTo());
        return validTime.isAfterOrEqual(validFrom) && validTime.isBeforeOrEqual(validTo);
    }

    @Transient
    public List<String> getServices() {
        String value = this.getRawServices();
        if (value != null && !value.isEmpty()) {
            String[] parts = value.split("\\" + SERVICES_SEPARATOR);
            return Arrays.asList(parts);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TarmedGroup();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "groupName") {
            return this.groupName;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "law") {
            return this.law;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "validFrom") {
            return this.validFrom;
        }
        if (string == "rawServices") {
            return this.rawServices;
        }
        if (string == "validTo") {
            return this.validTo;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "groupName") {
            this.groupName = (String)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "law") {
            this.law = (String)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "validFrom") {
            this.validFrom = (LocalDate)object;
            return;
        }
        if (string == "rawServices") {
            this.rawServices = (String)object;
            return;
        }
        if (string == "validTo") {
            this.validTo = (LocalDate)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_groupName() {
        this._persistence_checkFetched("groupName");
        return this.groupName;
    }

    public void _persistence_set_groupName(String string) {
        this._persistence_checkFetchedForSet("groupName");
        this._persistence_propertyChange("groupName", this.groupName, string);
        this.groupName = string;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public String _persistence_get_law() {
        this._persistence_checkFetched("law");
        return this.law;
    }

    public void _persistence_set_law(String string) {
        this._persistence_checkFetchedForSet("law");
        this._persistence_propertyChange("law", this.law, string);
        this.law = string;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public LocalDate _persistence_get_validFrom() {
        this._persistence_checkFetched("validFrom");
        return this.validFrom;
    }

    public void _persistence_set_validFrom(LocalDate localDate) {
        this._persistence_checkFetchedForSet("validFrom");
        this._persistence_propertyChange("validFrom", this.validFrom, localDate);
        this.validFrom = localDate;
    }

    public String _persistence_get_rawServices() {
        this._persistence_checkFetched("rawServices");
        return this.rawServices;
    }

    public void _persistence_set_rawServices(String string) {
        this._persistence_checkFetchedForSet("rawServices");
        this._persistence_propertyChange("rawServices", this.rawServices, string);
        this.rawServices = string;
    }

    public LocalDate _persistence_get_validTo() {
        this._persistence_checkFetched("validTo");
        return this.validTo;
    }

    public void _persistence_set_validTo(LocalDate localDate) {
        this._persistence_checkFetchedForSet("validTo");
        this._persistence_propertyChange("validTo", this.validTo, localDate);
        this.validTo = localDate;
    }
}

