/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.ui;

import ch.elexis.core.jpa.entitymanager.ui.IDatabaseUpdateUi;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component
public class DatabaseUpdateUi
implements IDatabaseUpdateUi {
    private Shell shell;
    private Label messageLabel;
    private ProgressIndicator progressIndicator;
    private boolean isExecuting;

    private void createAndOpenShell(Display display) {
        this.shell = display.getActiveShell() != null ? new Shell(display.getActiveShell(), 65540) : new Shell(display, 65540);
        this.shell.setText("Database Update");
        this.shell.setLayout((Layout)new FillLayout());
        Composite contentComposite = new Composite((Composite)this.shell, 0);
        contentComposite.setLayout((Layout)new GridLayout());
        this.messageLabel = new Label(contentComposite, 16448);
        this.messageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.progressIndicator = new ProgressIndicator(contentComposite);
        this.progressIndicator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.shell.pack();
        this.shell.open();
        Rectangle displayBounds = display.getBounds();
        this.shell.setLocation(displayBounds.width / 2 - this.shell.getBounds().width / 2, displayBounds.height / 2 + this.shell.getBounds().height / 2 + 150);
        this.runEventLoop();
    }

    public void closeProgress() {
        Display display = Display.getDefault();
        display.syncExec(() -> {
            if (this.shell != null) {
                this.shell.dispose();
                this.shell = null;
            }
        });
    }

    public void openProgress() {
        Display display = Display.getDefault();
        display.syncExec(() -> {
            if (this.shell == null) {
                this.createAndOpenShell(display);
            }
            this.progressIndicator.beginAnimatedTask();
            this.messageLabel.setText("Database Update");
            this.shell.pack();
        });
    }

    public void execute(Runnable updateRunnable) {
        try {
            this.isExecuting = true;
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.execute(updateRunnable);
            executor.execute(() -> {
                this.isExecuting = false;
            });
            executor.shutdown();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass());
        }
    }

    public void executeWithProgress(Runnable updateRunnable) {
        this.openProgress();
        this.execute(updateRunnable);
        while (this.isExecuting()) {
            this.runEventLoop();
        }
        this.closeProgress();
    }

    public boolean isExecuting() {
        return this.isExecuting;
    }

    public void runEventLoop() {
        Display display = Display.getDefault();
        while (display.readAndDispatch()) {
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

