/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.eenv;

import ch.elexis.core.eenv.IElexisEnvironmentService;
import ch.elexis.core.eenv.IOcrMyPdfService;
import ch.elexis.core.services.eenv.IRemoteOcrMyPdfService;
import ch.elexis.core.services.eenv.OcrMyPdfClientConfig;
import com.eclipsesource.jaxrs.consumer.ConsumerFactory;
import com.eclipsesource.jaxrs.consumer.RequestException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.Configuration;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class OcrMyPdfService
implements IOcrMyPdfService {
    @Reference
    private IElexisEnvironmentService elexisEnvironmentService;
    private IRemoteOcrMyPdfService remoteOcrMyPdfService;
    private final String PARAMS = "-l deu";

    @Activate
    public void activate() {
        try {
            String ocrMyPdfUrl = this.elexisEnvironmentService.getOcrMyPdfBaseUrl();
            this.remoteOcrMyPdfService = (IRemoteOcrMyPdfService)ConsumerFactory.createConsumer((String)ocrMyPdfUrl, (Configuration)new OcrMyPdfClientConfig(), IRemoteOcrMyPdfService.class);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).warn("Error activating service", (Throwable)e);
        }
    }

    public synchronized byte[] performOcr(byte[] in, String parameters) throws IOException, IOcrMyPdfService.OcrMyPdfException {
        if (in == null) {
            throw new IllegalArgumentException("null");
        }
        String params = parameters != null ? parameters : "-l deu";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FormDataMultiPart form = new FormDataMultiPart();){
                form.bodyPart((BodyPart)new StreamDataBodyPart("file", (InputStream)new ByteArrayInputStream(in), "filename.pdf"));
                form.field("params", params);
                InputStream performOcr = this.remoteOcrMyPdfService.performOcr(form);
                return IOUtils.toByteArray((InputStream)performOcr);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RequestException re) {
            if (re.getStatus() == 400 && re.getMessage().contains("already")) {
                return in;
            }
            if (re.getStatus() == 400 && re.getMessage().contains("encrypted")) {
                throw new IOcrMyPdfService.OcrMyPdfException(IOcrMyPdfService.OcrMyPdfException.TYPE.ENCRYPTED_FILE);
            }
            if (re.getStatus() == 400 && re.getMessage().contains("dynamic XFA")) {
                throw new IOcrMyPdfService.OcrMyPdfException(IOcrMyPdfService.OcrMyPdfException.TYPE.UNREADABLE_XFA_FORM_FILE);
            }
            if (re.getStatus() == 400) {
                throw new IOcrMyPdfService.OcrMyPdfException(IOcrMyPdfService.OcrMyPdfException.TYPE.OTHER, re.getMessage());
            }
            if (re.getStatus() == 413) {
                throw new IOcrMyPdfService.OcrMyPdfException(IOcrMyPdfService.OcrMyPdfException.TYPE.OTHER, "(HTTP 413) PDF is too large.");
            }
            throw new IllegalStateException("invalid state " + re.getStatus() + ": " + re.getMessage(), re);
        }
    }
}

