/*
 * Decompiled with CFR 0.152.
 */
package com.jsigle.noa;

import ch.elexis.core.ui.util.Log;
import ch.rgw.tools.ExHandler;
import com.sun.star.beans.XPropertySet;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.view.PrintJobEvent;
import com.sun.star.view.PrintableState;
import com.sun.star.view.XPrintJobListener;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public class OOPrinter {
    private XComponentLoader xCompLoader = null;
    XComponentContext xContext;
    XMultiComponentFactory xMCF;
    static Log log = Log.get((String)"OOPrinter");

    public boolean init() {
        try {
            this.xContext = Bootstrap.bootstrap();
            this.xMCF = this.xContext.getServiceManager();
            if (this.xMCF != null) {
                this.xCompLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)this.xMCF.createInstanceWithContext("com.sun.star.frame.Desktop", this.xContext));
                return this.xCompLoader != null;
            }
            return false;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return false;
        }
    }

    public static boolean setPrinterTray(XTextDocument doc, String tray) throws Exception {
        XText xText = doc.getText();
        XTextCursor cr = xText.createTextCursor();
        XPropertySet xTextCursorProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)cr);
        String pageStyleName = xTextCursorProps.getPropertyValue("PageStyleName").toString();
        XStyleFamiliesSupplier xSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)doc);
        XNameAccess xFamilies = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xSupplier.getStyleFamilies());
        XNameContainer xFamily = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)xFamilies.getByName("PageStyles"));
        XStyle xStyle = (XStyle)UnoRuntime.queryInterface(XStyle.class, (Object)xFamily.getByName(pageStyleName));
        XPropertySet xStyleProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xStyle);
        try {
            xStyleProps.setPropertyValue("PrinterPaperTray", (Object)tray);
            return true;
        }
        catch (Exception ex) {
            String possible = (String)xStyleProps.getPropertyValue("PrinterPaperTray");
            log.log("Could not set Tray to " + tray + " try " + possible, 2);
            return false;
        }
    }

    public static boolean checkExistsPrinter(String printer) {
        boolean exists = true;
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
        int i = 0;
        while (i < services.length) {
            if (services[i].getName().trim().equals(printer.trim())) {
                return exists;
            }
            ++i;
        }
        return !exists;
    }

    static class MyXPrintJobListener
    implements XPrintJobListener {
        private PrintableState status = null;

        MyXPrintJobListener() {
        }

        public PrintableState getStatus() {
            return this.status;
        }

        public void setStatus(PrintableState status) {
            this.status = status;
        }

        public void printJobEvent(PrintJobEvent printJobEvent) {
            if (printJobEvent.State == PrintableState.JOB_COMPLETED) {
                System.out.println("JOB_COMPLETED");
                this.setStatus(PrintableState.JOB_COMPLETED);
            }
            if (printJobEvent.State == PrintableState.JOB_ABORTED) {
                System.out.println("JOB_ABORTED");
                this.setStatus(PrintableState.JOB_ABORTED);
            }
            if (printJobEvent.State == PrintableState.JOB_FAILED) {
                System.out.println("JOB_FAILED");
                this.setStatus(PrintableState.JOB_FAILED);
                return;
            }
            if (printJobEvent.State == PrintableState.JOB_SPOOLED) {
                System.out.println("JOB_SPOOLED");
                this.setStatus(PrintableState.JOB_SPOOLED);
            }
            if (printJobEvent.State == PrintableState.JOB_SPOOLING_FAILED) {
                System.out.println("JOB_SPOOLING_FAILED");
                this.setStatus(PrintableState.JOB_SPOOLING_FAILED);
                return;
            }
            if (printJobEvent.State == PrintableState.JOB_STARTED) {
                System.out.println("JOB_STARTED");
                this.setStatus(PrintableState.JOB_STARTED);
                return;
            }
        }

        public void disposing(EventObject eventObject) {
            System.out.println("disposing");
        }
    }
}

