/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa.test;

import ag.ion.bion.officelayer.application.IOfficeApplication;
import ag.ion.bion.officelayer.application.OfficeApplicationException;
import ag.ion.bion.officelayer.application.OfficeApplicationRuntime;
import ag.ion.bion.officelayer.desktop.IFrame;
import ag.ion.bion.officelayer.document.DocumentDescriptor;
import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.document.IDocumentDescriptor;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class OfficeBeanTest
extends TestCase {
    private static Logger LOGGER = Logger.getLogger("ag.ion");
    private IDocument document = null;
    private File file = null;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("NOA Office Bean Test");
            System.out.println("-------------------");
            System.out.println("Usage:");
            System.out.println("OfficeBeanTest <OfficeHomePath>");
        } else {
            LogManager.getLogManager().reset();
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.FINEST);
            LOGGER.addHandler(consoleHandler);
            LOGGER.setLevel(Level.FINEST);
            try {
                FileHandler fileHandler = new FileHandler("log.xml");
                fileHandler.setLevel(Level.FINEST);
                LOGGER.addHandler(fileHandler);
            }
            catch (Throwable fileHandler) {
                // empty catch block
            }
            OfficeBeanTest testOfficeBean = new OfficeBeanTest();
            testOfficeBean.test(args[0]);
        }
    }

    public void testOfficeBean() {
        OfficeBeanTest testOfficeBean = new OfficeBeanTest();
        testOfficeBean.test("C:\\Programme\\OpenOffice.org 2.0");
    }

    public void test(String officeHome) {
        System.out.println("NOA Office Bean Test");
        System.out.println("Office home: " + officeHome);
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("type", "local");
        hashMap.put("home", officeHome);
        try {
            System.out.println("Activating OpenOffice.org connection ...");
            final IOfficeApplication application = OfficeApplicationRuntime.getApplication(hashMap);
            application.activate();
            final Frame frame = new Frame();
            frame.setVisible(true);
            frame.setSize(400, 400);
            frame.validate();
            Panel panel = new Panel(new BorderLayout());
            frame.add(panel);
            panel.setVisible(true);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    frame.dispose();
                    OfficeBeanTest.this.document.close();
                    OfficeBeanTest.this.file.delete();
                    try {
                        System.out.println("Deactivating OpenOffice.org connection ...");
                        application.deactivate();
                    }
                    catch (OfficeApplicationException officeApplicationException) {
                        // empty catch block
                    }
                }
            });
            System.out.println("Constructing document for test ...");
            IFrame officeFrame = application.getDesktopService().constructNewOfficeFrame(panel);
            this.document = application.getDocumentService().constructNewHiddenDocument("Text Document");
            System.out.println("Document for test constructed.");
            this.file = new File("OfficeBeanTest.odt");
            this.document.getPersistenceService().store(new FileOutputStream(this.file));
            this.document.close();
            System.out.println("Loading document for test ...");
            this.document = application.getDocumentService().loadDocument(officeFrame, (InputStream)new FileInputStream(this.file), (IDocumentDescriptor)new DocumentDescriptor());
            System.out.println("Document for test loaded.");
            frame.validate();
            officeFrame.getXFrame().getController().suspend(true);
            this.document.close();
            frame.dispose();
            this.document.close();
            this.file.delete();
            try {
                System.out.println("Deactivating OpenOffice.org connection ...");
                application.deactivate();
            }
            catch (OfficeApplicationException officeApplicationException) {}
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            OfficeBeanTest.fail((String)throwable.getMessage());
        }
        System.out.println("NOA Office Bean Test successfully.");
    }
}

