/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table.extended;

import ag.ion.bion.officelayer.clone.CloneException;
import ag.ion.bion.officelayer.clone.ICloneService;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTable;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTableCell;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTableCellRangeCloneService;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextTableCell;
import ag.ion.bion.officelayer.text.ITextTableCellProperties;
import ag.ion.bion.officelayer.text.ITextTableCellRange;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.ITextTableCellRangeName;
import ag.ion.bion.officelayer.text.table.TextTableCellNameHelper;
import ag.ion.bion.officelayer.text.table.extended.IETextTable;
import ag.ion.bion.officelayer.text.table.extended.IETextTableCell;
import ag.ion.bion.officelayer.text.table.extended.IETextTableCellRange;
import ag.ion.bion.officelayer.util.ArrayUtils;
import java.util.ArrayList;

public class ETextTableCellRange
implements IETextTableCellRange {
    private ITextTableCellRange[] textTableCellRange = null;
    private ITextDocument textDocument = null;
    private IETextTableCell[] textTableCells = null;
    private ITextTableCellRangeName textTableCellRangeName = null;
    private ETextTable textTable = null;
    private ITextTableCellProperties[] textTableCellProperties = null;

    public ETextTableCellRange(ITextTableCellRange[] textTableCellRanges, ITextTableCellRangeName textTableCellRangeName, IETextTable textTable) throws IllegalArgumentException, TextException {
        if (textTableCellRanges.length == 0) {
            throw new IllegalArgumentException("Submitted table range is not valid");
        }
        if (textTableCellRangeName == null) {
            throw new IllegalArgumentException("Submitted text table range name is not valid.");
        }
        if (textTable == null) {
            throw new IllegalArgumentException("The submitted table is not valid.");
        }
        if (!(textTable instanceof ETextTable)) {
            throw new IllegalArgumentException("The submitted table is not valid.");
        }
        this.textDocument = textTableCellRanges[0].getTextDocument();
        this.textTableCellRange = textTableCellRanges;
        this.textTableCellRangeName = textTableCellRangeName;
        this.textTableCells = new IETextTableCell[0];
        this.textTable = (ETextTable)textTable;
        int rowNumber = textTableCellRangeName.getRangeStartRowIndex() + 1;
        int j = 0;
        while (j < this.textTableCellRange.length) {
            ITextTableCell[] tableCells = this.textTableCellRange[j].getCells()[0];
            Object[] textTableCells = new IETextTableCell[tableCells.length];
            int i = 0;
            while (i < tableCells.length) {
                textTableCells[i] = new ETextTableCell(tableCells[i], String.valueOf(TextTableCellNameHelper.getColumnCharacter(tableCells[i].getName().getName())) + rowNumber, textTable);
                ++i;
            }
            ++rowNumber;
            try {
                this.textTableCells = (IETextTableCell[])ArrayUtils.appendArray(this.textTableCells, textTableCells, IETextTableCell.class);
            }
            catch (Exception exception) {
                TextException textException = new TextException("The submitted type is not valid");
                textException.initCause(exception);
                throw textException;
            }
            ++j;
        }
        this.textTableCellProperties = new ITextTableCellProperties[this.textTableCellRange.length];
        int i = 0;
        while (i < this.textTableCellProperties.length) {
            this.textTableCellProperties[i] = this.textTableCellRange[i].getCellProperties();
            ++i;
        }
    }

    @Override
    public ITextDocument getTextDocument() {
        return this.textDocument;
    }

    @Override
    public void setData(Object[][] values) throws TextException {
        int lastIndex = 0;
        if (this.textTableCellRange.length == 1) {
            this.textTableCellRange[0].setData(values);
            return;
        }
        int i = 0;
        while (i < this.textTableCellRange.length) {
            Object[][] help = this.textTableCellRange[i].getData();
            int count = 0;
            int j = lastIndex;
            while (j < lastIndex + help.length) {
                help[count] = values[j];
                ++count;
                ++j;
            }
            lastIndex += count;
            this.textTableCellRange[i].setData(help);
            ++i;
        }
    }

    @Override
    public Object[][] getData() {
        Object[][] data = null;
        ArrayList<Object[]> helpList = new ArrayList<Object[]>();
        int columns = 0;
        int i = 0;
        while (i < this.textTableCellRange.length) {
            Object[][] help = this.textTableCellRange[i].getData();
            int j = 0;
            while (j < help.length) {
                Object[] helpArray = help[j];
                columns = helpArray.length;
                helpList.add(helpArray);
                ++j;
            }
            ++i;
        }
        Object[][] objects = new Object[helpList.size()][columns];
        data = (Object[][])helpList.toArray((T[])objects);
        return data;
    }

    @Override
    public ITextTableCellProperties[] getCellProperties() {
        return this.textTableCellProperties;
    }

    @Override
    public int getRowCount() {
        int rowCount = -1;
        int i = 0;
        while (i < this.textTableCellRange.length) {
            rowCount += this.textTableCellRange[i].getRowCount();
            ++i;
        }
        return rowCount;
    }

    @Override
    public int getColumnCount() {
        int columnCount = -1;
        int i = 0;
        while (i < this.textTableCellRange.length) {
            columnCount += this.textTableCellRange[i].getColumnCount();
            ++i;
        }
        return columnCount;
    }

    @Override
    public IETextTableCell getCell(String name, int columnCount) throws TextException {
        int rowIndex = TextTableCellNameHelper.getRowIndex(name);
        int columnIndex = TextTableCellNameHelper.getColumnIndex(name);
        return this.getCell(columnIndex, rowIndex, columnCount);
    }

    @Override
    public IETextTableCell getCell(int columnIndex, int rowIndex, int columnCount) throws TextException {
        int tableNumber = rowIndex / (16384 / columnCount);
        int rowNumber = rowIndex - tableNumber * (16384 / columnCount) - 1;
        ITextTableCell textTableCell = this.textTableCellRange[tableNumber].getCell(columnIndex, rowNumber);
        String cellName = String.valueOf(TextTableCellNameHelper.getColumnCharacter(columnIndex)) + TextTableCellNameHelper.getRowCounterValue(rowIndex);
        ETextTableCell tableCell = new ETextTableCell(textTableCell, cellName, this.textTable);
        return tableCell;
    }

    @Override
    public ITextTableCellRangeName getRangeName() {
        return this.textTableCellRangeName;
    }

    @Override
    public IETextTableCell[] getCells() {
        return this.textTableCells;
    }

    public ITextTableCellRange[] getRanges() {
        return this.textTableCellRange;
    }

    @Override
    public ICloneService getCloneService() throws CloneException {
        return new ETextTableCellRangeCloneService(this, this.textDocument);
    }
}

