/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.beans.IProperties;
import ag.ion.bion.officelayer.internal.beans.AbstractPropertyStore;
import ag.ion.bion.officelayer.text.ICharacterProperties;
import ag.ion.bion.officelayer.text.ICharacterPropertyStore;
import ag.ion.bion.officelayer.text.IParagraph;
import ag.ion.bion.officelayer.text.IParagraphProperties;
import ag.ion.bion.officelayer.text.IParagraphPropertyStore;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.noa.NOAException;

public class ParagraphPropertyStore
extends AbstractPropertyStore
implements IParagraphPropertyStore {
    private short breakType = (short)-1;
    private short paraAdjust = (short)-1;
    private String paraStyleName = null;
    private ICharacterPropertyStore characterPropertyStore = null;
    private IProperties properties = null;

    public ParagraphPropertyStore(IParagraph paragraph) throws TextException {
        this.fillStorage(paragraph);
    }

    @Override
    public IProperties getProperties() {
        return this.properties;
    }

    @Override
    public void setBreakType(short breakType) throws TextException {
        if (breakType != 992 && breakType != 991 && breakType != 993) {
            throw new TextException("The breakType is not valid");
        }
        this.breakType = breakType;
    }

    @Override
    public short getBreakType() throws TextException {
        if (this.breakType != -1) {
            return this.breakType;
        }
        throw new TextException("BreakType is not available.");
    }

    @Override
    public short getParaAdjust() throws TextException {
        if (this.paraAdjust != -1) {
            return this.paraAdjust;
        }
        throw new TextException("ParaAdjust is not available.");
    }

    @Override
    public void setParaAdjust(short paraAdjust) throws TextException {
        if (paraAdjust != 3 && paraAdjust != 4 && paraAdjust != 1 && paraAdjust != 0) {
            throw new TextException("The paraAdjust is not valid");
        }
        this.paraAdjust = paraAdjust;
    }

    @Override
    public void setParaStyleName(String name) throws NOAException {
        if (name == null) {
            return;
        }
        this.paraStyleName = name;
    }

    @Override
    public String getParaStyleName() throws NOAException {
        return this.paraStyleName;
    }

    @Override
    public ICharacterProperties getCharacterProperties() throws TextException {
        return this.characterPropertyStore;
    }

    private void fillStorage(IParagraph paragraph) throws TextException {
        IParagraphProperties properties = paragraph.getParagraphProperties();
        this.properties = properties;
        this.breakType = properties.getBreakType();
        this.paraAdjust = properties.getParaAdjust();
        try {
            this.paraStyleName = properties.getParaStyleName();
        }
        catch (NOAException nOAException) {
            // empty catch block
        }
        this.characterPropertyStore = paragraph.getCharacterPropertyStore();
    }
}

