/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.form;

import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.form.IFormComponent;
import ag.ion.bion.officelayer.internal.document.Messages;
import ag.ion.bion.officelayer.internal.text.TextRange;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.noa.NOAException;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.XControlShape;
import com.sun.star.form.XFormComponent;
import com.sun.star.text.XTextContent;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XControlAccess;

public class FormComponent
implements IFormComponent {
    private IDocument document = null;
    private XControlShape xControlShape = null;
    private XFormComponent xFormComponent = null;

    public FormComponent(IDocument document, XControlShape xControlShape, XFormComponent xFormComponent) throws IllegalArgumentException {
        if (document == null) {
            throw new IllegalArgumentException(Messages.getString("Form.exception_document_invalid"));
        }
        if (xFormComponent == null) {
            throw new IllegalArgumentException(Messages.getString("Form.exception_xformcomponent_interface_invalid"));
        }
        this.document = document;
        this.xFormComponent = xFormComponent;
        this.xControlShape = xControlShape;
    }

    @Override
    public XPropertySet getXPropertySet() throws NOAException {
        return (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xFormComponent);
    }

    @Override
    public XFormComponent getXFormComponent() {
        return this.xFormComponent;
    }

    @Override
    public XControlShape getXControlShape() {
        return this.xControlShape;
    }

    @Override
    public XControl getXControl() throws NOAException {
        try {
            if (this.xControlShape != null) {
                XControlAccess controlAccess = (XControlAccess)UnoRuntime.queryInterface(XControlAccess.class, (Object)((ITextDocument)this.document).getXTextDocument().getCurrentController());
                XControl control = controlAccess.getControl(this.xControlShape.getControl());
                return control;
            }
            return null;
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    @Override
    public XTextComponent getXTextComponent() throws NOAException {
        XControl xControl = this.getXControl();
        if (xControl != null) {
            return (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)xControl);
        }
        return null;
    }

    @Override
    public void focus() throws NOAException {
        XControl xControl = this.getXControl();
        if (xControl != null) {
            XWindow xControlWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xControl);
            xControlWindow.setFocus();
        }
    }

    @Override
    public ITextRange getStartTextRange() throws NOAException {
        XTextContent textContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)this.xControlShape);
        if (textContent != null) {
            return new TextRange(this.document, textContent.getAnchor());
        }
        return null;
    }
}

