/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.application.connection;

import ag.ion.bion.officelayer.application.connection.AbstractOfficeConnection;
import ag.ion.bion.officelayer.runtime.IOfficeProgressMonitor;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;

public class RemoteOfficeConnection
extends AbstractOfficeConnection {
    private XMultiComponentFactory xMultiComponentFactory = null;
    private XMultiServiceFactory xMultiServiceFactory = null;
    private XComponentContext xRemoteContext = null;
    private String host = null;
    private String port = null;
    private boolean isConnectionEstablished = false;

    public RemoteOfficeConnection() {
    }

    public RemoteOfficeConnection(String host, String port) {
        this.host = host;
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public boolean openConnection(IOfficeProgressMonitor officeProgressMonitor) throws Exception {
        return this.openConnection();
    }

    @Override
    public boolean openConnection() throws Exception {
        String unoUrl = "uno:socket,host=" + this.host + ",port=" + this.port + ";urp;StarOffice.ServiceManager";
        XComponentContext xLocalContext = Bootstrap.createInitialComponentContext(null);
        Object connector = xLocalContext.getServiceManager().createInstanceWithContext("com.sun.star.connection.Connector", xLocalContext);
        XConnector xConnector = (XConnector)UnoRuntime.queryInterface(XConnector.class, (Object)connector);
        String[] url = this.parseUnoUrl(unoUrl);
        if (url == null) {
            throw new com.sun.star.uno.Exception("Couldn't parse UNO URL " + unoUrl);
        }
        XConnection connection = xConnector.connect(url[0]);
        Object bridgeFactory = xLocalContext.getServiceManager().createInstanceWithContext("com.sun.star.bridge.BridgeFactory", xLocalContext);
        XBridgeFactory xBridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface(XBridgeFactory.class, (Object)bridgeFactory);
        this.xBridge = xBridgeFactory.createBridge("", url[1], connection, null);
        bridgeFactory = this.xBridge.getInstance(url[2]);
        this.xMultiComponentFactory = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)bridgeFactory);
        XPropertySet xProperySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xMultiComponentFactory);
        Object remoteContext = xProperySet.getPropertyValue("DefaultContext");
        this.xRemoteContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)remoteContext);
        this.xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xMultiComponentFactory);
        this.isConnectionEstablished = true;
        return true;
    }

    @Override
    public void closeConnection() {
        this.xMultiComponentFactory = null;
        this.xMultiServiceFactory = null;
        this.xRemoteContext = null;
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xBridge);
        if (xComponent != null) {
            try {
                xComponent.dispose();
                this.isConnectionEstablished = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.xBridge = null;
    }

    @Override
    public XComponentContext getXComponentContext() {
        return this.xRemoteContext;
    }

    @Override
    public boolean isConnected() {
        return this.isConnectionEstablished;
    }

    @Override
    public XMultiComponentFactory getXMultiComponentFactory() {
        return this.xMultiComponentFactory;
    }

    @Override
    public XMultiServiceFactory getXMultiServiceFactory() {
        return this.xMultiServiceFactory;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    private String[] parseUnoUrl(String unoUrl) {
        String[] aRet = new String[3];
        if (!unoUrl.startsWith("uno:")) {
            return null;
        }
        int semicolon = unoUrl.indexOf(59);
        if (semicolon == -1) {
            return null;
        }
        aRet[0] = unoUrl.substring(4, semicolon);
        int nextSemicolon = unoUrl.indexOf(59, semicolon + 1);
        if (semicolon == -1) {
            return null;
        }
        aRet[1] = unoUrl.substring(semicolon + 1, nextSemicolon);
        aRet[2] = unoUrl.substring(nextSemicolon + 1);
        return aRet;
    }
}

