/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.application;

import ag.ion.bion.officelayer.application.IOfficeApplication;
import ag.ion.bion.officelayer.application.IOfficeApplicationConfiguration;
import ag.ion.bion.officelayer.application.LocalOfficeApplicationConfiguration;
import ag.ion.bion.officelayer.application.OfficeApplicationException;
import ag.ion.bion.officelayer.internal.application.AbstractOfficeApplication;
import ag.ion.bion.officelayer.internal.application.connection.LocalOfficeConnection;
import ag.ion.bion.officelayer.runtime.IOfficeProgressMonitor;
import java.awt.Toolkit;
import java.util.Map;

public class LocalOfficeApplication
extends AbstractOfficeApplication
implements IOfficeApplication {
    private LocalOfficeApplicationConfiguration localOfficeApplicationConfiguration = null;
    private String home = null;
    private String[] arguments = null;
    private boolean isConfigured = false;

    static {
        try {
            Toolkit.getDefaultToolkit();
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public LocalOfficeApplication(Map map) {
        if (map != null) {
            try {
                this.initConfiguration(map);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void setConfiguration(IOfficeApplicationConfiguration officeApplicationConfiguration) throws OfficeApplicationException {
        if (!(officeApplicationConfiguration instanceof LocalOfficeApplicationConfiguration)) {
            throw new OfficeApplicationException("The submitted configuration is not valid for a local office application.");
        }
        this.localOfficeApplicationConfiguration = (LocalOfficeApplicationConfiguration)officeApplicationConfiguration;
        this.setOfficeApplicationConfiguration(this.localOfficeApplicationConfiguration);
        this.home = this.localOfficeApplicationConfiguration.getApplicationHomePath();
        this.isConfigured = true;
    }

    @Override
    public void setConfiguration(Map configuration) throws OfficeApplicationException {
        this.initConfiguration(configuration);
    }

    @Override
    public boolean isConfigured() {
        return this.isConfigured;
    }

    @Override
    protected void openConnection(IOfficeProgressMonitor officeProgressMonitor) throws OfficeApplicationException {
        System.out.println("AbstractOfficeApplication: openConnection() begin");
        try {
            System.out.println("AbstractOfficeApplication: getting new LocalOfficeConnection()");
            LocalOfficeConnection localOfficeConnection = new LocalOfficeConnection();
            if (localOfficeConnection == null) {
                System.out.println("AbstractOfficeApplication: localOfficeConnection==null");
            } else {
                System.out.println("AbstractOfficeApplication: localOfficeConnection=" + localOfficeConnection.toString());
            }
            System.out.println("AbstractOfficeApplication: localOfficeConnection.setOfficePath(" + this.home + ")");
            localOfficeConnection.setOfficePath(this.home);
            System.out.println("AbstractOfficeApplication: localOfficeConnection.setOfficeArguments(" + this.arguments + ")");
            localOfficeConnection.setOfficeArguments(this.arguments);
            System.out.println("AbstractOfficeApplication: localOfficeConnection.setHost(\"localhost\")");
            localOfficeConnection.setHost("localhost");
            System.out.println("AbstractOfficeApplication: localOfficeConnection.setUseBridge(true)");
            localOfficeConnection.setUseBridge(true);
            System.out.println("AbstractOfficeApplication: localOfficeConnection.openConnection(officeProgressMonitor)");
            localOfficeConnection.openConnection(officeProgressMonitor);
            System.out.println("AbstractOfficeApplication: setOfficeConnection(localOfficeConnection)");
            this.setOfficeConnection(localOfficeConnection);
            System.out.println("AbstractOfficeApplication: setOfficeConnection(localOfficeConnection) has returned");
        }
        catch (Throwable throwable) {
            OfficeApplicationException officeApplicationException = new OfficeApplicationException(throwable.getMessage());
            officeApplicationException.initCause(throwable);
            throw officeApplicationException;
        }
        System.out.println("AbstractOfficeApplication: openConnection() end");
    }

    private void initConfiguration(Map configuration) throws OfficeApplicationException {
        Object arguments;
        if (configuration == null) {
            throw new OfficeApplicationException("The submitted configuration is not valid.");
        }
        Object home = configuration.get("home");
        if (home != null) {
            this.home = home.toString();
        }
        if ((arguments = configuration.get("arguments")) != null) {
            this.arguments = (String[])arguments;
        }
        this.isConfigured = true;
    }

    @Override
    public String getApplicationType() {
        return "local";
    }
}

