/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.application;

import ag.ion.bion.officelayer.application.IApplicationInfo;
import ag.ion.bion.officelayer.application.IOfficeApplication;
import ag.ion.bion.officelayer.application.IOfficeApplicationConfiguration;
import ag.ion.bion.officelayer.application.OfficeApplicationException;
import ag.ion.bion.officelayer.application.connection.IOfficeConnection;
import ag.ion.bion.officelayer.desktop.IDesktopService;
import ag.ion.bion.officelayer.document.IDocumentService;
import ag.ion.bion.officelayer.event.IEvent;
import ag.ion.bion.officelayer.event.IEventListener;
import ag.ion.bion.officelayer.internal.application.ApplicationInfo;
import ag.ion.bion.officelayer.internal.desktop.DesktopService;
import ag.ion.bion.officelayer.internal.document.DocumentService;
import ag.ion.bion.officelayer.runtime.IOfficeProgressMonitor;
import ag.ion.noa.internal.service.ServiceProvider;
import ag.ion.noa.service.IServiceProvider;
import com.sun.star.frame.XDesktop;
import com.sun.star.uno.UnoRuntime;

public abstract class AbstractOfficeApplication
implements IOfficeApplication {
    private IOfficeConnection officeConnection = null;
    private IOfficeApplicationConfiguration officeApplicationConfiguration = null;
    private DocumentService documentService = null;
    private DesktopService desktopService = null;
    private boolean active = false;

    @Override
    public void activate(IOfficeProgressMonitor officeProgressMonitor) throws OfficeApplicationException {
        System.out.println("AbstractOfficeApplication: activate(officeProgressMonitor) begin");
        System.out.println("AbstractOfficeApplication: isConfigured==" + this.isConfigured());
        if (!this.isConfigured()) {
            throw new OfficeApplicationException("Configuration for office application is missing.");
        }
        System.out.println("AbstractOfficeApplication: trying to openConnection()...");
        this.openConnection(officeProgressMonitor);
        this.active = true;
        this.documentService = null;
        this.desktopService = null;
        System.out.println("AbstractOfficeApplication: trying to addBridgeEventListener()...");
        this.officeConnection.addBridgeEventListener(new ConnectionListener());
        System.out.println("AbstractOfficeApplication: activation done.");
    }

    @Override
    public void activate() throws OfficeApplicationException {
        this.activate(null);
    }

    @Override
    public void deactivate() throws OfficeApplicationException {
        if (this.officeConnection != null) {
            this.officeConnection.closeConnection();
        }
        this.active = false;
    }

    @Override
    public boolean isActive() {
        if (this.officeConnection == null || !this.officeConnection.isConnected()) {
            this.active = false;
        }
        return this.active;
    }

    @Override
    public IDocumentService getDocumentService() throws OfficeApplicationException {
        if (this.officeConnection == null) {
            throw new OfficeApplicationException("Application is not active.");
        }
        if (this.documentService == null) {
            this.documentService = new DocumentService(this.officeConnection, this.getServiceProvider());
        }
        return this.documentService;
    }

    @Override
    public IDesktopService getDesktopService() throws OfficeApplicationException {
        try {
            if (this.officeConnection == null) {
                throw new OfficeApplicationException("Application is not active.");
            }
            if (this.desktopService == null) {
                Object service = this.officeConnection.createService("com.sun.star.frame.Desktop");
                XDesktop desktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)service);
                this.desktopService = new DesktopService(desktop, this.officeConnection);
            }
            return this.desktopService;
        }
        catch (Exception exception) {
            OfficeApplicationException officeApplicationException = new OfficeApplicationException(exception.getMessage());
            officeApplicationException.initCause(exception);
            throw officeApplicationException;
        }
    }

    @Override
    public void dispose() {
        try {
            this.deactivate();
        }
        catch (OfficeApplicationException exception) {
            exception.printStackTrace();
        }
        if (this.desktopService != null) {
            this.desktopService.dispose();
            this.desktopService = null;
        }
        if (this.documentService != null) {
            this.documentService.dispose();
            this.documentService = null;
        }
    }

    @Override
    public IServiceProvider getServiceProvider() {
        if (!this.active || this.officeConnection == null) {
            return null;
        }
        return new ServiceProvider(this.officeConnection);
    }

    @Override
    public IApplicationInfo getApplicationInfo() throws Exception {
        IServiceProvider serviceProvider = this.getServiceProvider();
        if (serviceProvider != null) {
            return new ApplicationInfo(serviceProvider);
        }
        return null;
    }

    protected abstract void openConnection(IOfficeProgressMonitor var1) throws OfficeApplicationException;

    protected void setOfficeApplicationConfiguration(IOfficeApplicationConfiguration officeApplicationConfiguration) {
        this.officeApplicationConfiguration = officeApplicationConfiguration;
    }

    protected void setOfficeConnection(IOfficeConnection officeConnection) {
        System.out.println("AbstractOfficeApplication: setOfficeConnection() begin");
        this.officeConnection = officeConnection;
        System.out.println("AbstractOfficeApplication: setOfficeConnection() end");
    }

    private class ConnectionListener
    implements IEventListener {
        private ConnectionListener() {
        }

        @Override
        public void disposing(IEvent event) {
            AbstractOfficeApplication.this.active = false;
            AbstractOfficeApplication.this.documentService = null;
            AbstractOfficeApplication.this.desktopService = null;
        }
    }
}

