/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.application;

import ag.ion.bion.officelayer.application.IApplicationProperties;
import ag.ion.bion.officelayer.application.ILazyApplicationInfo;

public abstract class AbstractLazyApplicationInfo
implements ILazyApplicationInfo {
    private IApplicationProperties applicationProperties = null;
    private String home = null;
    private String productNameInProperties = null;
    private int majorVersion = -1;
    private int minorVersion = -1;
    private int updateVersion = -1;

    public AbstractLazyApplicationInfo(String home, IApplicationProperties applicationProperties, String productNameInProperties) throws IllegalArgumentException {
        if (home == null) {
            throw new IllegalArgumentException("The submitted home path is not valid.");
        }
        if (productNameInProperties == null) {
            throw new IllegalArgumentException("The submitted product name is not valid.");
        }
        this.home = home;
        this.applicationProperties = applicationProperties;
        this.productNameInProperties = productNameInProperties;
        if (applicationProperties != null) {
            this.initVersion(applicationProperties);
        }
    }

    public void setVersion(int major, int minor, int update) {
        this.majorVersion = major;
        this.minorVersion = minor;
        this.updateVersion = update;
    }

    @Override
    public String getHome() {
        return this.home;
    }

    @Override
    public IApplicationProperties getProperties() {
        return this.applicationProperties;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public int getUpdateVersion() {
        return this.updateVersion;
    }

    private void initVersion(IApplicationProperties applicationProperties) {
        String productKey = applicationProperties.getPropertyValue("ProductKey");
        if (productKey != null) {
            String version = productKey.substring(this.productNameInProperties.length()).trim();
            String[] versionParts = version.split("\\.");
            int majorVersion = 0;
            int minorVersion = 0;
            int updateVersion = 0;
            int i = 0;
            int n = versionParts.length;
            while (i < n) {
                int number = -1;
                try {
                    number = Integer.parseInt(versionParts[i]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (i == 0) {
                    majorVersion = number;
                } else if (i == 1) {
                    minorVersion = number;
                } else if (i == 2) {
                    updateVersion = number;
                }
                ++i;
            }
            this.setVersion(majorVersion, minorVersion, updateVersion);
        }
    }
}

