/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa4e.ui.wizards.application;

import ag.ion.bion.officelayer.application.IApplicationAssistant;
import ag.ion.bion.officelayer.application.ILazyApplicationInfo;
import ag.ion.bion.officelayer.application.OfficeApplicationRuntime;
import ag.ion.bion.workbench.office.editor.core.EditorCorePlugin;
import ag.ion.noa4e.ui.FormBorderPainter;
import ag.ion.noa4e.ui.NOAUIPlugin;
import ag.ion.noa4e.ui.operations.FindApplicationInfosOperation;
import ag.ion.noa4e.ui.wizards.application.Messages;
import java.io.File;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class LocalApplicationWizardDefinePage
extends WizardPage
implements IWizardPage {
    public static final String PAGE_NAME = "LocalApplicationWizardDefinePage";
    private static final String DEFAULT_PRODUCT_NAME = "OpenOffice.org";
    private Text textHome = null;
    private Table tableApplicationInfos = null;
    private ILazyApplicationInfo[] applicationInfos = null;
    private String selectedHomePath = null;

    public LocalApplicationWizardDefinePage(String homePath, ILazyApplicationInfo[] applicationInfos) {
        super(PAGE_NAME);
        System.out.println("LOAWDP: LocalApplicationWizardDefinePage(" + homePath + ", applicationInfos) - just supered " + PAGE_NAME);
        this.setTitle(Messages.LocalApplicationWizardDefinePage_title);
        this.setDescription(Messages.LocalApplicationWizardDefinePage_description);
        this.applicationInfos = applicationInfos;
        this.selectedHomePath = homePath;
    }

    public String getSelectedHomePath() {
        if (this.selectedHomePath == null) {
            System.out.println("LOAWDP: getSelectedHomePath() returns null");
        } else {
            System.out.println("LOAWDP: getSelectedHomePath() returns " + this.selectedHomePath);
        }
        return this.selectedHomePath;
    }

    public void setVisible(boolean visible) {
        System.out.println("LOAWDP: setVisible");
        super.setVisible(visible);
        if (visible && this.applicationInfos == null) {
            try {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FindApplicationInfosOperation applicationInfosOperation = new FindApplicationInfosOperation();
                            LocalApplicationWizardDefinePage.this.getContainer().run(true, true, (IRunnableWithProgress)applicationInfosOperation);
                            LocalApplicationWizardDefinePage.this.applicationInfos = applicationInfosOperation.getApplicationsInfos();
                            LocalApplicationWizardDefinePage.this.fillTable(LocalApplicationWizardDefinePage.this.tableApplicationInfos);
                            LocalApplicationWizardDefinePage.this.init(LocalApplicationWizardDefinePage.this.applicationInfos);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void createControl(Composite parent) {
        System.out.println("LOAWDP: createControl");
        FormToolkit formToolkit = NOAUIPlugin.getFormToolkit();
        ScrolledForm scrolledForm = formToolkit.createScrolledForm(parent);
        GridData gridData = new GridData(4, 4, true, true);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 7;
        scrolledForm.getBody().setLayout((Layout)gridLayout);
        scrolledForm.getBody().setLayoutData((Object)gridData);
        scrolledForm.getBody().setBackground(parent.getBackground());
        this.constructHomeSection(formToolkit, scrolledForm);
        this.constructApplicationsSection(formToolkit, scrolledForm);
        this.setControl((Control)scrolledForm);
        if (this.applicationInfos != null) {
            this.fillTable(this.tableApplicationInfos);
            if (this.selectedHomePath == null) {
                this.init(this.applicationInfos);
            }
        }
        if (this.selectedHomePath != null) {
            this.textHome.setText(this.selectedHomePath);
        }
        this.checkPageState();
    }

    private void constructHomeSection(FormToolkit formToolkit, ScrolledForm scrolledForm) {
        System.out.println("LOAWDP: constructHomeSection");
        Section section = formToolkit.createSection(scrolledForm.getBody(), 144);
        GridData gridData = new GridData(4, 4, true, true);
        section.setText(Messages.LocalApplicationWizardDefinePage_section_application_test);
        section.setDescription(Messages.LocalApplicationWizardDefinePage_section_application_description);
        section.setLayoutData((Object)gridData);
        section.setBackground(scrolledForm.getBody().getBackground());
        formToolkit.createCompositeSeparator((Composite)section);
        Composite client = formToolkit.createComposite((Composite)section);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        client.setLayout((Layout)gridLayout);
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        client.setBackground(section.getBackground());
        Label labelHome = formToolkit.createLabel(client, Messages.LocalApplicationWizardDefinePage_label_home_text);
        labelHome.setBackground(client.getBackground());
        this.textHome = formToolkit.createText(client, "");
        this.textHome.setLayoutData((Object)new GridData(4, 0, true, false));
        this.textHome.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                LocalApplicationWizardDefinePage.this.checkPageState();
                LocalApplicationWizardDefinePage.this.selectedHomePath = LocalApplicationWizardDefinePage.this.textHome.getText();
                ILazyApplicationInfo applicationInfo = LocalApplicationWizardDefinePage.this.selectApplicationInfo(LocalApplicationWizardDefinePage.this.textHome.getText());
                LocalApplicationWizardDefinePage.this.textHome.setFocus();
                if (applicationInfo == null) {
                    try {
                        IApplicationAssistant applicationAssistant = OfficeApplicationRuntime.getApplicationAssistant(EditorCorePlugin.getDefault().getLibrariesLocation());
                        applicationInfo = applicationAssistant.findLocalApplicationInfo(LocalApplicationWizardDefinePage.this.textHome.getText());
                        if (applicationInfo != null) {
                            LocalApplicationWizardDefinePage.this.addApplicationInfo(LocalApplicationWizardDefinePage.this.tableApplicationInfos, applicationInfo);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
        final Link linkBrowse = new Link(client, 0);
        linkBrowse.setText("<a>" + Messages.LocalApplicationWizardDefinePage_link_browse_text + "</a>");
        linkBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(linkBrowse.getShell());
                directoryDialog.setText(Messages.LocalApplicationWizardDefinePage_directory_dialog_text);
                directoryDialog.setMessage(Messages.LocalApplicationWizardDefinePage_directory_dialog_message);
                String path = directoryDialog.open();
                if (path != null) {
                    LocalApplicationWizardDefinePage.this.textHome.setText(path);
                    LocalApplicationWizardDefinePage.this.textHome.setSelection(path.length());
                }
            }
        });
        FormBorderPainter.paintBordersFor(client);
        section.setClient((Control)client);
    }

    private void constructApplicationsSection(FormToolkit formToolkit, ScrolledForm scrolledForm) {
        int tableWidth;
        System.out.println("LOAWDP: constructApplicationSection");
        Section section = formToolkit.createSection(scrolledForm.getBody(), 144);
        GridData gridData = new GridData(4, 4, true, true);
        section.setText(Messages.LocalApplicationWizardDefinePage_section_available_applications_text);
        section.setDescription(Messages.LocalApplicationWizardDefinePage_section_available_applications_description);
        section.setLayoutData((Object)gridData);
        section.setBackground(scrolledForm.getBody().getBackground());
        formToolkit.createCompositeSeparator((Composite)section);
        Composite client = formToolkit.createComposite((Composite)section);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        client.setLayout((Layout)gridLayout);
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        client.setBackground(section.getBackground());
        this.tableApplicationInfos = formToolkit.createTable(client, 65540);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = tableWidth = (int)((double)this.tableApplicationInfos.getDisplay().getClientArea().width * 0.3);
        this.tableApplicationInfos.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        this.tableApplicationInfos.setLayout((Layout)tableLayout);
        TableColumn columnProduct = new TableColumn(this.tableApplicationInfos, 0);
        columnProduct.setText(Messages.LocalApplicationWizardDefinePage_column_product_text);
        int columnProductWidth = (int)((double)tableWidth * 0.4);
        columnProduct.setWidth(columnProductWidth);
        TableColumn columnHome = new TableColumn(this.tableApplicationInfos, 0);
        columnHome.setText(Messages.LocalApplicationWizardDefinePage_column_home_text);
        columnHome.setWidth(tableWidth - columnProductWidth);
        this.tableApplicationInfos.setLinesVisible(true);
        this.tableApplicationInfos.setHeaderVisible(true);
        this.tableApplicationInfos.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = (TableItem)selectionEvent.item;
                ILazyApplicationInfo applicationInfo = (ILazyApplicationInfo)tableItem.getData();
                if (applicationInfo != null && !applicationInfo.getHome().equals(LocalApplicationWizardDefinePage.this.textHome.getText())) {
                    LocalApplicationWizardDefinePage.this.textHome.setText(applicationInfo.getHome());
                    LocalApplicationWizardDefinePage.this.textHome.setSelection(applicationInfo.getHome().length());
                }
            }
        });
        FormBorderPainter.paintBordersFor(client);
        section.setClient((Control)client);
    }

    private void checkPageState() {
        block9: {
            System.out.println("LOAWDP: checkPageState");
            String home = this.textHome.getText();
            if (home.length() != 0) {
                File file = new File(home);
                if (file.canRead()) {
                    try {
                        IApplicationAssistant applicationAssistant = OfficeApplicationRuntime.getApplicationAssistant(EditorCorePlugin.getDefault().getLibrariesLocation());
                        ILazyApplicationInfo applicationInfo = applicationAssistant.findLocalApplicationInfo(home);
                        if (applicationInfo == null) {
                            this.setPageComplete(true);
                            this.setMessage(Messages.LocalApplicationWizardDefinePage_message_warning_path_invalid, 2);
                            break block9;
                        }
                        if (applicationInfo.getMajorVersion() == 1 && applicationInfo.getMinorVersion() == 9) {
                            this.setPageComplete(true);
                            this.setMessage(Messages.LocalApplicationWizardDefinePage_message_warning_beta_release, 2);
                            break block9;
                        }
                        if (applicationInfo.getMajorVersion() == 1) {
                            this.setPageComplete(true);
                            this.setMessage(Messages.LocalApplicationWizardDefinePage_message_warning_version_old, 2);
                            break block9;
                        }
                        this.setPageComplete(true);
                        this.setMessage(null);
                    }
                    catch (Throwable throwable) {
                        this.setPageComplete(true);
                        this.setMessage(null);
                    }
                } else {
                    this.setPageComplete(false);
                    this.setMessage(Messages.LocalApplicationWizardDefinePage_message_error_path_not_available, 3);
                }
            } else {
                this.setPageComplete(false);
                this.setMessage(null);
            }
        }
    }

    private void fillTable(Table table) {
        System.out.println("LOAWDP: fillTable");
        if (this.applicationInfos == null || table == null) {
            return;
        }
        int i = 0;
        int n = this.applicationInfos.length;
        while (i < n) {
            ILazyApplicationInfo applicationInfo = this.applicationInfos[i];
            this.addApplicationInfo(table, applicationInfo);
            ++i;
        }
    }

    private void addApplicationInfo(Table table, ILazyApplicationInfo applicationInfo) {
        if (table != null && applicationInfo != null && this.getApplicationInfo(applicationInfo.getHome()) == null) {
            String productKey;
            TableItem tableItem = new TableItem(table, 0);
            String productName = DEFAULT_PRODUCT_NAME;
            if (applicationInfo.getProperties() != null && (productKey = applicationInfo.getProperties().getPropertyValue("ProductKey")) != null) {
                productName = productKey;
            }
            tableItem.setText(0, productName);
            tableItem.setText(1, applicationInfo.getHome());
            tableItem.setData((Object)applicationInfo);
        }
    }

    private ILazyApplicationInfo selectApplicationInfo(String home) {
        System.out.println("LOAWDP: selectApplicationInfo(String home)");
        if (home == null) {
            System.out.println("LOAWDP: Please note: home==null; so just returning null.");
            return null;
        }
        if (this.tableApplicationInfos != null) {
            TableItem[] tableItems = this.tableApplicationInfos.getItems();
            int i = 0;
            int n = tableItems.length;
            while (i < n) {
                TableItem tableItem = tableItems[i];
                ILazyApplicationInfo applicationInfo = (ILazyApplicationInfo)tableItem.getData();
                if (applicationInfo != null && applicationInfo.getHome().equals(home)) {
                    this.tableApplicationInfos.select(i);
                    return applicationInfo;
                }
                ++i;
            }
        }
        return null;
    }

    private ILazyApplicationInfo getApplicationInfo(String home) {
        System.out.println("LOAWDP: getApplicationInfo(String home)");
        if (home == null) {
            System.out.println("LOAWDP: Please note: home==null; so just returning null.");
            return null;
        }
        if (this.tableApplicationInfos != null) {
            TableItem[] tableItems = this.tableApplicationInfos.getItems();
            int i = 0;
            int n = tableItems.length;
            while (i < n) {
                TableItem tableItem = tableItems[i];
                ILazyApplicationInfo applicationInfo = (ILazyApplicationInfo)tableItem.getData();
                if (applicationInfo != null && applicationInfo.getHome().equals(home)) {
                    return applicationInfo;
                }
                ++i;
            }
        }
        return null;
    }

    private void init(ILazyApplicationInfo[] applicationInfos) {
        System.out.println("LOAWDP: init(applicationInfos)");
        if (applicationInfos == null) {
            System.out.println("LOAWDP: Please note: applicationInfos==null; so just returning.");
            return;
        }
        String home = null;
        int i = 0;
        int n = applicationInfos.length;
        while (i < n) {
            ILazyApplicationInfo applicationInfo = applicationInfos[i];
            if (applicationInfo.getMajorVersion() == 2) {
                home = applicationInfo.getHome();
                break;
            }
            if (applicationInfo.getMajorVersion() == 1 && applicationInfo.getMinorVersion() == 9) {
                home = applicationInfo.getHome();
            }
            ++i;
        }
        if (home != null) {
            this.textHome.setText(home);
            this.textHome.setSelection(home.length());
        }
    }
}

