/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table;

import ag.ion.bion.officelayer.beans.PropertyKeysContainer;
import ag.ion.bion.officelayer.clone.CloneDestinationPosition;
import ag.ion.bion.officelayer.clone.CloneException;
import ag.ion.bion.officelayer.clone.ClonedObject;
import ag.ion.bion.officelayer.clone.ICloneService;
import ag.ion.bion.officelayer.clone.IClonedObject;
import ag.ion.bion.officelayer.clone.IDestinationPosition;
import ag.ion.bion.officelayer.internal.clone.AbstractCloneService;
import ag.ion.bion.officelayer.internal.text.TextTableCell;
import ag.ion.bion.officelayer.internal.text.TextTableCellRange;
import ag.ion.bion.officelayer.internal.text.TextTableColumn;
import ag.ion.bion.officelayer.internal.text.TextTableRow;
import ag.ion.bion.officelayer.internal.text.TextTableService;
import ag.ion.bion.officelayer.text.ITextContent;
import ag.ion.bion.officelayer.text.ITextContentService;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.text.ITextTable;
import ag.ion.bion.officelayer.text.ITextTableCell;
import ag.ion.bion.officelayer.text.ITextTableCellName;
import ag.ion.bion.officelayer.text.ITextTableCellRange;
import ag.ion.bion.officelayer.text.ITextTableService;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.ITextTableCellRangeName;
import ag.ion.bion.officelayer.text.table.ITextTablePropertyStore;

public class TextTableCellRangeCloneService
extends AbstractCloneService {
    private ITextTableCellRange textTableCellRange = null;
    private ITextDocument textDocument = null;
    private ICloneService[][] cellCloneServices = null;
    private ITextTablePropertyStore textTablePropertyStore = null;
    private ITextTableService textTableService = null;
    private ITextContentService textContentService = null;
    private ITextTable oldTable = null;
    private int rowCount = 0;
    private int columnCount = 0;

    public TextTableCellRangeCloneService(ITextTableCellRange textTableCellRange) throws CloneException {
        this.textDocument = textTableCellRange.getTextDocument();
        this.textTableCellRange = textTableCellRange;
        this.rowCount = textTableCellRange.getRowCount();
        this.columnCount = textTableCellRange.getColumnCount();
    }

    @Override
    public IClonedObject cloneToPosition(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.clonePreprocessor(position, true, true, propertyKeysContainer);
    }

    @Override
    public void cloneToPositionNoReturn(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.clonePreprocessor(position, true, false, propertyKeysContainer);
    }

    @Override
    public IClonedObject cloneToPosition(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.clonePreprocessor(position, adoptContent, true, propertyKeysContainer);
    }

    @Override
    public void cloneToPositionNoReturn(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.clonePreprocessor(position, adoptContent, false, propertyKeysContainer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IClonedObject clonePreprocessor(IDestinationPosition position, boolean adoptContent, boolean generateReturnValue, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        try {
            Object range;
            if (this.cellCloneServices == null) {
                this.getCloneCells();
            }
            ITextTable newTable = null;
            if (this.oldTable == null) {
                this.oldTable = this.textTableCellRange.getCell(0, 0).getTextTable();
            }
            if (this.textTablePropertyStore == null) {
                this.textTablePropertyStore = this.oldTable.getPropertyStore();
            }
            int columnStart = 0;
            int rowStart = 0;
            if (this.cellCloneServices.length == 0) {
                CloneException cloneException = new CloneException("No range selected.");
                throw cloneException;
            }
            int columnArrayLength = this.cellCloneServices[0].length;
            if (position.getType() == null) {
                CloneException cloneException = new CloneException("No valid type for the position.");
                throw cloneException;
            }
            if (ITextRange.class.isAssignableFrom(position.getType())) {
                range = (ITextRange)position.getDestinationObject();
                if (this.textTableService == null) {
                    this.textTableService = this.textDocument.getTextTableService();
                }
                newTable = this.textTableService.constructTextTable(this.rowCount, this.columnCount);
                newTable.getProperties().setRepeatHeadline(this.textTablePropertyStore.repeatHeadline());
                if (this.textContentService == null) {
                    this.textContentService = this.textDocument.getTextService().getTextContentService();
                }
                if (range == null) {
                    CloneException cloneException = new CloneException("No destination selected..");
                    throw cloneException;
                }
                this.textContentService.insertTextContent((ITextRange)range, newTable);
                newTable.getProperties().setTableColumnSeparators(this.textTablePropertyStore.getTableColumnSeparators());
            } else if (ITextTable.class.isAssignableFrom(position.getType())) {
                range = (ITextTable)position.getDestinationObject();
                TextTableService tableService = new TextTableService(this.textDocument);
                newTable = tableService.constructTextTable(this.rowCount, this.columnCount);
                newTable.getProperties().setRepeatHeadline(this.textTablePropertyStore.repeatHeadline());
                if (range == null) {
                    CloneException cloneException = new CloneException("No destination selected..");
                    throw cloneException;
                }
                if (this.textContentService == null) {
                    this.textContentService = this.textDocument.getTextService().getTextContentService();
                }
                this.textContentService.insertTextContentAfter(newTable, (ITextContent)range);
                newTable.getProperties().setTableColumnSeparators(this.textTablePropertyStore.getTableColumnSeparators());
            } else if (TextTableCell.class.isAssignableFrom(position.getType())) {
                TextTableCell textTableCell = (TextTableCell)position.getDestinationObject();
                newTable = textTableCell.getTextTable();
                ITextTableCellName cellName = textTableCell.getName();
                columnStart = cellName.getColumnIndex();
                rowStart = cellName.getRowIndex();
                int newTableColumnCount = newTable.getColumnCount();
                int newTableRowCount = newTable.getRowCount();
                if (columnStart + columnArrayLength > newTableColumnCount) {
                    CloneException cloneException = new CloneException("Too much columns selected.");
                    throw cloneException;
                }
                if ((rowStart + this.rowCount) * newTableColumnCount > 16384) {
                    CloneException cloneException = new CloneException("The sumbitted range is too big.");
                    throw cloneException;
                }
                if (rowStart + this.rowCount > newTableRowCount) {
                    newTable.addRow(rowStart, rowStart + this.rowCount - newTableRowCount);
                }
            } else if (TextTableCellRange.class.isAssignableFrom(position.getType())) {
                TextTableCellRange tableCellRange = (TextTableCellRange)position.getDestinationObject();
                int tmpColumnCount = tableCellRange.getColumnCount();
                int tmpRowCount = tableCellRange.getRowCount();
                if (tmpColumnCount == 0 || tmpRowCount == 0) {
                    CloneException cloneException = new CloneException("No range selected.");
                    throw cloneException;
                }
                newTable = tableCellRange.getCell(0, 0).getTextTable();
                ITextTableCellRangeName rangeName = tableCellRange.getRangeName();
                columnStart = rangeName.getRangeStartColumnIndex();
                rowStart = rangeName.getRangeStartRowIndex();
                if (tmpColumnCount != this.columnCount || tmpRowCount != this.rowCount) {
                    CloneException cloneException = new CloneException("The selected range is not valid.");
                    throw cloneException;
                }
            } else if (TextTableRow.class.isAssignableFrom(position.getType())) {
                TextTableRow textTableRow = (TextTableRow)position.getDestinationObject();
                ITextTableCellRange tableCellRange = textTableRow.getCellRange();
                int tmpColumnCount = tableCellRange.getColumnCount();
                int tmpRowCount = tableCellRange.getRowCount();
                if (tmpColumnCount == 0 || tmpRowCount == 0) {
                    CloneException cloneException = new CloneException("No range selected.");
                    throw cloneException;
                }
                newTable = tableCellRange.getCell(0, 0).getTextTable();
                ITextTableCellRangeName rangeName = tableCellRange.getRangeName();
                columnStart = rangeName.getRangeStartColumnIndex();
                rowStart = rangeName.getRangeStartRowIndex();
                if (tmpColumnCount != this.columnCount || tmpRowCount != this.rowCount) {
                    CloneException cloneException = new CloneException("The selected range is not valid.");
                    throw cloneException;
                }
            } else if (!TextTableColumn.class.isAssignableFrom(position.getType())) {
                CloneException cloneException = new CloneException("No range selected.");
                throw cloneException;
            }
            if (newTable == null) {
                CloneException cloneException = new CloneException("No range selected.");
                throw cloneException;
            }
            int rowArrayLength = this.cellCloneServices.length;
            int rows = 0;
            while (rows < rowArrayLength) {
                int columns = 0;
                while (columns < columnArrayLength) {
                    ICloneService cellClone = this.cellCloneServices[rows][columns];
                    ITextTableCell textTableCell = newTable.getCell(columnStart + columns, rowStart + rows);
                    CloneDestinationPosition destinationCell = new CloneDestinationPosition(textTableCell, textTableCell.getClass());
                    cellClone.cloneToPositionNoReturn(destinationCell, adoptContent, propertyKeysContainer);
                    ++columns;
                }
                ++rows;
            }
            if (generateReturnValue) {
                ITextTableCellRange textTableCellRange = newTable.getCellRange(columnStart, rowStart, columnArrayLength, rowArrayLength);
                return new ClonedObject(textTableCellRange, textTableCellRange.getClass());
            }
            return null;
        }
        catch (Exception exception) {
            CloneException cloneException = new CloneException(exception.getMessage());
            cloneException.initCause(exception);
            throw cloneException;
        }
    }

    private void getCloneCells() throws CloneException {
        this.cellCloneServices = new ICloneService[this.rowCount][this.columnCount];
        int i = 0;
        while (i < this.rowCount) {
            int h = 0;
            while (h < this.columnCount) {
                try {
                    ITextTableCell currentTableCell = this.textTableCellRange.getCell(h, i);
                    this.cellCloneServices[i][h] = currentTableCell.getCloneService();
                }
                catch (TextException excep) {
                    CloneException cloneException = new CloneException(excep.getMessage());
                    cloneException.initCause(excep);
                    throw cloneException;
                }
                ++h;
            }
            ++i;
        }
    }

    @Override
    public IClonedObject cloneAfterThisPosition(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.cloneToPosition(position, true, propertyKeysContainer);
    }

    @Override
    public void cloneAfterThisPositionNoReturn(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.cloneToPositionNoReturn(position, true, propertyKeysContainer);
    }

    @Override
    public IClonedObject cloneAfterThisPosition(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.cloneToPosition(position, adoptContent, propertyKeysContainer);
    }

    @Override
    public void cloneAfterThisPositionNoReturn(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.cloneToPositionNoReturn(position, adoptContent, propertyKeysContainer);
    }
}

