/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.internal.text.PageStyle;
import ag.ion.bion.officelayer.internal.text.TextTableCell;
import ag.ion.bion.officelayer.text.IPageStyle;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.text.ITextTableCell;
import ag.ion.bion.officelayer.text.ITextTableCellName;
import ag.ion.bion.officelayer.text.TextException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.table.XCell;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.Any;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XSelectionSupplier;

public class TextRange
implements ITextRange {
    private XTextRange xTextRange = null;
    private IDocument document = null;

    public TextRange(IDocument document, XTextRange xTextRange) throws IllegalArgumentException {
        if (xTextRange == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org XTextRange interface is not valid.");
        }
        this.xTextRange = xTextRange;
        this.document = document;
    }

    @Override
    public XTextRange getXTextRange() {
        return this.xTextRange;
    }

    @Override
    public IPageStyle getPageStyle() throws TextException {
        if (this.document == null || !(this.document instanceof ITextDocument)) {
            throw new TextException("Text style not available");
        }
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xTextRange);
            String pageStyleName = xPropertySet.getPropertyValue("PageStyleName").toString();
            XStyleFamiliesSupplier xStyleFamiliesSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)((ITextDocument)this.document).getXTextDocument());
            XNameAccess xNameAccess = xStyleFamiliesSupplier.getStyleFamilies();
            Any any = (Any)xNameAccess.getByName("PageStyles");
            XNameContainer xNameContainer = (XNameContainer)any.getObject();
            any = (Any)xNameContainer.getByName(pageStyleName);
            XStyle style = (XStyle)any.getObject();
            return new PageStyle(style);
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            return;
        }
        this.xTextRange.setString(text);
    }

    @Override
    public ITextTableCell getCell() {
        if (this.document == null || !(this.document instanceof ITextDocument)) {
            return null;
        }
        XCell xCell = (XCell)UnoRuntime.queryInterface(XCell.class, (Object)this.xTextRange.getText());
        if (xCell == null) {
            return null;
        }
        return new TextTableCell((ITextDocument)this.document, xCell);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public short compareRange(ITextRange textRangeToCompare) throws TextException {
        try {
            void var2_5;
            TextRange textRange = this;
            if (this.document instanceof ITextDocument) {
                ITextDocument textDocument = (ITextDocument)this.document;
                ITextTableCell thisCompareRangeCell = textRange.getCell();
                ITextTableCell textRangeToCompareCell = textRangeToCompare.getCell();
                if (thisCompareRangeCell != null && textRangeToCompareCell == null) {
                    XTextContent textTable = thisCompareRangeCell.getTextTable().getXTextContent();
                    XSelectionSupplier selectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)textDocument.getXTextDocument().getCurrentController());
                    selectionSupplier.select((Object)textTable);
                    XTextViewCursorSupplier xTextViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)textDocument.getXTextDocument().getCurrentController());
                    xTextViewCursorSupplier.getViewCursor().goLeft((short)1, false);
                    ITextRange iTextRange = textDocument.getViewCursorService().getViewCursor().getTextCursorFromEnd().getEnd();
                } else if (textRangeToCompareCell != null && thisCompareRangeCell == null) {
                    XTextContent textTable = textRangeToCompareCell.getTextTable().getXTextContent();
                    XSelectionSupplier selectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)textDocument.getXTextDocument().getCurrentController());
                    selectionSupplier.select((Object)textTable);
                    XTextViewCursorSupplier xTextViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)textDocument.getXTextDocument().getCurrentController());
                    xTextViewCursorSupplier.getViewCursor().goLeft((short)1, false);
                    textRangeToCompare = textDocument.getViewCursorService().getViewCursor().getTextCursorFromEnd().getEnd();
                } else if (thisCompareRangeCell != null && textRangeToCompareCell != null) {
                    XTextContent textRangeToCompareTable;
                    XTextContent thisCompareRangeTable = thisCompareRangeCell.getTextTable().getXTextContent();
                    boolean sameTable = UnoRuntime.areSame((Object)thisCompareRangeTable, (Object)(textRangeToCompareTable = textRangeToCompareCell.getTextTable().getXTextContent()));
                    if (sameTable) {
                        ITextTableCellName thisCompareRangeCellName = thisCompareRangeCell.getName();
                        ITextTableCellName textRangeToCompareCellName = textRangeToCompareCell.getName();
                        int thisCompareRangeCellRow = thisCompareRangeCellName.getRowIndex();
                        int thisCompareRangeCellCol = thisCompareRangeCellName.getColumnIndex();
                        int textRangeToCompareCellRow = textRangeToCompareCellName.getRowIndex();
                        int textRangeToCompareCellCol = textRangeToCompareCellName.getColumnIndex();
                        if (thisCompareRangeCellRow < textRangeToCompareCellRow) {
                            return 1;
                        }
                        if (thisCompareRangeCellRow > textRangeToCompareCellRow) {
                            return -1;
                        }
                        if (thisCompareRangeCellCol < textRangeToCompareCellCol) {
                            return 1;
                        }
                        if (thisCompareRangeCellCol > textRangeToCompareCellCol) {
                            return -1;
                        }
                    } else {
                        XSelectionSupplier selectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)textDocument.getXTextDocument().getCurrentController());
                        selectionSupplier.select((Object)thisCompareRangeTable);
                        XTextViewCursorSupplier xTextViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)textDocument.getXTextDocument().getCurrentController());
                        xTextViewCursorSupplier.getViewCursor().goLeft((short)1, false);
                        ITextRange iTextRange = textDocument.getViewCursorService().getViewCursor().getTextCursorFromEnd().getEnd();
                        selectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)textDocument.getXTextDocument().getCurrentController());
                        selectionSupplier.select((Object)textRangeToCompareTable);
                        xTextViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)textDocument.getXTextDocument().getCurrentController());
                        xTextViewCursorSupplier.getViewCursor().goLeft((short)1, false);
                        textRangeToCompare = textDocument.getViewCursorService().getViewCursor().getTextCursorFromEnd().getEnd();
                    }
                }
            }
            XText text = var2_5.getXTextRange().getText();
            XTextRangeCompare comparator = (XTextRangeCompare)UnoRuntime.queryInterface(XTextRangeCompare.class, (Object)text);
            try {
                return comparator.compareRegionStarts(var2_5.getXTextRange().getStart(), textRangeToCompare.getXTextRange().getStart());
            }
            catch (Exception exception) {
                throw new TextException(exception);
            }
        }
        catch (Exception exception) {
            throw new TextException(exception);
        }
    }

    @Override
    public void setDocument(IDocument document) {
        this.document = document;
    }
}

