/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.document;

import ag.ion.bion.officelayer.document.AbstractDocument;
import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.internal.document.DocumentService;
import ag.ion.bion.officelayer.internal.draw.DrawingDocument;
import ag.ion.bion.officelayer.internal.formula.FormulaDocument;
import ag.ion.bion.officelayer.internal.presentation.PresentationDocument;
import ag.ion.bion.officelayer.internal.spreadsheet.SpreadsheetDocument;
import ag.ion.bion.officelayer.internal.text.GlobalTextDocument;
import ag.ion.bion.officelayer.internal.text.TextDocument;
import ag.ion.bion.officelayer.internal.web.WebDocument;
import ag.ion.noa.internal.db.DatabaseDocument;
import ag.ion.noa.service.IServiceProvider;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XFrame;
import com.sun.star.io.XInputStream;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.presentation.XPresentationSupplier;
import com.sun.star.sdb.XOfficeDatabaseDocument;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import java.io.IOException;

public class DocumentLoader {
    public static IDocument loadDocument(IServiceProvider serviceProvider, String URL2) throws Exception, IOException {
        return DocumentLoader.loadDocument(serviceProvider, URL2, null);
    }

    public static IDocument loadDocument(IServiceProvider serviceProvider, String URL2, PropertyValue[] properties) throws Exception, IOException {
        if (properties == null) {
            properties = new PropertyValue[]{};
        }
        Object oDesktop = serviceProvider.createServiceWithContext("com.sun.star.frame.Desktop");
        XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)oDesktop);
        return DocumentLoader.loadDocument(serviceProvider, xComponentLoader, URL2, "_blank", 0, properties);
    }

    public static IDocument loadDocument(IServiceProvider serviceProvider, XInputStream xInputStream) throws Exception, IOException {
        return DocumentLoader.loadDocument(serviceProvider, xInputStream, null);
    }

    public static IDocument loadDocument(IServiceProvider serviceProvider, XInputStream xInputStream, PropertyValue[] properties) throws Exception, IOException {
        if (properties == null) {
            properties = new PropertyValue[]{};
        }
        PropertyValue[] newProperties = new PropertyValue[properties.length + 1];
        int i = 0;
        while (i < properties.length) {
            newProperties[i] = properties[i];
            ++i;
        }
        newProperties[properties.length] = new PropertyValue();
        newProperties[properties.length].Name = "InputStream";
        newProperties[properties.length].Value = xInputStream;
        Object oDesktop = serviceProvider.createServiceWithContext("com.sun.star.frame.Desktop");
        XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)oDesktop);
        return DocumentLoader.loadDocument(serviceProvider, xComponentLoader, "private:stream", "_blank", 0, newProperties);
    }

    public static IDocument loadDocument(IServiceProvider serviceProvider, XFrame xFrame, String URL2, int searchFlags, PropertyValue[] properties) throws Exception, IOException {
        System.out.println("DocumentLoader: loadDocument(5) begin");
        if (xFrame == null) {
            System.out.println("DocumentLoader: loadDocument(5): xFrame==null");
        } else {
            System.out.println("DocumentLoader: loadDocument(5): xFrame=" + xFrame.toString());
            System.out.println("DocumentLoader: loadDocument(5): xFrame.getCreator()=" + xFrame.getCreator());
            System.out.println("DocumentLoader: loadDocument(5): xFrame.getName()=" + xFrame.getName());
        }
        if (properties == null) {
            System.out.println("DocumentLoader: loadDocument(5): properties==null");
        } else {
            System.out.println("DocumentLoader: loadDocument(5): properties=" + properties.toString());
        }
        if (xFrame != null) {
            if (properties == null) {
                properties = new PropertyValue[]{};
            }
            XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xFrame);
            if (properties == null) {
                System.out.println("DocumentLoader: loadDocument(5): xComponentLoader==null");
            } else {
                System.out.println("DocumentLoader: loadDocument(5): xComponentLoader=" + xComponentLoader.toString());
            }
            System.out.println("DocumentLoader: loadDocument(5): about to directly return loadDocument(6)...");
            return DocumentLoader.loadDocument(serviceProvider, xComponentLoader, URL2, xFrame.getName(), searchFlags, properties);
        }
        System.out.println("DocumentLoader: loadDocument(5): WARNING: about to return null");
        return null;
    }

    private static IDocument loadDocument(IServiceProvider serviceProvider, XComponentLoader xComponentLoader, String URL2, String targetFrameName, int searchFlags, PropertyValue[] properties) throws Exception, IOException {
        System.out.println("DocumentLoader: loadDocument(6) begins");
        System.out.println("DocumentLoader: loadDocument(6): checkMaxOpenDocuments()...");
        DocumentService.checkMaxOpenDocuments(serviceProvider);
        System.out.println("DocumentLoader: loadDocument(6): xComponentLoader.loadComponentFromURL(4)...");
        if (URL2 == null) {
            System.out.println("DocumentLoader: URL==null");
        } else {
            System.out.println("DocumentLoader: URL=" + URL2.toString());
        }
        if (targetFrameName == null) {
            System.out.println("DocumentLoader: targetFrameName==null");
        } else {
            System.out.println("DocumentLoader: targetFrameName=" + URL2.toString());
        }
        System.out.println("DocumentLoader: searchFlags=" + searchFlags);
        if (properties == null) {
            System.out.println("DocumentLoader: properties==null");
        } else {
            System.out.println("DocumentLoader: properties=" + properties.toString());
        }
        XComponent xComponent = xComponentLoader.loadComponentFromURL(URL2, targetFrameName, searchFlags, properties);
        if (xComponent != null) {
            System.out.println("DocumentLoader: loadDocument(6): about to return getDocument(3)...");
            return DocumentLoader.getDocument(xComponent, serviceProvider, properties);
        }
        System.out.println("DocumentLoader: loadDocument(6): about to throw IOException: Document not found");
        throw new IOException("Document not found.");
    }

    public static IDocument getDocument(XComponent xComponent, IServiceProvider serviceProvider, PropertyValue[] intitialProperties) {
        XOfficeDatabaseDocument xOfficeDatabaseDocument;
        XTextDocument xTextDocument;
        System.out.println("DocumentLoader: getDocument(3) begin");
        if (intitialProperties == null) {
            intitialProperties = new PropertyValue[]{};
        }
        AbstractDocument document = null;
        System.out.println("DocumentLoader: getDocument(3) xServiceInfo=...UnoRuntime.queryInterface(2)...");
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xComponent);
        if (xServiceInfo == null) {
            System.out.println("DocumentLoader: getDocument(3): WARNING: xServiceInfo==null");
        } else {
            System.out.println("DocumentLoader: getDocument(3): xServiceInfo=" + xServiceInfo.toString());
            System.out.println("DocumentLoader: getDocument(3): xServiceInfo.getImplementationName()=" + xServiceInfo.getImplementationName());
            System.out.println("DocumentLoader: getDocument(3): xServiceInfo.getSupportedServiceNames()=" + xServiceInfo.getSupportedServiceNames());
        }
        if (xServiceInfo.supportsService("com.sun.star.text.TextDocument")) {
            System.out.println("DocumentLoader: getDocument(3) xServiceInfo supports com.sun.star.text.TextDocument");
            System.out.println("DocumentLoader: getting xTextDocument...");
            xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
            if (xTextDocument == null) {
                System.out.println("DocumentLoader: getDocument(3): WARNING: xTextDocument==null");
            } else {
                System.out.println("DocumentLoader: getDocument(3): xTextDocument=" + xTextDocument.toString());
            }
            if (xTextDocument != null) {
                System.out.println("DocumentLoader: getDocument(3): allocating document from TextDocument(xTextDocument, initialProperties)...");
                document = new TextDocument(xTextDocument, intitialProperties);
            }
        } else if (xServiceInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument")) {
            XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xComponent);
            if (xSpreadsheetDocument != null) {
                document = new SpreadsheetDocument(xSpreadsheetDocument, intitialProperties);
            }
        } else if (xServiceInfo.supportsService("com.sun.star.presentation.PresentationDocument")) {
            XPresentationSupplier presentationSupplier = (XPresentationSupplier)UnoRuntime.queryInterface(XPresentationSupplier.class, (Object)xComponent);
            if (presentationSupplier != null) {
                document = new PresentationDocument(presentationSupplier, intitialProperties);
            }
        } else if (xServiceInfo.supportsService("com.sun.star.drawing.DrawingDocument")) {
            XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xComponent);
            if (xDrawPagesSupplier != null) {
                document = new DrawingDocument(xDrawPagesSupplier, intitialProperties);
            }
        } else if (xServiceInfo.supportsService("com.sun.star.formula.FormulaProperties")) {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xComponent);
            if (xPropertySet != null) {
                document = new FormulaDocument(xPropertySet, intitialProperties);
            }
        } else if (xServiceInfo.supportsService("com.sun.star.text.WebDocument")) {
            xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
            if (xTextDocument != null) {
                document = new WebDocument(xTextDocument, intitialProperties);
            }
        } else if (xServiceInfo.supportsService("com.sun.star.text.GlobalDocument")) {
            xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
            if (xTextDocument != null) {
                document = new GlobalTextDocument(xTextDocument, intitialProperties);
            }
        } else if (xServiceInfo.supportsService("com.sun.star.sdb.OfficeDatabaseDocument") && (xOfficeDatabaseDocument = (XOfficeDatabaseDocument)UnoRuntime.queryInterface(XOfficeDatabaseDocument.class, (Object)xComponent)) != null) {
            document = new DatabaseDocument(xOfficeDatabaseDocument, intitialProperties);
        }
        if (document == null) {
            System.out.println("DocumentLoader: getDocument(3): WARNING: document==null");
        } else {
            System.out.println("DocumentLoader: getDocument(3): document=" + document.toString());
        }
        System.out.println("DocumentLoader: getDocument(3): About to do some processing on hidden or non hidden frames...");
        if (document != null && document instanceof AbstractDocument) {
            ((AbstractDocument)document).setServiceProvider(serviceProvider);
            boolean isHidden = false;
            int i = 0;
            while (i < intitialProperties.length) {
                if (intitialProperties[i].Name.equals("Hidden") && intitialProperties[i].Value.equals(Boolean.TRUE)) {
                    isHidden = true;
                    break;
                }
                ++i;
            }
            if (!isHidden) {
                XWindow containerWindow = document.getFrame().getXFrame().getContainerWindow();
                containerWindow.setVisible(false);
                containerWindow.setVisible(true);
            }
        }
        System.out.println("DocumentLoader: getDocument(3): About to return document...");
        return document;
    }
}

