/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.constants;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.LoggerFactory;

public final class Elexis {
    public static final String VERSION = Elexis.initElexisBuildVersion();
    public static final String APPLICATION_NAME = "Elexis Core";

    private static String initElexisBuildVersion() {
        String version = FrameworkUtil.getBundle(Elexis.class).getVersion().toString();
        String url_name = "platform:/plugin/ch.elexis.core.data/rsc/version.properties";
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = new URL(url_name).openConnection().getInputStream();){
                if (inputStream != null) {
                    Properties prop = new Properties();
                    prop.load(inputStream);
                    version = prop.getProperty("elexis.version");
                    LoggerFactory.getLogger(Elexis.class).trace("set version from " + url_name + " to " + version);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(Elexis.class).info(String.valueOf(url_name) + " not found", (Throwable)e);
        }
        return version;
    }
}

