/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.EHC_E04_PRODUCT_SERVICE_SECTION;
import ca.uhn.hl7v2.model.v26.segment.IVC;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E04
extends AbstractMessage {
    public EHC_E04() {
        this(new DefaultModelClassFactory());
    }

    public EHC_E04(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, true);
            this.add(IVC.class, true, false);
            this.add(NTE.class, false, true);
            this.add(EHC_E04_PRODUCT_SERVICE_SECTION.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E04 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public UAC getUAC(int rep) {
        return this.getTyped("UAC", rep, UAC.class);
    }

    public int getUACReps() {
        return this.getReps("UAC");
    }

    public List<UAC> getUACAll() throws HL7Exception {
        return this.getAllAsList("UAC", UAC.class);
    }

    public void insertUAC(UAC structure, int rep) throws HL7Exception {
        super.insertRepetition("UAC", structure, rep);
    }

    public UAC insertUAC(int rep) throws HL7Exception {
        return (UAC)super.insertRepetition("UAC", rep);
    }

    public UAC removeUAC(int rep) throws HL7Exception {
        return (UAC)super.removeRepetition("UAC", rep);
    }

    public IVC getIVC() {
        return this.getTyped("IVC", IVC.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public EHC_E04_PRODUCT_SERVICE_SECTION getPRODUCT_SERVICE_SECTION() {
        return this.getTyped("PRODUCT_SERVICE_SECTION", EHC_E04_PRODUCT_SERVICE_SECTION.class);
    }

    public EHC_E04_PRODUCT_SERVICE_SECTION getPRODUCT_SERVICE_SECTION(int rep) {
        return this.getTyped("PRODUCT_SERVICE_SECTION", rep, EHC_E04_PRODUCT_SERVICE_SECTION.class);
    }

    public int getPRODUCT_SERVICE_SECTIONReps() {
        return this.getReps("PRODUCT_SERVICE_SECTION");
    }

    public List<EHC_E04_PRODUCT_SERVICE_SECTION> getPRODUCT_SERVICE_SECTIONAll() throws HL7Exception {
        return this.getAllAsList("PRODUCT_SERVICE_SECTION", EHC_E04_PRODUCT_SERVICE_SECTION.class);
    }

    public void insertPRODUCT_SERVICE_SECTION(EHC_E04_PRODUCT_SERVICE_SECTION structure, int rep) throws HL7Exception {
        super.insertRepetition("PRODUCT_SERVICE_SECTION", structure, rep);
    }

    public EHC_E04_PRODUCT_SERVICE_SECTION insertPRODUCT_SERVICE_SECTION(int rep) throws HL7Exception {
        return (EHC_E04_PRODUCT_SERVICE_SECTION)super.insertRepetition("PRODUCT_SERVICE_SECTION", rep);
    }

    public EHC_E04_PRODUCT_SERVICE_SECTION removePRODUCT_SERVICE_SECTION(int rep) throws HL7Exception {
        return (EHC_E04_PRODUCT_SERVICE_SECTION)super.removeRepetition("PRODUCT_SERVICE_SECTION", rep);
    }
}

