/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.group.OUL_R24_RESULT;
import ca.uhn.hl7v2.model.v25.group.OUL_R24_SPECIMEN;
import ca.uhn.hl7v2.model.v25.group.OUL_R24_TIMING_QTY;
import ca.uhn.hl7v2.model.v25.segment.CTI;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.OBR;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OUL_R24_ORDER
extends AbstractGroup {
    public OUL_R24_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, false);
            this.add(ORC.class, false, false, false);
            this.add(NTE.class, false, true, false);
            this.add(OUL_R24_TIMING_QTY.class, false, true, false);
            this.add(OUL_R24_SPECIMEN.class, false, true, false);
            this.add(OUL_R24_RESULT.class, false, true, false);
            this.add(CTI.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OUL_R24_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OUL_R24_TIMING_QTY getTIMING_QTY() {
        OUL_R24_TIMING_QTY retVal = this.getTyped("TIMING_QTY", OUL_R24_TIMING_QTY.class);
        return retVal;
    }

    public OUL_R24_TIMING_QTY getTIMING_QTY(int rep) {
        OUL_R24_TIMING_QTY retVal = this.getTyped("TIMING_QTY", rep, OUL_R24_TIMING_QTY.class);
        return retVal;
    }

    public int getTIMING_QTYReps() {
        return this.getReps("TIMING_QTY");
    }

    public List<OUL_R24_TIMING_QTY> getTIMING_QTYAll() throws HL7Exception {
        return this.getAllAsList("TIMING_QTY", OUL_R24_TIMING_QTY.class);
    }

    public void insertTIMING_QTY(OUL_R24_TIMING_QTY structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_QTY", structure, rep);
    }

    public OUL_R24_TIMING_QTY insertTIMING_QTY(int rep) throws HL7Exception {
        return (OUL_R24_TIMING_QTY)super.insertRepetition("TIMING_QTY", rep);
    }

    public OUL_R24_TIMING_QTY removeTIMING_QTY(int rep) throws HL7Exception {
        return (OUL_R24_TIMING_QTY)super.removeRepetition("TIMING_QTY", rep);
    }

    public OUL_R24_SPECIMEN getSPECIMEN() {
        OUL_R24_SPECIMEN retVal = this.getTyped("SPECIMEN", OUL_R24_SPECIMEN.class);
        return retVal;
    }

    public OUL_R24_SPECIMEN getSPECIMEN(int rep) {
        OUL_R24_SPECIMEN retVal = this.getTyped("SPECIMEN", rep, OUL_R24_SPECIMEN.class);
        return retVal;
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<OUL_R24_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", OUL_R24_SPECIMEN.class);
    }

    public void insertSPECIMEN(OUL_R24_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", structure, rep);
    }

    public OUL_R24_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (OUL_R24_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public OUL_R24_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (OUL_R24_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }

    public OUL_R24_RESULT getRESULT() {
        OUL_R24_RESULT retVal = this.getTyped("RESULT", OUL_R24_RESULT.class);
        return retVal;
    }

    public OUL_R24_RESULT getRESULT(int rep) {
        OUL_R24_RESULT retVal = this.getTyped("RESULT", rep, OUL_R24_RESULT.class);
        return retVal;
    }

    public int getRESULTReps() {
        return this.getReps("RESULT");
    }

    public List<OUL_R24_RESULT> getRESULTAll() throws HL7Exception {
        return this.getAllAsList("RESULT", OUL_R24_RESULT.class);
    }

    public void insertRESULT(OUL_R24_RESULT structure, int rep) throws HL7Exception {
        super.insertRepetition("RESULT", structure, rep);
    }

    public OUL_R24_RESULT insertRESULT(int rep) throws HL7Exception {
        return (OUL_R24_RESULT)super.insertRepetition("RESULT", rep);
    }

    public OUL_R24_RESULT removeRESULT(int rep) throws HL7Exception {
        return (OUL_R24_RESULT)super.removeRepetition("RESULT", rep);
    }

    public CTI getCTI() {
        CTI retVal = this.getTyped("CTI", CTI.class);
        return retVal;
    }

    public CTI getCTI(int rep) {
        CTI retVal = this.getTyped("CTI", rep, CTI.class);
        return retVal;
    }

    public int getCTIReps() {
        return this.getReps("CTI");
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }
}

