/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ACC
extends AbstractSegment {
    public ACC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Accident date / time");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(50)}, "Accident code");
            this.add(ST.class, false, 1, 25, new Object[]{this.getMessage()}, "Accident location");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ACC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public TS getAccidentDateTime() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getAcc1_AccidentDateTime() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getAccidentCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getAcc2_AccidentCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getAccidentLocation() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getAcc3_AccidentLocation() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new TS(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(50));
            }
            case 2: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

