/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.ID;
import ca.uhn.hl7v2.model.v21.datatype.SI;
import ca.uhn.hl7v2.model.v21.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class NTE
extends AbstractSegment {
    public NTE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "SET ID - NOTES AND COMMENTS");
            this.add(ID.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(105)}, "SOURCE OF COMMENT");
            this.add(TX.class, true, 0, 120, new Object[]{this.getMessage()}, "COMMENT");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating NTE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSETIDNOTESANDCOMMENTS() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getNte1_SETIDNOTESANDCOMMENTS() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSOURCEOFCOMMENT() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getNte2_SOURCEOFCOMMENT() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public TX[] getCOMMENT() {
        TX[] retVal = (TX[])this.getTypedField(3, new TX[0]);
        return retVal;
    }

    public TX[] getNte3_COMMENT() {
        TX[] retVal = (TX[])this.getTypedField(3, new TX[0]);
        return retVal;
    }

    public int getCOMMENTReps() {
        return this.getReps(3);
    }

    public TX getCOMMENT(int rep) {
        TX retVal = (TX)this.getTypedField(3, rep);
        return retVal;
    }

    public TX getNte3_COMMENT(int rep) {
        TX retVal = (TX)this.getTypedField(3, rep);
        return retVal;
    }

    public int getNte3_COMMENTReps() {
        return this.getReps(3);
    }

    public TX insertCOMMENT(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(3, rep);
    }

    public TX insertNte3_COMMENT(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(3, rep);
    }

    public TX removeCOMMENT(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(3, rep);
    }

    public TX removeNte3_COMMENT(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(3, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(105));
            }
            case 2: {
                return new TX(this.getMessage());
            }
        }
        return null;
    }
}

