/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.chromium;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.AuthenticationListener;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.chromium.Browser;
import org.eclipse.swt.chromium.BrowserFunction;
import org.eclipse.swt.chromium.OpenWindowListener;
import org.eclipse.swt.chromium.WebBrowser;
import org.eclipse.swt.chromium.WindowEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.CallbackExt;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.chromium.CEFFactory;
import org.eclipse.swt.internal.chromium.ResourceExpander;
import org.eclipse.swt.internal.chromium.lib.ChromiumLib;
import org.eclipse.swt.internal.chromium.lib.DownloadItem;
import org.eclipse.swt.internal.chromium.lib.FunctionSt;
import org.eclipse.swt.internal.chromium.lib.cef_app_t;
import org.eclipse.swt.internal.chromium.lib.cef_browser_process_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_client_t;
import org.eclipse.swt.internal.chromium.lib.cef_context_menu_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_cookie_visitor_t;
import org.eclipse.swt.internal.chromium.lib.cef_display_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_download_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_focus_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_jsdialog_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_key_event_t;
import org.eclipse.swt.internal.chromium.lib.cef_keyboard_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_life_span_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_load_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_popup_features_t;
import org.eclipse.swt.internal.chromium.lib.cef_request_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_string_visitor_t;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class Chromium
extends WebBrowser {
    private static final String DATA_TEXT_URL = "data:text/html;base64,";
    private static final String VERSION = "76016";
    private static final String CEFVERSION = "3809";
    private static final String SHARED_LIB_V = "chromium_swt_76016";
    private static final String JNI_LIB_V = "swt-chromium-76016";
    private static final int MAX_PROGRESS = 100;
    private static final int LOOP = 33;
    private static final boolean debug = Boolean.valueOf(System.getProperty("swt.chromium.debug", "false"));
    private static Object lib = Chromium.loadLib();
    private static String cefrustPath;
    private static cef_app_t app;
    private static cef_browser_process_handler_t browserProcessHandler;
    private static boolean shuttindDown;
    private static cef_cookie_visitor_t cookieVisitor;
    private static CompletableFuture<Boolean> cookieVisited;
    private static AtomicInteger browsers;
    private static Map<Integer, Chromium> instances;
    private static Deque<Chromium> instancesNew;
    private static Runnable loopWork;
    private static boolean loopDisable;
    private static boolean pumpDisable;
    private static int disposingAny;
    private static int popupHandlers;
    private static cef_client_t clientHandler;
    private static cef_focus_handler_t focusHandler;
    private static cef_keyboard_handler_t keyboardHandler;
    private static cef_life_span_handler_t lifeSpanHandler;
    private static cef_load_handler_t loadHandler;
    private static cef_display_handler_t displayHandler;
    private static cef_request_handler_t requestHandler;
    private static cef_jsdialog_handler_t jsDialogHandler;
    private static cef_context_menu_handler_t contextMenuHandler;
    private static cef_download_handler_t downloadHandler;
    private static cef_client_t popupClientHandler;
    private static cef_life_span_handler_t popupLifeSpanHandler;
    private CompletableFuture<String> textVisited;
    Browser chromium;
    OpenWindowListener[] openWindowListeners = new OpenWindowListener[0];
    private long hwnd;
    private long browser;
    private FocusListener focusListener;
    private String url;
    private String postData;
    private String[] headers;
    private String title = "";
    private boolean canGoBack;
    private boolean canGoForward;
    private CompletableFuture<Boolean> enableProgress = new CompletableFuture();
    private CompletableFuture<Boolean> created = new CompletableFuture();
    private Dispose disposing = Dispose.No;
    private int instance;
    private boolean hasFocus;
    private boolean ignoreFirstFocus = true;
    private PaintListener paintListener;
    private Listener traverseListener;
    private WindowEvent isPopup;
    private int reentrant = 0;
    private boolean loadingPage;
    static Runnable loopWorkRunnable;

    static {
        browsers = new AtomicInteger(0);
        instances = new HashMap<Integer, Chromium>();
        instancesNew = new ArrayDeque<Chromium>();
        disposingAny = 0;
        popupHandlers = 0;
        loopWorkRunnable = () -> {
            Display display = Display.getCurrent();
            if (display == null || display.isDisposed()) {
                return;
            }
            Chromium.safe_loop_work("pump");
        };
    }

    public void addOpenWindowListener(OpenWindowListener listener) {
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length + 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, this.openWindowListeners.length);
        this.openWindowListeners = newOpenWindowListeners;
        this.openWindowListeners[this.openWindowListeners.length - 1] = listener;
    }

    public void removeOpenWindowListener(OpenWindowListener listener) {
        if (this.openWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.openWindowListeners.length) {
            if (listener == this.openWindowListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.openWindowListeners.length == 1) {
            this.openWindowListeners = new OpenWindowListener[0];
            return;
        }
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length - 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, index);
        System.arraycopy(this.openWindowListeners, index + 1, newOpenWindowListeners, index, this.openWindowListeners.length - index - 1);
        this.openWindowListeners = newOpenWindowListeners;
    }

    public void setBrowser(Browser browser) {
        super.setBrowser(browser);
        this.chromium = browser;
    }

    public void createFunction(BrowserFunction function) {
        this.created.thenRun(() -> {
            this.checkBrowser();
            for (BrowserFunction current : this.functions.values()) {
                if (!current.name.equals(browserFunction.name)) continue;
                this.deregisterFunction(current);
                break;
            }
            browserFunction.index = this.getNextFunctionIndex();
            this.registerFunction(function);
            if (!ChromiumLib.cefswt_function(this.browser, browserFunction.name, browserFunction.index)) {
                throw new SWTException("Cannot create BrowserFunction");
            }
        });
    }

    public void destroyFunction(BrowserFunction function) {
        this.checkBrowser();
        this.deregisterFunction(function);
    }

    public void create(Composite parent, int style) {
        Chromium.initCEF(this.chromium.getDisplay());
        this.chromium.setBackground(parent.getDisplay().getSystemColor(37));
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Chromium.this.debugPrint("paintControl");
                if (Chromium.this.isDisposed()) {
                    return;
                }
                if (!Boolean.getBoolean("swt.chromium.headless")) {
                    Chromium.this.chromium.removePaintListener((PaintListener)this);
                }
                Chromium.this.createBrowser();
                Chromium.this.paintListener = null;
            }
        };
        if (Boolean.getBoolean("swt.chromium.headless")) {
            this.chromium.getDisplay().timerExec(300, () -> {
                if (this.paintListener != null) {
                    this.paintListener.paintControl(null);
                }
            });
        } else {
            this.chromium.addPaintListener(this.paintListener);
        }
    }

    private void debugPrint(String log) {
        if (debug) {
            System.out.println(String.valueOf(System.currentTimeMillis() / 1000L) + ":J" + this.instance + ":" + Thread.currentThread().getName() + ":" + log + (this.url != null ? " (" + Chromium.getPlainUrl(this.url) + ")" : " empty-url"));
        }
    }

    private static void debug(String log) {
        if (debug) {
            System.out.println("J:" + log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initCEF(Display display) {
        Object object = lib;
        synchronized (object) {
            if (app == null) {
                app = CEFFactory.newApp();
                browserProcessHandler = CEFFactory.newBrowserProcessHandler();
                Chromium.browserProcessHandler.on_schedule_message_pump_work_cb = new CallbackExt(Chromium.class, "on_schedule_message_pump_work", Void.TYPE, new Type[]{Long.TYPE, Integer.TYPE, Integer.TYPE});
                Chromium.browserProcessHandler.on_schedule_message_pump_work = Chromium.checkGetAddress(Chromium.browserProcessHandler.on_schedule_message_pump_work_cb);
                Chromium.app.get_browser_process_handler_cb = new CallbackExt(Chromium.class, "get_browser_process_handler", Long.TYPE, new Type[]{Long.TYPE});
                Chromium.app.get_browser_process_handler = Chromium.checkGetAddress(Chromium.app.get_browser_process_handler_cb);
                Chromium.browserProcessHandler.ptr = C.malloc((long)cef_browser_process_handler_t.sizeof);
                ChromiumLib.memmove(Chromium.browserProcessHandler.ptr, browserProcessHandler, cef_browser_process_handler_t.sizeof);
                Chromium.app.on_before_command_line_processing_cb = new CallbackExt(Chromium.class, "on_before_command_line_processing", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
                Chromium.app.on_before_command_line_processing = Chromium.checkGetAddress(Chromium.app.on_before_command_line_processing_cb);
                int debugPort = 0;
                try {
                    debugPort = Integer.parseInt(System.getProperty("org.eclipse.swt.chromium.remote-debugging-port", "0"));
                }
                catch (NumberFormatException e) {
                    debugPort = 0;
                }
                if (debugPort == 0 && debug) {
                    debugPort = -2;
                }
                Chromium.app.ptr = C.malloc((long)cef_app_t.sizeof);
                ChromiumLib.memmove(Chromium.app.ptr, app, cef_app_t.sizeof);
                boolean suspend = "win32".equals(SWT.getPlatform()) ? false : System.getProperty("swt.chromium.suspendThreads", "true").equals("true");
                Thread main = null;
                Thread[] threads = null;
                int threadsCount = 0;
                if (suspend) {
                    main = Thread.currentThread();
                    threads = new Thread[Thread.activeCount() * 2];
                    threadsCount = Thread.enumerate(threads);
                    int i = 0;
                    while (i < threadsCount) {
                        Thread t = threads[i];
                        if (t != main) {
                            t.suspend();
                        }
                        ++i;
                    }
                }
                String platform = SWT.getPlatform();
                String cachePath = System.getProperty("swt.chromium.cachepath", String.valueOf(cefrustPath) + File.separator + "cache");
                String pump = System.getProperty("swt.chromium.external_message_pump", "win32".equals(SWT.getPlatform()) ? "true" : "false");
                String opts = "76016;cache_path=" + cachePath + ";external_message_pump=" + pump;
                ChromiumLib.cefswt_init(Chromium.app.ptr, cefrustPath, opts, debugPort);
                if (suspend) {
                    int i = 0;
                    while (i < threadsCount) {
                        Thread t = threads[i];
                        if (t != main) {
                            t.resume();
                        }
                        ++i;
                    }
                }
                display.disposeExec(() -> {
                    if (app == null || shuttindDown) {
                        return;
                    }
                    Chromium.internalShutdown();
                });
            }
        }
    }

    static long get_browser_process_handler(long app) {
        if (browserProcessHandler == null) {
            return 0L;
        }
        return Chromium.browserProcessHandler.ptr;
    }

    static void on_before_command_line_processing(long app, long process_type, long command_line) {
        String vmArg = System.getProperty("swt.chromium.args");
        vmArg = vmArg == null ? "" : vmArg;
        String deviceZoom = System.getProperty("org.eclipse.swt.internal.deviceZoom");
        if ("gtk".equals(SWT.getPlatform()) && deviceZoom != null && !"100".equals(deviceZoom) && !vmArg.contains("device-scale-factor")) {
            try {
                int zoom = Integer.parseInt(deviceZoom);
                float scale = (float)zoom / 100.0f;
                String scaleArg = "--high-dpi-support=1;--force-device-scale-factor=" + scale;
                vmArg = vmArg.isEmpty() ? scaleArg : String.valueOf(vmArg) + ";" + scaleArg;
            }
            catch (NumberFormatException zoom) {
                // empty catch block
            }
        }
        if (!vmArg.isEmpty()) {
            String[] lines = vmArg.split(";");
            int i = 0;
            while (i < lines.length) {
                String cmdlineArg = lines[i];
                String[] argParts = new String[2];
                String[] argSplitted = cmdlineArg.split("=", 2);
                int j = 0;
                while (j < argSplitted.length) {
                    argParts[j] = argSplitted[j];
                    ++j;
                }
                if (argParts[0] != null && !argParts[0].isEmpty()) {
                    ChromiumLib.cefswt_set_command(command_line, argParts[0], argParts[1]);
                }
                ++i;
            }
        }
        ChromiumLib.cefswt_ref(command_line, 0);
    }

    static void on_schedule_message_pump_work(long pbrowserProcessHandler, int delay, int _delay2) {
        if (browsers.get() <= 0 || pumpDisable || disposingAny > 0) {
            return;
        }
        Display display = Display.getDefault();
        Runnable scheduleWork = () -> {
            Chromium.restartLoop(display, delay);
            display.timerExec(-1, loopWorkRunnable);
            display.timerExec(delay, loopWorkRunnable);
        };
        if (Display.getCurrent() != null) {
            if (delay <= 0) {
                Chromium.restartLoop(display, 0);
                display.asyncExec(loopWorkRunnable);
            } else {
                scheduleWork.run();
            }
        } else if (delay <= 0) {
            display.asyncExec(() -> {
                Chromium.restartLoop(display, 0);
                loopWorkRunnable.run();
            });
        } else {
            display.asyncExec(scheduleWork);
        }
    }

    private static void safe_loop_work(String from) {
        if (browsers.get() > 0 && !loopDisable) {
            if (ChromiumLib.cefswt_do_message_loop_work() == 0) {
                System.err.println("error looping chromium");
            }
            if (pumpDisable) {
                pumpDisable = false;
            }
        }
    }

    private static void restartLoop(Display display, int ms) {
        if (loopWork != null) {
            display.timerExec(-1, loopWork);
            display.timerExec(33 + ms, loopWork);
        }
    }

    private long getHandle(Composite control) {
        long hwnd = 0L;
        String platform = SWT.getPlatform();
        if ("cocoa".equals(platform)) {
            try {
                Field field = Control.class.getDeclaredField("view");
                field.setAccessible(true);
                Object nsview = field.get(control);
                Class<?> idClass = Class.forName("org.eclipse.swt.internal.cocoa.id");
                Field idField = idClass.getField("id");
                hwnd = (Long)idField.get(nsview);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("win32".equals(platform)) {
            try {
                Field field = Control.class.getDeclaredField("handle");
                field.setAccessible(true);
                hwnd = (Long)field.get(control);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                Field field = Widget.class.getDeclaredField("handle");
                field.setAccessible(true);
                hwnd = (Long)field.get(control);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return hwnd;
    }

    private void prepareBrowser() {
        this.hwnd = this.getHandle((Composite)this.chromium);
        this.chromium.addDisposeListener(e -> {
            this.debugPrint("disposing chromium");
            this.dispose();
        });
        this.focusListener = new CefFocusListener();
        this.chromium.addFocusListener(this.focusListener);
        if (clientHandler == null) {
            Chromium.set_client_handler();
        }
        this.chromium.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!Chromium.this.isDisposed() && Chromium.this.browser != 0L) {
                    Point size = Chromium.this.getChromiumSize(false);
                    ChromiumLib.cefswt_resized(Chromium.this.browser, size.x, size.y);
                }
            }
        });
    }

    private void createBrowser() {
        if (this.url == null) {
            this.url = "about:blank";
        }
        this.prepareBrowser();
        if (!"gtk".equals(SWT.getPlatform())) {
            this.traverseListener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 31) {
                        event.doit = false;
                    }
                }
            };
        }
        if ("win32".equals(SWT.getPlatform())) {
            this.chromium.addListener(31, this.traverseListener);
            this.chromium.addListener(1, this.traverseListener);
        }
        if ("cocoa".equals(SWT.getPlatform())) {
            this.chromium.addListener(1, this.traverseListener);
        }
        Display display = this.chromium.getDisplay();
        Color bg = this.chromium.getBackground();
        Color bgColor = bg != null ? bg : display.getSystemColor(22);
        int cefBgColor = this.cefColor(bgColor.getAlpha(), bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
        Point size = this.getChromiumSize(true);
        Chromium.debug("Registering chromium instance new");
        instancesNew.add(this);
        ChromiumLib.cefswt_create_browser(this.hwnd, this.url, Chromium.clientHandler.ptr, size.x, size.y, this.jsEnabledOnNextPage ? 1 : 0, cefBgColor);
    }

    private void createPopup(long windowInfo, long client, WindowEvent event) {
        if (this.paintListener != null) {
            if (!Boolean.getBoolean("swt.chromium.headless")) {
                this.chromium.removePaintListener(this.paintListener);
            }
            this.paintListener = null;
        } else {
            Chromium.debug("Unregistering chromium phantom popup " + this.instance);
            instances.remove(this.instance);
        }
        Chromium.debug("Registering chromium popup new");
        instancesNew.add(this);
        this.isPopup = event;
        String platform = SWT.getPlatform();
        if ("gtk".equals(platform) && this.chromium.getDisplay().getActiveShell() != this.chromium.getShell()) {
            boolean visible = this.chromium.getShell().isVisible();
            this.chromium.getShell().open();
            this.chromium.getShell().setVisible(visible);
        }
        this.prepareBrowser();
        long popupHandle = this.hwnd;
        this.debugPrint("popup will use hwnd:" + popupHandle);
        Point size = new Point(0, 0);
        if ("gtk".equals(SWT.getPlatform())) {
            size = this.chromium.getParent().getSize();
            size = DPIUtil.autoScaleUp((Point)size);
        }
        ChromiumLib.cefswt_set_window_info_parent(windowInfo, client, Chromium.clientHandler.ptr, popupHandle, 0, 0, size.x, size.y);
        this.debugPrint("reparent popup");
    }

    private void createDefaultPopup(long windowInfo, long client, WindowEvent event) {
        this.debugPrint("default popup");
        Chromium.debug("Registering chromium default popup new");
        if (popupHandlers == 0) {
            popupLifeSpanHandler = CEFFactory.newLifeSpanHandler();
            Chromium.popupLifeSpanHandler.on_after_created_cb = new CallbackExt(Chromium.class, "popup_on_after_created", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
            Chromium.popupLifeSpanHandler.on_after_created = Chromium.checkGetAddress(Chromium.popupLifeSpanHandler.on_after_created_cb);
            Chromium.popupLifeSpanHandler.on_before_close_cb = new CallbackExt(Chromium.class, "popup_on_before_close", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
            Chromium.popupLifeSpanHandler.on_before_close = Chromium.checkGetAddress(Chromium.popupLifeSpanHandler.on_before_close_cb);
            Chromium.popupLifeSpanHandler.do_close_cb = new CallbackExt(Chromium.class, "popup_do_close", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE});
            Chromium.popupLifeSpanHandler.do_close = Chromium.checkGetAddress(Chromium.popupLifeSpanHandler.do_close_cb);
            Chromium.popupLifeSpanHandler.ptr = C.malloc((long)cef_life_span_handler_t.sizeof);
            ChromiumLib.memmove(Chromium.popupLifeSpanHandler.ptr, popupLifeSpanHandler, cef_life_span_handler_t.sizeof);
            if (popupClientHandler == null) {
                popupClientHandler = CEFFactory.newClient();
                Chromium.popupClientHandler.get_life_span_handler_cb = new CallbackExt(Chromium.class, "popup_get_life_span_handler", Long.TYPE, new Type[]{Long.TYPE});
                Chromium.popupClientHandler.get_life_span_handler = Chromium.checkGetAddress(Chromium.popupClientHandler.get_life_span_handler_cb);
                Chromium.popupClientHandler.ptr = C.malloc((long)cef_client_t.sizeof);
                ChromiumLib.memmove(Chromium.popupClientHandler.ptr, popupClientHandler, cef_client_t.sizeof);
            }
        }
        ++popupHandlers;
        ChromiumLib.cefswt_set_window_info_parent(windowInfo, client, Chromium.popupClientHandler.ptr, 0L, event.location != null ? event.location.x : 0, event.location != null ? event.location.y : 0, event.size != null ? event.size.x : 0, event.size != null ? event.size.y : 0);
    }

    static long popup_get_life_span_handler(long client) {
        if (popupLifeSpanHandler == null) {
            return 0L;
        }
        return Chromium.popupLifeSpanHandler.ptr;
    }

    static void popup_on_after_created(long plifeSpanHandler, long browser) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("popup on_after_created: " + id);
        try {
            Thread.sleep(33L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ChromiumLib.cefswt_ref(browser, 0);
    }

    static void popup_on_before_close(long plifeSpanHandler, long browser) {
        Chromium.debug("popup OnBeforeClose");
        if (--popupHandlers == 0) {
            Chromium.disposeCallback(Chromium.popupLifeSpanHandler.on_after_created_cb);
            Chromium.disposeCallback(Chromium.popupLifeSpanHandler.do_close_cb);
            Chromium.disposeCallback(Chromium.popupLifeSpanHandler.on_before_close_cb);
            C.free((long)Chromium.popupLifeSpanHandler.ptr);
            popupLifeSpanHandler = null;
        }
        --disposingAny;
        ChromiumLib.cefswt_ref(browser, 0);
    }

    static int popup_do_close(long plifeSpanHandler, long browser) {
        Chromium.debug("popup DoClose");
        ++disposingAny;
        ChromiumLib.cefswt_ref(browser, 0);
        return 0;
    }

    private int cefColor(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b << 0;
    }

    private Point getChromiumSize(boolean fixInitial) {
        Point size = this.chromium.getSize();
        if ("cocoa".equals(SWT.getPlatform())) {
            return size;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            Point p = new Point(DPIUtil.autoScaleUpUsingNativeDPI((int)size.x), DPIUtil.autoScaleUpUsingNativeDPI((int)size.y));
            if (fixInitial && !size.equals((Object)p)) {
                --p.x;
                --p.y;
            }
            return p;
        }
        return DPIUtil.autoScaleUp((Point)size);
    }

    private static void set_client_handler() {
        clientHandler = CEFFactory.newClient();
        Chromium.set_focus_handler();
        Chromium.set_keyboard_handler();
        Chromium.set_life_span_handler();
        Chromium.set_load_handler();
        Chromium.set_display_handler();
        Chromium.set_request_handler();
        Chromium.set_jsdialog_handler();
        Chromium.set_context_menu_handler();
        Chromium.set_download_handler();
        Chromium.clientHandler.on_process_message_received_cb = new CallbackExt(Chromium.class, "on_process_message_received", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE});
        Chromium.clientHandler.on_process_message_received = Chromium.checkGetAddress(Chromium.clientHandler.on_process_message_received_cb);
        Chromium.clientHandler.ptr = C.malloc((long)cef_client_t.sizeof);
        ChromiumLib.memmove(Chromium.clientHandler.ptr, clientHandler, cef_client_t.sizeof);
    }

    private static void set_life_span_handler() {
        lifeSpanHandler = CEFFactory.newLifeSpanHandler();
        Chromium.lifeSpanHandler.on_before_close_cb = new CallbackExt(Chromium.class, "on_before_close", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
        Chromium.lifeSpanHandler.on_before_close = Chromium.checkGetAddress(Chromium.lifeSpanHandler.on_before_close_cb);
        Chromium.lifeSpanHandler.do_close_cb = new CallbackExt(Chromium.class, "do_close", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE});
        Chromium.lifeSpanHandler.do_close = Chromium.checkGetAddress(Chromium.lifeSpanHandler.do_close_cb);
        Chromium.lifeSpanHandler.on_after_created_cb = new CallbackExt(Chromium.class, "on_after_created", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
        Chromium.lifeSpanHandler.on_after_created = Chromium.checkGetAddress(Chromium.lifeSpanHandler.on_after_created_cb);
        Chromium.lifeSpanHandler.on_before_popup_cb = new CallbackExt(Chromium.class, "on_before_popup", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE});
        Chromium.lifeSpanHandler.on_before_popup = Chromium.checkGetAddress(Chromium.lifeSpanHandler.on_before_popup_cb);
        Chromium.clientHandler.get_life_span_handler_cb = new CallbackExt(Chromium.class, "get_life_span_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_life_span_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_life_span_handler_cb);
        Chromium.lifeSpanHandler.ptr = C.malloc((long)cef_life_span_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.lifeSpanHandler.ptr, lifeSpanHandler, cef_life_span_handler_t.sizeof);
    }

    static long get_life_span_handler(long client) {
        if (lifeSpanHandler == null) {
            return 0L;
        }
        return Chromium.lifeSpanHandler.ptr;
    }

    static void on_before_close(long plifeSpanHandler, long browser) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("OnBeforeClose: " + id);
        instances.remove(id).on_before_close(browser);
        int decrementAndGet = browsers.decrementAndGet();
        --disposingAny;
        if (decrementAndGet == 0 && shuttindDown) {
            Chromium.internalShutdown();
        }
        ChromiumLib.cefswt_ref(browser, 0);
    }

    private void on_before_close(long browser) {
        if (this.disposing != Dispose.FromBrowser) {
            this.fireCloseListener();
        }
        this.browser = 0L;
        this.chromium = null;
        this.debugPrint("closed");
    }

    private void fireCloseListener() {
        if (this.chromium != null && this.closeWindowListeners != null) {
            Display display = Display.getDefault();
            org.eclipse.swt.browser.WindowEvent event = new org.eclipse.swt.browser.WindowEvent((Widget)this.chromium);
            event.display = display;
            event.widget = this.chromium;
            CloseWindowListener[] closeWindowListenerArray = this.closeWindowListeners;
            int n = this.closeWindowListeners.length;
            int n2 = 0;
            while (n2 < n) {
                CloseWindowListener listener = closeWindowListenerArray[n2];
                listener.close(event);
                ++n2;
            }
        }
    }

    private static synchronized void freeAll(Display display) {
        if (!instances.isEmpty()) {
            System.err.println("freeing all handlers, but there are instances");
        }
        if (clientHandler != null) {
            C.free((long)Chromium.clientHandler.ptr);
            Chromium.disposeCallback(Chromium.clientHandler.get_context_menu_handler_cb);
            Chromium.disposeCallback(Chromium.clientHandler.get_display_handler_cb);
            Chromium.disposeCallback(Chromium.clientHandler.get_focus_handler_cb);
            Chromium.disposeCallback(Chromium.clientHandler.get_jsdialog_handler_cb);
            CallbackExt get_life_span_handler_cb = Chromium.clientHandler.get_life_span_handler_cb;
            CallbackExt get_request_handler_cb = Chromium.clientHandler.get_request_handler_cb;
            Chromium.disposeCallback(get_life_span_handler_cb);
            Chromium.disposeCallback(get_request_handler_cb);
            Chromium.disposeCallback(Chromium.clientHandler.get_load_handler_cb);
            Chromium.disposeCallback(Chromium.clientHandler.on_process_message_received_cb);
            clientHandler = null;
        }
        if (focusHandler != null) {
            C.free((long)Chromium.focusHandler.ptr);
            Chromium.disposeCallback(Chromium.focusHandler.on_got_focus_cb);
            Chromium.disposeCallback(Chromium.focusHandler.on_set_focus_cb);
            Chromium.disposeCallback(Chromium.focusHandler.on_take_focus_cb);
            focusHandler = null;
        }
        if (keyboardHandler != null) {
            C.free((long)Chromium.keyboardHandler.ptr);
            Chromium.disposeCallback(Chromium.keyboardHandler.on_key_event_cb);
            keyboardHandler = null;
        }
        if (lifeSpanHandler != null) {
            Chromium.disposeCallback(Chromium.lifeSpanHandler.do_close_cb);
            Chromium.disposeCallback(Chromium.lifeSpanHandler.on_after_created_cb);
            Chromium.disposeCallback(Chromium.lifeSpanHandler.on_before_close_cb);
            Chromium.disposeCallback(Chromium.lifeSpanHandler.on_before_popup_cb);
            C.free((long)Chromium.lifeSpanHandler.ptr);
            lifeSpanHandler = null;
        }
        if (loadHandler != null) {
            Chromium.disposeCallback(Chromium.loadHandler.on_loading_state_change_cb);
            C.free((long)Chromium.loadHandler.ptr);
            loadHandler = null;
        }
        if (displayHandler != null) {
            Chromium.disposeCallback(Chromium.displayHandler.on_address_change_cb);
            Chromium.disposeCallback(Chromium.displayHandler.on_status_message_cb);
            Chromium.disposeCallback(Chromium.displayHandler.on_title_change_cb);
            C.free((long)Chromium.displayHandler.ptr);
            displayHandler = null;
        }
        if (requestHandler != null) {
            Chromium.disposeCallback(Chromium.requestHandler.on_before_browse_cb);
            Chromium.disposeCallback(Chromium.requestHandler.get_auth_credentials_cb);
            C.free((long)Chromium.requestHandler.ptr);
            requestHandler = null;
        }
        if (jsDialogHandler != null) {
            Chromium.disposeCallback(Chromium.jsDialogHandler.on_jsdialog_cb);
            Chromium.disposeCallback(Chromium.jsDialogHandler.on_dialog_closed_cb);
            Chromium.disposeCallback(Chromium.jsDialogHandler.on_before_unload_dialog_cb);
            C.free((long)Chromium.jsDialogHandler.ptr);
            jsDialogHandler = null;
        }
        if (contextMenuHandler != null) {
            Chromium.disposeCallback(Chromium.contextMenuHandler.run_context_menu_cb);
            C.free((long)Chromium.contextMenuHandler.ptr);
            contextMenuHandler = null;
        }
        if (downloadHandler != null) {
            Chromium.disposeCallback(Chromium.downloadHandler.on_before_download_cb);
            Chromium.disposeCallback(Chromium.downloadHandler.on_download_updated_cb);
            C.free((long)Chromium.downloadHandler.ptr);
            downloadHandler = null;
        }
        if (popupClientHandler != null) {
            Chromium.disposeCallback(Chromium.popupClientHandler.get_life_span_handler_cb);
            C.free((long)Chromium.popupClientHandler.ptr);
            popupClientHandler = null;
        }
        Chromium.debug("all dipsosed");
    }

    static int do_close(long plifeSpanHandler, long browser) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("DoClose: " + id);
        int r = Chromium.safeGeInstance(id).do_close(browser);
        ChromiumLib.cefswt_ref(browser, 0);
        return r;
    }

    private int do_close(long browser) {
        if (!ChromiumLib.cefswt_is_same(this.browser, browser)) {
            this.debugPrint("DoClose popup:" + this.browser + ":" + browser);
            return 0;
        }
        if (this.disposing == Dispose.FromClose || this.disposing == Dispose.Unload || this.disposing == Dispose.UnloadClosed || this.disposing == Dispose.WaitIfClosed) {
            this.disposing = Dispose.DoIt;
        } else if (this.disposing == Dispose.No && this.chromium != null) {
            this.disposing = Dispose.FromBrowser;
            this.fireCloseListener();
            this.chromium.dispose();
        }
        this.debugPrint("AFTER DoClose");
        return 1;
    }

    static void on_after_created(long self, long browser) {
        Chromium c;
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_after_created: " + id);
        if (browser != 0L) {
            browsers.incrementAndGet();
        }
        if ((c = instancesNew.poll()) == null) {
            throw new SWTError("Wrong chromium id on_after_created" + id);
        }
        if (!instancesNew.isEmpty()) {
            System.err.println("Chromium pending new instances");
        }
        instances.put(id, c);
        c.instance = id;
        Chromium.safeGeInstance(id).on_after_created(browser);
        ChromiumLib.cefswt_ref(browser, 0);
    }

    private void on_after_created(long browser) {
        if (this.isDisposed() || this.visibilityWindowListeners == null) {
            return;
        }
        this.debugPrint("on_after_created: " + browser);
        if (browser != 0L) {
            ChromiumLib.cefswt_ref(browser, 1);
            this.browser = browser;
            if (this.isPopup == null) {
                Point size = this.getChromiumSize(false);
                ChromiumLib.cefswt_resized(browser, size.x, size.y);
            }
            if (this.isPopup != null && this.url != null) {
                this.debugPrint("load url after created");
                Chromium.doSetUrlPost(browser, this.url, this.postData, this.headers);
            } else if (!"about:blank".equals(this.url)) {
                this.enableProgress.complete(true);
            }
        }
        this.created.complete(true);
        if (browsers.get() == 1) {
            this.debugPrint("STARTING MSG LOOP");
            Display display = this.chromium.getDisplay();
            Chromium.doMessageLoop(display);
        }
        this.debugPrint("on_after_created handling " + browser);
        if (this.isDisposed() || this.visibilityWindowListeners == null) {
            return;
        }
        org.eclipse.swt.browser.WindowEvent event = new org.eclipse.swt.browser.WindowEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.size = new Point(0, 0);
        event.location = new Point(0, 0);
        if (this.isPopup != null) {
            event.size = this.isPopup.size;
            event.location = this.isPopup.location;
            event.addressBar = this.isPopup.addressBar;
            event.menuBar = this.isPopup.menuBar;
            event.statusBar = this.isPopup.statusBar;
            event.toolBar = this.isPopup.toolBar;
            if (event.size != null && !event.size.equals((Object)new Point(0, 0))) {
                Point size = event.size;
                this.chromium.getShell().setSize(this.chromium.getShell().computeSize(size.x, size.y));
            }
            VisibilityWindowListener[] visibilityWindowListenerArray = this.visibilityWindowListeners;
            int n = this.visibilityWindowListeners.length;
            int n2 = 0;
            while (n2 < n) {
                VisibilityWindowListener listener = visibilityWindowListenerArray[n2];
                listener.show(event);
                ++n2;
            }
        }
        try {
            Thread.sleep(33L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static int on_before_popup(long self, long browser, long frame, long target_url, long target_frame_name, int target_disposition, int user_gesture, long popupFeaturesPtr, long windowInfo, long client, long settings, long no_javascript_access) {
        loopDisable = true;
        pumpDisable = true;
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_before_popup: " + id);
        int ret = Chromium.safeGeInstance(id).on_before_popup(browser, target_url, popupFeaturesPtr, windowInfo, client);
        loopDisable = false;
        ChromiumLib.cefswt_ref(browser, 0);
        ChromiumLib.cefswt_ref(frame, 0);
        return ret;
    }

    private int on_before_popup(long browser, long target_url, long popupFeaturesPtr, long windowInfo, long client) {
        if (this.isDisposed()) {
            return 1;
        }
        if (this.openWindowListeners == null) {
            return 0;
        }
        WindowEvent event = new WindowEvent((Widget)this.chromium);
        String toUrl = target_url != 0L ? ChromiumLib.cefswt_cefstring_to_java(target_url) : null;
        event.data = toUrl;
        cef_popup_features_t popupFeatures = new cef_popup_features_t();
        ChromiumLib.memmove(popupFeatures, popupFeaturesPtr, ChromiumLib.cef_popup_features_t_sizeof());
        try {
            Thread.sleep(33L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.chromium.getDisplay().syncExec(() -> {
            this.debugPrint("on_before_popup syncExec" + browser);
            windowEvent.display = this.chromium.getDisplay();
            windowEvent.widget = this.chromium;
            windowEvent.required = false;
            windowEvent.addressBar = cef_popup_features_t2.toolBarVisible == 1;
            windowEvent.menuBar = cef_popup_features_t2.menuBarVisible == 1;
            windowEvent.statusBar = cef_popup_features_t2.statusBarVisible == 1;
            windowEvent.toolBar = cef_popup_features_t2.toolBarVisible == 1;
            int x = cef_popup_features_t2.xSet == 1 ? cef_popup_features_t2.x : 0;
            int y = cef_popup_features_t2.ySet == 1 ? cef_popup_features_t2.y : 0;
            windowEvent.location = cef_popup_features_t2.xSet == 1 || cef_popup_features_t2.ySet == 1 ? new Point(x, y) : null;
            int width = cef_popup_features_t2.widthSet == 1 ? cef_popup_features_t2.width : 0;
            int height = cef_popup_features_t2.heightSet == 1 ? cef_popup_features_t2.height : 0;
            windowEvent.size = cef_popup_features_t2.widthSet == 1 || cef_popup_features_t2.heightSet == 1 ? new Point(width, height) : null;
            OpenWindowListener[] openWindowListenerArray = this.openWindowListeners;
            int n = this.openWindowListeners.length;
            int n2 = 0;
            while (n2 < n) {
                OpenWindowListener listener = openWindowListenerArray[n2];
                listener.open(event);
                ++n2;
            }
            if (windowEvent.browser != null) {
                if (((Chromium)windowEvent.browser.webBrowser).instance == 0) {
                    ((Chromium)windowEvent.browser.webBrowser).createPopup(windowInfo, client, event);
                } else if (windowEvent.browser == this.chromium) {
                    if (toUrl != null) {
                        this.setUrl(toUrl, null, null);
                    }
                    windowEvent.required = true;
                } else {
                    windowEvent.required = true;
                }
            } else if (!windowEvent.required) {
                this.createDefaultPopup(windowInfo, client, event);
            }
        });
        if (event.browser == null && event.required) {
            return 1;
        }
        if (event.browser != null && event.required) {
            return 1;
        }
        return 0;
    }

    private void waitForClose(Display display, int step) {
        System.out.println("Chromium.waitForClose() " + step);
        if (display == null || display.isDisposed() || step > 1000) {
            return;
        }
        int s = step + 1;
        display.asyncExec(() -> {
            if (this.browser != 0L) {
                this.waitForClose(display, s);
            }
        });
    }

    private static void set_load_handler() {
        loadHandler = CEFFactory.newLoadHandler();
        Chromium.loadHandler.on_loading_state_change_cb = new CallbackExt(Chromium.class, "on_loading_state_change", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        Chromium.loadHandler.on_loading_state_change = Chromium.checkGetAddress(Chromium.loadHandler.on_loading_state_change_cb);
        Chromium.clientHandler.get_load_handler_cb = new CallbackExt(Chromium.class, "get_load_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_load_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_load_handler_cb);
        Chromium.loadHandler.ptr = C.malloc((long)cef_load_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.loadHandler.ptr, loadHandler, cef_load_handler_t.sizeof);
    }

    static long get_load_handler(long client) {
        if (loadHandler == null) {
            return 0L;
        }
        return Chromium.loadHandler.ptr;
    }

    static void on_loading_state_change(long self_, long browser, int isLoading, int canGoBack, int canGoForward) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_loading_state_change: " + id);
        Chromium.safeGeInstance(id).on_loading_state_change(browser, isLoading, canGoBack, canGoForward);
        ChromiumLib.cefswt_ref(browser, 0);
    }

    private void on_loading_state_change(long browser, int isLoading, int canGoBack, int canGoForward) {
        this.canGoBack = canGoBack == 1;
        boolean bl = this.canGoForward = canGoForward == 1;
        if (this.isDisposed() || this.progressListeners == null) {
            return;
        }
        if (isLoading == 0) {
            for (BrowserFunction function : this.functions.values()) {
                if (function.index == 0 || ChromiumLib.cefswt_function(browser, function.name, function.index)) continue;
                throw new SWTException("Cannot create BrowserFunction");
            }
        }
        if (this.isPopup != null) {
            this.enableProgress.complete(true);
        } else {
            if (!this.enableProgress.isDone() && isLoading == 0) {
                this.enableProgress.complete(true);
                return;
            }
            if (!this.enableProgress.isDone()) {
                return;
            }
        }
        ProgressEvent event = new ProgressEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.current = 100;
        event.current = isLoading == 1 ? 1 : 100;
        event.total = 100;
        if (isLoading == 1) {
            this.debugPrint("progress changed");
            ProgressListener[] progressListenerArray = this.progressListeners;
            int n = this.progressListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ProgressListener listener = progressListenerArray[n2];
                listener.changed(event);
                ++n2;
            }
        } else if (this.loadingPage) {
            this.loadingPage = false;
            this.debugPrint("progress completed");
            this.chromium.getDisplay().asyncExec(() -> {
                if (this.isDisposed()) {
                    return;
                }
                ProgressListener[] progressListenerArray = this.progressListeners;
                int n = this.progressListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    ProgressListener listener = progressListenerArray[n2];
                    listener.completed(event);
                    ++n2;
                }
            });
        }
    }

    private static void set_display_handler() {
        displayHandler = CEFFactory.newDisplayHandler();
        Chromium.displayHandler.on_title_change_cb = new CallbackExt(Chromium.class, "on_title_change", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
        Chromium.displayHandler.on_title_change = Chromium.checkGetAddress(Chromium.displayHandler.on_title_change_cb);
        Chromium.displayHandler.on_address_change_cb = new CallbackExt(Chromium.class, "on_address_change", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE});
        Chromium.displayHandler.on_address_change = Chromium.checkGetAddress(Chromium.displayHandler.on_address_change_cb);
        Chromium.displayHandler.on_status_message_cb = new CallbackExt(Chromium.class, "on_status_message", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
        Chromium.displayHandler.on_status_message = Chromium.checkGetAddress(Chromium.displayHandler.on_status_message_cb);
        Chromium.clientHandler.get_display_handler_cb = new CallbackExt(Chromium.class, "get_display_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_display_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_display_handler_cb);
        Chromium.displayHandler.ptr = C.malloc((long)cef_display_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.displayHandler.ptr, displayHandler, cef_display_handler_t.sizeof);
    }

    static long get_display_handler(long client) {
        if (displayHandler == null) {
            return 0L;
        }
        return Chromium.displayHandler.ptr;
    }

    static void on_title_change(long self, long browser, long title) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_title_change: " + id);
        Chromium.safeGeInstance(id).on_title_change(browser, title);
        ChromiumLib.cefswt_ref(browser, 0);
    }

    private void on_title_change(long browser, long title) {
        if (this.isDisposed() || this.titleListeners == null) {
            return;
        }
        String full_str = ChromiumLib.cefswt_cefstring_to_java(title);
        String str = Chromium.getPlainUrl(full_str);
        TitleEvent event = new TitleEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.title = str;
        this.title = str != null ? str : "";
        TitleListener[] titleListenerArray = this.titleListeners;
        int n = this.titleListeners.length;
        int n2 = 0;
        while (n2 < n) {
            TitleListener listener = titleListenerArray[n2];
            listener.changed(event);
            ++n2;
        }
    }

    static void on_address_change(long self, long browser, long frame, long url) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_address_change: " + id);
        Chromium.safeGeInstance(id).on_address_change(browser, frame, url);
        ChromiumLib.cefswt_ref(browser, 0);
        ChromiumLib.cefswt_ref(frame, 0);
    }

    private void on_address_change(long browser, long frame, long url) {
        if (this.isDisposed() || this.locationListeners == null) {
            return;
        }
        LocationEvent event = new LocationEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.doit = true;
        event.location = Chromium.getPlainUrl(ChromiumLib.cefswt_cefstring_to_java(url));
        event.top = ChromiumLib.cefswt_is_main_frame(frame);
        if (!this.enableProgress.isDone()) {
            this.debugPrint("!on_address_change to " + event.location + " " + (event.top ? "main" : "!main"));
            return;
        }
        this.debugPrint("on_address_change to " + event.location + " " + (event.top ? "main" : "!main"));
        this.chromium.getDisplay().asyncExec(() -> {
            LocationListener[] locationListenerArray = this.locationListeners;
            int n = this.locationListeners.length;
            int n2 = 0;
            while (n2 < n) {
                LocationListener listener = locationListenerArray[n2];
                listener.changed(event);
                ++n2;
            }
        });
    }

    static void on_status_message(long self, long browser, long status) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.safeGeInstance(id).on_status_message(browser, status);
        ChromiumLib.cefswt_ref(browser, 0);
    }

    private void on_status_message(long browser, long status) {
        if (this.isDisposed() || this.statusTextListeners == null) {
            return;
        }
        String str = status == 0L ? "" : ChromiumLib.cefswt_cefstring_to_java(status);
        StatusTextEvent event = new StatusTextEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.text = str;
        StatusTextListener[] statusTextListenerArray = this.statusTextListeners;
        int n = this.statusTextListeners.length;
        int n2 = 0;
        while (n2 < n) {
            StatusTextListener listener = statusTextListenerArray[n2];
            listener.changed(event);
            ++n2;
        }
    }

    private static void set_request_handler() {
        requestHandler = CEFFactory.newRequestHandler();
        Chromium.requestHandler.on_before_browse_cb = new CallbackExt(Chromium.class, "on_before_browse", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE});
        Chromium.requestHandler.on_before_browse = Chromium.checkGetAddress(Chromium.requestHandler.on_before_browse_cb);
        Chromium.requestHandler.get_auth_credentials_cb = new CallbackExt(Chromium.class, "get_auth_credentials", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Long.TYPE});
        Chromium.requestHandler.get_auth_credentials = Chromium.checkGetAddress(Chromium.requestHandler.get_auth_credentials_cb);
        Chromium.clientHandler.get_request_handler_cb = new CallbackExt(Chromium.class, "get_request_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_request_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_request_handler_cb);
        Chromium.requestHandler.ptr = C.malloc((long)cef_request_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.requestHandler.ptr, requestHandler, cef_request_handler_t.sizeof);
    }

    static long get_request_handler(long client) {
        if (requestHandler == null) {
            return 0L;
        }
        return Chromium.requestHandler.ptr;
    }

    static int on_before_browse(long self, long browser, long frame, long request, int user_gesture, int is_redirect) {
        int id = ChromiumLib.cefswt_get_id(browser);
        int r = Chromium.safeGeInstance(id).on_before_browse(browser, frame, request);
        ChromiumLib.cefswt_ref(browser, 0);
        ChromiumLib.cefswt_ref(frame, 0);
        ChromiumLib.cefswt_ref(request, 0);
        return r;
    }

    private int on_before_browse(long browser2, long frame, long request) {
        if (this.isDisposed() || this.locationListeners == null) {
            return 0;
        }
        LocationEvent event = new LocationEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.doit = true;
        event.top = ChromiumLib.cefswt_is_main_frame(frame);
        event.location = Chromium.getPlainUrl(ChromiumLib.cefswt_request_to_java(request));
        this.debugPrint("on_before_browse:" + event.location + " top:" + event.top);
        try {
            loopDisable = true;
            LocationListener[] locationListenerArray = this.locationListeners;
            int n = this.locationListeners.length;
            int n2 = 0;
            while (n2 < n) {
                LocationListener listener = locationListenerArray[n2];
                listener.changing(event);
                ++n2;
            }
        }
        finally {
            loopDisable = false;
        }
        if (!event.doit) {
            this.debugPrint("canceled nav, dependats:" + this.enableProgress.getNumberOfDependents());
            this.enableProgress = new CompletableFuture();
        } else {
            this.loadingPage = true;
        }
        return event.doit ? 0 : 1;
    }

    static int get_auth_credentials(long self, long browser, long origin_url, int isProxy, long host, int port, long realm, long scheme, long callback) {
        int id = ChromiumLib.cefswt_get_id(browser);
        int r = Chromium.safeGeInstance(id).get_auth_credentials(browser, origin_url, host, port, realm, callback);
        ChromiumLib.cefswt_ref(browser, 0);
        ChromiumLib.cefswt_ref(callback, 0);
        return r;
    }

    private int get_auth_credentials(long browser2, long origin_url, long host, int port, long realm, long callback) {
        if (this.isDisposed()) {
            return 0;
        }
        AuthenticationEvent event = new AuthenticationEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.doit = true;
        String protocol = "http";
        try {
            URL u = new URL(this.url);
            protocol = u.getProtocol();
        }
        catch (MalformedURLException u) {
            // empty catch block
        }
        String hostStr = host != 0L ? ChromiumLib.cefswt_cefstring_to_java(host) : "";
        String realmStr = realm != 0L ? ChromiumLib.cefswt_cefstring_to_java(realm) : null;
        event.location = String.valueOf(protocol) + "://" + hostStr;
        this.debugPrint("get_auth_credentials:" + event.location);
        this.chromium.getDisplay().syncExec(() -> {
            AuthenticationListener[] authenticationListenerArray = this.authenticationListeners;
            int n = this.authenticationListeners.length;
            int n2 = 0;
            while (n2 < n) {
                AuthenticationListener listener = authenticationListenerArray[n2];
                listener.authenticate(event);
                ++n2;
            }
            if (authenticationEvent.doit && authenticationEvent.user == null && authenticationEvent.password == null) {
                new AuthDialog(this.chromium.getShell()).open(event, realmStr);
            }
        });
        ChromiumLib.cefswt_auth_callback(callback, event.user, event.password, event.doit ? 1 : 0);
        return event.doit ? 1 : 0;
    }

    private static void set_jsdialog_handler() {
        jsDialogHandler = CEFFactory.newJsDialogHandler();
        if (Chromium.useSwtDialogs()) {
            Chromium.jsDialogHandler.on_jsdialog_cb = new CallbackExt(Chromium.class, "on_jsdialog", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE});
            Chromium.jsDialogHandler.on_jsdialog = Chromium.checkGetAddress(Chromium.jsDialogHandler.on_jsdialog_cb);
        }
        Chromium.jsDialogHandler.on_dialog_closed_cb = new CallbackExt(Chromium.class, "on_dialog_closed", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
        Chromium.jsDialogHandler.on_dialog_closed = Chromium.checkGetAddress(Chromium.jsDialogHandler.on_dialog_closed_cb);
        Chromium.jsDialogHandler.on_before_unload_dialog_cb = new CallbackExt(Chromium.class, "on_before_unload_dialog", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE});
        Chromium.jsDialogHandler.on_before_unload_dialog = Chromium.checkGetAddress(Chromium.jsDialogHandler.on_before_unload_dialog_cb);
        Chromium.clientHandler.get_jsdialog_handler_cb = new CallbackExt(Chromium.class, "get_jsdialog_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_jsdialog_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_jsdialog_handler_cb);
        Chromium.jsDialogHandler.ptr = C.malloc((long)cef_jsdialog_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.jsDialogHandler.ptr, jsDialogHandler, cef_jsdialog_handler_t.sizeof);
    }

    static long get_jsdialog_handler(long client) {
        if (jsDialogHandler == null) {
            return 0L;
        }
        return Chromium.jsDialogHandler.ptr;
    }

    static int on_jsdialog(long self_, long browser, long origin_url, int dialog_type, long message_text, long default_prompt_text, long callback, int suppress_message) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_jsdialog: " + id);
        int r = Chromium.safeGeInstance(id).on_jsdialog(browser, origin_url, dialog_type, message_text, default_prompt_text, callback);
        ChromiumLib.cefswt_ref(browser, 0);
        return r;
    }

    private int on_jsdialog(long browser, long origin_url, int dialog_type, long message_text, long default_prompt_text, long callback) {
        String use;
        if (this.isDisposed()) {
            return 0;
        }
        String prompt = default_prompt_text != 0L ? ChromiumLib.cefswt_cefstring_to_java(default_prompt_text) : null;
        String url = ChromiumLib.cefswt_cefstring_to_java(origin_url);
        String title = Chromium.getPlainUrl(url);
        switch (use = System.getProperty("swt.chromium.dialogs", "swt")) {
            case "swt-host": {
                try {
                    title = new URL(Chromium.getPlainUrl(url)).getHost();
                }
                catch (MalformedURLException e) {
                    title = "";
                }
                break;
            }
            case "swt-empty": {
                title = "";
                break;
            }
            case "swt-title": {
                title = this.title;
            }
        }
        String msg = ChromiumLib.cefswt_cefstring_to_java(message_text);
        this.openJsDialog(dialog_type, title, msg, prompt, default_prompt_text, callback);
        return 1;
    }

    private void openJsDialog(int dialog_type, String title, String msg, String prompt, long default_prompt_text, long callback) {
        int style = 16;
        switch (dialog_type) {
            case 0: {
                style = 2;
                break;
            }
            case 1: {
                style = 296;
                break;
            }
            case 2: {
                style = 292;
            }
        }
        Consumer<Integer> close = open -> {
            int r = open == 32 || open == 64 ? 1 : 0;
            Chromium.debug("JS Dialog Closed with " + r);
            if (this.disposing == Dispose.Unload && r == 0) {
                this.disposing = Dispose.UnloadCancel;
            }
            this.chromium.getDisplay().asyncExec(() -> {
                ChromiumLib.cefswt_dialog_close(callback, r, 0L);
                ChromiumLib.cefswt_ref(callback, 0);
            });
            this.chromium.getShell().forceActive();
        };
        if (!"test".equals(System.getProperty("swt.chromium.dialogs", ""))) {
            MessageBox box = new MessageBox(this.chromium.getShell(), style);
            box.setText(title);
            box.setMessage(prompt != null ? String.valueOf(msg) + "\n\n" + prompt : msg);
            int open2 = box.open();
            close.accept(open2);
        } else {
            CompletableFuture f = (CompletableFuture)this.chromium.getData("swt.chromium.dialogs");
            if (f != null) {
                f.thenAccept(close);
                this.chromium.setData("swt.chromium.dialogs", null);
                while (!f.isDone()) {
                    if (this.chromium.getDisplay().readAndDispatch()) continue;
                    this.chromium.getDisplay().sleep();
                }
            }
        }
    }

    static void on_dialog_closed(long self_, long browser) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.safeGeInstance(id).on_dialog_closed(browser);
        ChromiumLib.cefswt_ref(browser, 0);
    }

    private void on_dialog_closed(long browser) {
        Chromium.debug("on_dialog_closed_cb disposing: " + (Object)((Object)this.disposing));
        if (this.disposing == Dispose.Unload) {
            this.disposing = Dispose.UnloadClosed;
        }
    }

    static int on_before_unload_dialog(long self_, long browser, long msg, int is_reload, long callback) {
        int id = ChromiumLib.cefswt_get_id(browser);
        int r = Chromium.safeGeInstance(id).on_before_unload_dialog(browser, msg, is_reload, callback);
        ChromiumLib.cefswt_ref(browser, 0);
        return r;
    }

    private int on_before_unload_dialog(long browser, long message_text, int is_reload, long callback) {
        Chromium.debug("on_before_unload_dialog disposing: " + (Object)((Object)this.disposing));
        if (this.disposing == Dispose.FromClose) {
            this.disposing = Dispose.Unload;
        }
        if (Chromium.useSwtDialogs()) {
            String msg = ChromiumLib.cefswt_cefstring_to_java(message_text);
            this.openJsDialog(1, "Are you sure you want to leave this page?", msg, null, 0L, callback);
            if (this.disposing == Dispose.Unload) {
                this.disposing = Dispose.UnloadClosed;
            }
            return 1;
        }
        ChromiumLib.cefswt_ref(callback, 0);
        return 0;
    }

    private static boolean useSwtDialogs() {
        return "gtk".equals(SWT.getPlatform()) || !"native".equals(System.getProperty("swt.chromium.dialogs", "swt"));
    }

    private static void set_context_menu_handler() {
        contextMenuHandler = CEFFactory.newContextMenuHandler();
        Chromium.contextMenuHandler.run_context_menu_cb = new CallbackExt(Chromium.class, "run_context_menu", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE});
        Chromium.contextMenuHandler.run_context_menu = Chromium.checkGetAddress(Chromium.contextMenuHandler.run_context_menu_cb);
        Chromium.clientHandler.get_context_menu_handler_cb = new CallbackExt(Chromium.class, "get_context_menu_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_context_menu_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_context_menu_handler_cb);
        Chromium.contextMenuHandler.ptr = C.malloc((long)cef_context_menu_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.contextMenuHandler.ptr, contextMenuHandler, cef_context_menu_handler_t.sizeof);
    }

    static long get_context_menu_handler(long client) {
        if (contextMenuHandler == null) {
            return 0L;
        }
        return Chromium.contextMenuHandler.ptr;
    }

    static int run_context_menu(long self, long browser, long frame, long params, long model, long callback) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("run_context_menu: " + id);
        int r = Chromium.safeGeInstance(id).run_context_menu(browser, callback);
        ChromiumLib.cefswt_ref(browser, 0);
        ChromiumLib.cefswt_ref(frame, 0);
        ChromiumLib.cefswt_ref(params, 0);
        ChromiumLib.cefswt_ref(model, 0);
        ChromiumLib.cefswt_ref(callback, 0);
        return r;
    }

    private int run_context_menu(long browser2, long callback) {
        if (this.chromium.getMenu() != null) {
            this.chromium.getMenu().setVisible(true);
            ChromiumLib.cefswt_context_menu_cancel(callback);
            return 1;
        }
        return 0;
    }

    private static void set_download_handler() {
        downloadHandler = CEFFactory.newDownloadHandler();
        Chromium.downloadHandler.on_before_download_cb = new CallbackExt(Chromium.class, "on_before_download", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE});
        Chromium.downloadHandler.on_before_download = Chromium.checkGetAddress(Chromium.downloadHandler.on_before_download_cb);
        Chromium.downloadHandler.on_download_updated_cb = new CallbackExt(Chromium.class, "on_download_updated", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE});
        Chromium.downloadHandler.on_download_updated = Chromium.checkGetAddress(Chromium.downloadHandler.on_download_updated_cb);
        Chromium.clientHandler.get_download_handler_cb = new CallbackExt(Chromium.class, "get_download_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_download_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_download_handler_cb);
        Chromium.downloadHandler.ptr = C.malloc((long)cef_download_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.downloadHandler.ptr, downloadHandler, cef_download_handler_t.sizeof);
    }

    static long get_download_handler(long client) {
        if (downloadHandler == null) {
            return 0L;
        }
        return Chromium.downloadHandler.ptr;
    }

    static void on_before_download(long self, long browser, long download_item, long suggested_name, long callback) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_before_download: " + id);
        Chromium.safeGeInstance(id).on_before_download(browser, download_item, suggested_name, callback);
        ChromiumLib.cefswt_ref(browser, 0);
        ChromiumLib.cefswt_ref(download_item, 0);
        ChromiumLib.cefswt_ref(callback, 0);
    }

    private void on_before_download(long browser, long download_item, long suggested_name, long callback) {
        DownloadItem item = new DownloadItem();
        String name = null;
        if (suggested_name != 0L) {
            name = ChromiumLib.cefswt_cefstring_to_java(suggested_name);
        }
        if ("gtk".equals(SWT.getPlatform())) {
            String selected;
            FileDialog dlg = new FileDialog(this.chromium.getShell(), 8192);
            dlg.setText("Save File");
            dlg.setOverwrite(true);
            if (name != null && !name.isEmpty()) {
                dlg.setFileName(name);
            }
            if ((selected = dlg.open()) != null) {
                ChromiumLib.cefswt_download_item(download_item, item);
                if (item.status != -1) {
                    new Download(item, selected, this);
                }
                ChromiumLib.cefswt_download_item(0L, item);
                ChromiumLib.cefswt_download_callback(callback, selected, 1);
            }
        } else {
            ChromiumLib.cefswt_download_item(download_item, item);
            if (item.status != -1) {
                new Download(item, name, this);
            }
            ChromiumLib.cefswt_download_callback(callback, null, 1);
        }
    }

    static void on_download_updated(long self, long browser, long download_item, long callback) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.safeGeInstance(id).on_download_updated(browser, download_item, callback);
        ChromiumLib.cefswt_ref(browser, 0);
        ChromiumLib.cefswt_ref(download_item, 0);
    }

    private void on_download_updated(long browser, long download_item, long callback) {
        Download download;
        DownloadItem item = new DownloadItem();
        ChromiumLib.cefswt_download_item(download_item, item);
        if (item.status != -1 && (download = Download.downloads.get(item.id)) != null) {
            download.update(item, callback);
            if (!download.open) {
                download.show();
            }
        }
        ChromiumLib.cefswt_download_item(0L, item);
    }

    private cef_string_visitor_t set_text_visitor() {
        cef_string_visitor_t textVisitor = CEFFactory.newStringVisitor();
        textVisitor.visit_cb = new CallbackExt((Object)this, "textVisitor_visit", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
        textVisitor.visit = Chromium.checkGetAddress(textVisitor.visit_cb);
        textVisitor.ptr = C.malloc((long)cef_string_visitor_t.sizeof);
        textVisitor.refs = 1;
        ChromiumLib.memmove(textVisitor.ptr, textVisitor, cef_string_visitor_t.sizeof);
        return textVisitor;
    }

    void textVisitor_visit(long self, long cefString) {
        String newtext;
        String string = newtext = cefString != 0L ? ChromiumLib.cefswt_cefstring_to_java(cefString) : null;
        if (newtext != null) {
            this.debugPrint("text visited completed");
            this.textVisited.complete(newtext);
        } else {
            this.textVisited.complete("");
            this.debugPrint("text visited null");
        }
    }

    private static void set_keyboard_handler() {
        keyboardHandler = CEFFactory.newKeyboardHandler();
        Chromium.keyboardHandler.on_key_event_cb = new CallbackExt(Chromium.class, "on_key_event", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE});
        Chromium.keyboardHandler.on_key_event = Chromium.checkGetAddress(Chromium.keyboardHandler.on_key_event_cb);
        Chromium.clientHandler.get_keyboard_handler_cb = new CallbackExt(Chromium.class, "get_keyboard_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_keyboard_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_keyboard_handler_cb);
        Chromium.keyboardHandler.ptr = C.malloc((long)cef_keyboard_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.keyboardHandler.ptr, keyboardHandler, cef_keyboard_handler_t.sizeof);
    }

    static long get_keyboard_handler(long client) {
        if (keyboardHandler == null) {
            return 0L;
        }
        return Chromium.keyboardHandler.ptr;
    }

    static int on_key_event(long keyboardHandler, long browser, long event, long os_event) {
        int id = ChromiumLib.cefswt_get_id(browser);
        int r = Chromium.safeGeInstance(id).on_key_event(browser, event, os_event);
        ChromiumLib.cefswt_ref(browser, 0);
        return r;
    }

    private int on_key_event(long browser, long event, long os_event) {
        if (this.isDisposed()) {
            return 0;
        }
        cef_key_event_t e = new cef_key_event_t();
        ChromiumLib.memmove(e, event, ChromiumLib.cef_key_event_t_sizeof());
        Event firedEvent = new Event();
        if (e.type == 0 || e.type == 1) {
            firedEvent.type = 1;
        } else if (e.type == 2) {
            firedEvent.type = 2;
        } else {
            return 0;
        }
        int translateKey = e.windows_key_code == 91 || e.windows_key_code == 93 ? 0x400000 : this.translateKey(e.windows_key_code);
        firedEvent.keyCode = translateKey != 0 ? translateKey : e.windows_key_code;
        firedEvent.widget = this.chromium;
        firedEvent.character = e.character;
        firedEvent.display = this.chromium.getDisplay();
        int stateMask = 0;
        if (cef_event_flags.CAPS_LOCK_ON.shouldSetState(e.modifiers, firedEvent)) {
            stateMask += 16777298;
        }
        if (cef_event_flags.SHIFT_DOWN.shouldSetState(e.modifiers, firedEvent)) {
            stateMask += 131072;
        }
        if (cef_event_flags.CONTROL_DOWN.shouldSetState(e.modifiers, firedEvent)) {
            stateMask += 262144;
        }
        if (cef_event_flags.ALT_DOWN.shouldSetState(e.modifiers, firedEvent)) {
            stateMask += 65536;
        }
        if (cef_event_flags.COMMAND_DOWN.shouldSetState(e.modifiers, firedEvent)) {
            stateMask += 0x400000;
        }
        if (cef_event_flags.NUM_LOCK_ON.shouldSetState(e.modifiers, firedEvent)) {
            stateMask += 16777299;
        }
        if (cef_event_flags.IS_KEY_PAD.shouldSetState(e.modifiers, firedEvent)) {
            stateMask += 2;
        }
        if (cef_event_flags.IS_LEFT.shouldSetState(e.modifiers, firedEvent)) {
            stateMask += 16384;
        }
        if (cef_event_flags.IS_RIGHT.shouldSetState(e.modifiers, firedEvent)) {
            stateMask += 131072;
        }
        firedEvent.stateMask = stateMask;
        this.sendKeyEvent(firedEvent);
        if (firedEvent.doit && "cocoa".equals(SWT.getPlatform())) {
            int nativeHandleKey = ChromiumLib.cefswt_handlekey(browser, event);
            return nativeHandleKey;
        }
        return 0;
    }

    private static void set_focus_handler() {
        focusHandler = CEFFactory.newFocusHandler();
        Chromium.focusHandler.on_got_focus_cb = new CallbackExt(Chromium.class, "on_got_focus", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
        Chromium.focusHandler.on_got_focus = Chromium.checkGetAddress(Chromium.focusHandler.on_got_focus_cb);
        Chromium.focusHandler.on_set_focus_cb = new CallbackExt(Chromium.class, "on_set_focus", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Integer.TYPE});
        Chromium.focusHandler.on_set_focus = Chromium.checkGetAddress(Chromium.focusHandler.on_set_focus_cb);
        Chromium.focusHandler.on_take_focus_cb = new CallbackExt(Chromium.class, "on_take_focus", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Integer.TYPE});
        Chromium.focusHandler.on_take_focus = Chromium.checkGetAddress(Chromium.focusHandler.on_take_focus_cb);
        Chromium.clientHandler.get_focus_handler_cb = new CallbackExt(Chromium.class, "get_focus_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_focus_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_focus_handler_cb);
        Chromium.focusHandler.ptr = C.malloc((long)cef_focus_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.focusHandler.ptr, focusHandler, cef_focus_handler_t.sizeof);
    }

    static long get_focus_handler(long client) {
        if (focusHandler == null) {
            return 0L;
        }
        return Chromium.focusHandler.ptr;
    }

    static void on_got_focus(long focusHandler, long browser) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.safeGeInstance(id).on_got_focus(browser);
        ChromiumLib.cefswt_ref(browser, 0);
    }

    private void on_got_focus(long browser2) {
        if (!this.isDisposed()) {
            this.debugPrint("on_got_focus: ");
            if (this.chromium.getDisplay().getFocusControl() != this.chromium && this.chromium.getDisplay().getActiveShell() != null) {
                this.debugPrint("on_got_focus: setFocus");
                this.chromium.setFocus();
            }
            this.hasFocus = true;
        }
    }

    static int on_set_focus(long focusHandler, long browser, int focusSource) {
        int id = ChromiumLib.cefswt_get_id(browser);
        int r = Chromium.safeGeInstance(id).on_set_focus(browser);
        ChromiumLib.cefswt_ref(browser, 0);
        return r;
    }

    private int on_set_focus(long browser) {
        if (this.ignoreFirstFocus) {
            this.debugPrint("ignoreFirstFocus");
            this.ignoreFirstFocus = false;
            return 1;
        }
        this.debugPrint("on_set_focus");
        return 0;
    }

    static void on_take_focus(long focusHandler, long browser, int next) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_take_focus: " + id);
        Chromium.safeGeInstance(id).on_take_focus(browser, next);
        ChromiumLib.cefswt_ref(browser, 0);
    }

    private void on_take_focus(long browser, int next) {
        int indexOf;
        if (this.isDisposed()) {
            return;
        }
        this.hasFocus = false;
        Control[] tabOrder = this.chromium.getParent().getTabList();
        if (tabOrder.length == 0) {
            tabOrder = this.chromium.getParent().getChildren();
        }
        if ((indexOf = Arrays.asList(tabOrder).indexOf(this.chromium)) != -1) {
            int newIndex;
            int n = newIndex = next == 1 ? indexOf + 1 : indexOf - 1;
            if (newIndex > 0 && newIndex < tabOrder.length && !tabOrder[newIndex].isDisposed()) {
                tabOrder[newIndex].setFocus();
                return;
            }
        }
        if (!this.isDisposed() && !this.chromium.getParent().isDisposed()) {
            this.chromium.getParent().setFocus();
        }
    }

    public boolean isFocusControl() {
        return "gtk".equals(SWT.getPlatform()) ? this.hasFocus : false;
    }

    private static void doMessageLoop(final Display display) {
        loopWork = new Runnable(){

            @Override
            public void run() {
                if (lib != null && !display.isDisposed()) {
                    Chromium.safe_loop_work("timer");
                    display.timerExec(66, loopWork);
                } else {
                    Chromium.debug("STOPPING MSG LOOP");
                }
            }
        };
        display.timerExec(33, loopWork);
    }

    private synchronized void checkBrowser() {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (this.browser == 0L) {
            SWT.error((int)24);
        }
    }

    static int on_process_message_received(long client, long browser, long frame, int source, long processMessage) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_process_message_received: " + id);
        int r = Chromium.safeGeInstance(id).on_process_message_received(browser, source, processMessage);
        ChromiumLib.cefswt_ref(browser, 0);
        ChromiumLib.cefswt_ref(frame, 0);
        ChromiumLib.cefswt_ref(processMessage, 0);
        return r;
    }

    private int on_process_message_received(long browser, int source, long processMessage) {
        if (source != 1 || !this.jsEnabled || this.isDisposed()) {
            return 0;
        }
        FunctionSt fn = new FunctionSt();
        ChromiumLib.cefswt_function_id(processMessage, fn);
        int id = fn.id;
        if (id < 0) {
            return 0;
        }
        int argsSize = fn.args;
        Object[] args = new Object[argsSize];
        int i = 0;
        while (i < argsSize) {
            int arg = i;
            EvalReturned callback = (loop, type, valuePtr) -> {
                if (loop != 1) {
                    String value = ChromiumLib.cefswt_cstring_to_java(valuePtr, loop == -1);
                    objectArray[n] = this.mapType(type, value);
                }
            };
            CallbackExt callback_cb = new CallbackExt((Object)callback, "invoke", Void.TYPE, new Type[]{Integer.TYPE, Integer.TYPE, Long.TYPE});
            try {
                ChromiumLib.cefswt_function_arg(processMessage, i, Chromium.checkGetAddress(callback_cb));
            }
            catch (SWTException e) {
                CEFFactory.ReturnType returnType = CEFFactory.ReturnType.Error;
                String returnStr = new SWTException(5).getMessage();
                ChromiumLib.cefswt_function_return(browser, id, fn.port, returnType.intValue(), returnStr);
                return 1;
            }
            Chromium.disposeCallback(callback_cb);
            ++i;
        }
        BrowserFunction browserFunction = (BrowserFunction)this.functions.get(id);
        if (browserFunction != null) {
            this.reentrant = fn.port;
            Object ret = browserFunction.function(args);
            this.reentrant = 0;
            Object[] returnPair = this.convertType(ret);
            CEFFactory.ReturnType returnType = (CEFFactory.ReturnType)((Object)returnPair[0]);
            String returnStr = (String)returnPair[1];
            ChromiumLib.cefswt_function_return(browser, id, fn.port, returnType.intValue(), returnStr);
        } else {
            CEFFactory.ReturnType returnType = CEFFactory.ReturnType.Error;
            String returnStr = new SWTException(49).getMessage();
            ChromiumLib.cefswt_function_return(browser, id, fn.port, returnType.intValue(), returnStr);
        }
        return 1;
    }

    private Object[] convertType(Object ret) {
        CEFFactory.ReturnType returnType = CEFFactory.ReturnType.Error;
        String returnStr = "";
        if (ret == null) {
            returnType = CEFFactory.ReturnType.Null;
            returnStr = "null";
        } else if (Boolean.class.isInstance(ret)) {
            returnType = CEFFactory.ReturnType.Bool;
            returnStr = Boolean.TRUE.equals(ret) ? "1" : "0";
        } else if (Number.class.isInstance(ret)) {
            returnType = CEFFactory.ReturnType.Double;
            returnStr = NumberFormat.getInstance(Locale.US).format(ret);
        } else if (String.class.isInstance(ret)) {
            returnType = CEFFactory.ReturnType.Str;
            returnStr = ret.toString();
        } else if (ret.getClass().isArray()) {
            returnType = CEFFactory.ReturnType.Array;
            StringBuilder buffer = new StringBuilder();
            buffer.append("\"");
            int i = 0;
            while (i < Array.getLength(ret)) {
                if (i > 0) {
                    buffer.append(";");
                }
                Object[] arrayElem = this.convertType(Array.get(ret, i));
                buffer.append("'");
                buffer.append(((CEFFactory.ReturnType)((Object)arrayElem[0])).intValue());
                buffer.append(",");
                buffer.append((String)arrayElem[1]);
                buffer.append("'");
                ++i;
            }
            buffer.append("\"");
            returnStr = buffer.toString();
        } else {
            returnStr = String.valueOf(new SWTException(51).getMessage()) + ": " + ret.getClass().getName();
        }
        return new Object[]{returnType, returnStr};
    }

    protected void browserFocus(boolean set) {
        this.debugPrint("cef focus: " + set);
        if (!this.isDisposed() && this.browser != 0L) {
            long parent;
            long l = parent = Display.getDefault().getActiveShell() == null ? 0L : this.getHandle(this.chromium.getParent());
            if (this.chromium.getDisplay().getActiveShell() != this.chromium.getShell()) {
                return;
            }
            ChromiumLib.cefswt_set_focus(this.browser, set, parent);
        }
    }

    public boolean close() {
        if (this.disposing != Dispose.No || this.isDisposed()) {
            return false;
        }
        if (this.browser == 0L) {
            return true;
        }
        boolean closed = false;
        this.debugPrint("call try_close_browser");
        this.disposing = Dispose.FromClose;
        ChromiumLib.cefswt_close_browser(this.browser, 0);
        long t = System.currentTimeMillis();
        long end = t + 10000L;
        Shell shell = this.chromium.getShell();
        Display display = shell.getDisplay();
        while (!shell.isDisposed() && System.currentTimeMillis() < end) {
            if (this.disposing == Dispose.Unload) {
                end += 1000L;
            } else {
                if (this.disposing == Dispose.UnloadCancel) {
                    Chromium.debug("in close, disposing:" + (Object)((Object)this.disposing));
                    break;
                }
                if (this.disposing == Dispose.UnloadClosed) {
                    Chromium.debug("in close, disposing:" + (Object)((Object)this.disposing));
                    this.disposing = Dispose.WaitIfClosed;
                    end = System.currentTimeMillis() + 198L;
                } else if (this.disposing == Dispose.DoIt) {
                    Chromium.debug("in close, disposing:" + (Object)((Object)this.disposing));
                    closed = true;
                    break;
                }
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!closed) {
            this.disposing = Dispose.No;
        }
        return closed;
    }

    public void dispose() {
        boolean callClose;
        this.debugPrint("in dispose, disposing " + (Object)((Object)this.disposing));
        if (this.disposing == Dispose.FromDispose || this.isDisposed()) {
            return;
        }
        boolean bl = callClose = this.disposing == Dispose.No && "gtk".equals(SWT.getPlatform());
        if (this.disposing != Dispose.FromBrowser) {
            this.disposing = Dispose.FromDispose;
        }
        ++disposingAny;
        if (this.focusListener != null) {
            this.chromium.removeFocusListener(this.focusListener);
        }
        this.focusListener = null;
        if (this.traverseListener != null) {
            this.chromium.removeListener(31, this.traverseListener);
            this.chromium.removeListener(1, this.traverseListener);
            this.traverseListener = null;
        }
        for (BrowserFunction function : this.functions.values()) {
            function.dispose(false);
        }
        this.functions.clear();
        if (this.browser != 0L && callClose) {
            this.debugPrint("call close_browser");
            ChromiumLib.cefswt_close_browser(this.browser, 1);
        }
    }

    public static void shutdown() {
        String platform = SWT.getPlatform();
        if ("cocoa".equals(platform)) {
            return;
        }
        Chromium.debug("Shutdown from API");
        Chromium.internalShutdown();
    }

    private static void internalShutdown() {
        if (lib == null || app == null) {
            return;
        }
        if (browsers.get() == 0) {
            Chromium.debug("shutting down CEF on exit from thread " + Thread.currentThread().getName());
            Chromium.freeAll(null);
            ChromiumLib.cefswt_shutdown();
            if (cookieVisitor != null) {
                Chromium.disposeCallback(Chromium.cookieVisitor.visit_cb);
                C.free((long)Chromium.cookieVisitor.ptr);
                cookieVisitor = null;
            }
            Chromium.disposeCallback(Chromium.app.get_browser_process_handler_cb);
            C.free((long)Chromium.app.ptr);
            app = null;
            Chromium.disposeCallback(Chromium.browserProcessHandler.on_schedule_message_pump_work_cb);
            C.free((long)Chromium.browserProcessHandler.ptr);
            browserProcessHandler = null;
            Chromium.debug("after shutting down CEF");
        } else if (!shuttindDown) {
            shuttindDown = true;
            Chromium.debug("delaying shutdown due browsers not disposed yet");
        }
    }

    private static Object loadLib() {
        String gtk;
        String platform = SWT.getPlatform();
        if ("gtk".equals(platform) && (gtk = System.getProperty("org.eclipse.swt.internal.gtk.version", "")).startsWith("2")) {
            throw new SWTException(47, "Chromium Browser is no longer supported in GTK2. ");
        }
        String subDir = "chromium-3809";
        File cefrustlib = null;
        try {
            String mapLibraryName = System.mapLibraryName(SHARED_LIB_V);
            String mapJniName = JNI_LIB_V;
            Chromium.maybeClean(subDir);
            Enumeration<URL> fragments = Library.class.getClassLoader().getResources(String.valueOf(subDir) + "/chromium.properties");
            while (fragments.hasMoreElements()) {
                URL url = fragments.nextElement();
                Throwable throwable = null;
                Object var8_14 = null;
                try (InputStream is = url.openStream();){
                    Properties props = new Properties();
                    props.load(is);
                    for (String prop : props.stringPropertyNames()) {
                        String propValue;
                        Path path;
                        String fileName;
                        if ("cefVersion".equals(prop) || mapLibraryName.equals(fileName = (path = Paths.get(propValue = props.getProperty(prop), new String[0])).getFileName().toString()) || fileName.contains(mapJniName)) continue;
                        ResourceExpander.findResource((String)path.getParent().toString(), (String)fileName, (boolean)false);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            cefrustlib = ResourceExpander.findResource((String)subDir, (String)mapLibraryName, (boolean)false);
            File jnilib = ResourceExpander.findResource((String)subDir, (String)mapJniName, (boolean)true);
            cefrustPath = cefrustlib.getParentFile().getCanonicalPath();
            CEFFactory.create(cefrustPath);
            System.load(cefrustlib.getAbsolutePath());
            System.load(jnilib.getAbsolutePath());
            Chromium.setupCookies();
            return new Object();
        }
        catch (UnsatisfiedLinkError e) {
            String cefLib = System.mapLibraryName("cef");
            if ("cocoa".equals(platform)) {
                cefLib = "Chromium Embedded Framework.framework";
            } else if ("win32".equals(platform)) {
                cefLib = "libcef.dll";
            }
            if (cefrustlib != null && !new File(cefrustlib.getParentFile(), cefLib).exists()) {
                SWTException swtError = new SWTException(47, "Missing CEF binaries for Chromium Browser. Extract CEF binaries to " + cefrustPath);
                swtError.throwable = e;
                throw swtError;
            }
            throw e;
        }
        catch (IOException e) {
            SWTException swtError = new SWTException(47, "");
            swtError.throwable = e;
            throw swtError;
        }
    }

    private static void maybeClean(String subDir) {
        Path folder = Paths.get(ResourceExpander.USER_HOME, ResourceExpander.SWT_LIB_DIR, subDir);
        Path cleanFile = folder.resolve(".clean");
        boolean mark = false;
        boolean clean = false;
        if (Files.exists(folder, new LinkOption[0])) {
            if (!Files.exists(cleanFile, new LinkOption[0])) {
                mark = true;
                clean = true;
            } else {
                String latestClean;
                List<String> lines = null;
                try {
                    lines = Files.readAllLines(cleanFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                String string = latestClean = lines == null || lines.isEmpty() ? "0" : lines.get(0);
                if (VERSION.compareTo(latestClean) > 0) {
                    mark = true;
                    clean = true;
                }
            }
        } else {
            mark = true;
        }
        if (clean) {
            try {
                Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (exc == null) {
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                        throw exc;
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (mark) {
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
                Files.write(cleanFile, Collections.singletonList(VERSION), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void setupCookies() {
        WebBrowser.NativeClearSessions = () -> ChromiumLib.cefswt_delete_cookies();
        WebBrowser.NativeSetCookie = () -> {
            List<HttpCookie> cookies = HttpCookie.parse(WebBrowser.CookieValue);
            Iterator<HttpCookie> iterator = cookies.iterator();
            if (iterator.hasNext()) {
                HttpCookie cookie = iterator.next();
                long age = cookie.getMaxAge();
                if (age != -1L) {
                    age = Instant.now().plusSeconds(age).getEpochSecond();
                }
                WebBrowser.CookieResult = ChromiumLib.cefswt_set_cookie(WebBrowser.CookieUrl, cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getSecure() ? 1 : 0, cookie.isHttpOnly() ? 1 : 0, age);
            }
        };
        WebBrowser.NativeGetCookie = () -> {
            if (cookieVisitor == null) {
                Chromium.setCookieVisitor();
            }
            cookieVisited = new CompletableFuture();
            boolean result = ChromiumLib.cefswt_get_cookie(WebBrowser.CookieUrl, Chromium.cookieVisitor.ptr);
            if (!result) {
                cookieVisited = null;
                throw new SWTException("Failed to get cookies");
            }
            try {
                block9: {
                    Display display;
                    long end;
                    block8: {
                        end = System.currentTimeMillis() + 200L;
                        display = Display.getCurrent();
                        if (!true) break block8;
                        if (cookieVisited.isDone()) return;
                        if (display.isDisposed()) return;
                        if (System.currentTimeMillis() >= end) break block9;
                    }
                    do {
                        loopWorkRunnable.run();
                        if (!display.readAndDispatch()) {
                            display.sleep();
                        }
                        if (cookieVisited.isDone()) return;
                        if (display.isDisposed()) return;
                    } while (System.currentTimeMillis() < end);
                }
                return;
            }
            finally {
                cookieVisited = null;
            }
        };
    }

    private static void setCookieVisitor() {
        cookieVisitor = CEFFactory.newCookieVisitor();
        Chromium.cookieVisitor.visit_cb = new CallbackExt(Chromium.class, "cookieVisitor_visit", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        Chromium.cookieVisitor.visit = Chromium.checkGetAddress(Chromium.cookieVisitor.visit_cb);
        Chromium.cookieVisitor.ptr = C.malloc((long)cef_cookie_visitor_t.sizeof);
        ChromiumLib.memmove(Chromium.cookieVisitor.ptr, cookieVisitor, cef_cookie_visitor_t.sizeof);
    }

    static int cookieVisitor_visit(long self, long cefcookie, int count, int total, int delete) {
        String name = ChromiumLib.cefswt_cookie_to_java(cefcookie);
        Chromium.debug("Visitor " + count + "/" + total + ": " + name + ":" + Thread.currentThread());
        if (WebBrowser.CookieName != null && WebBrowser.CookieName.equals(name)) {
            String value = ChromiumLib.cefswt_cookie_value(cefcookie);
            Chromium.debug("cookie value: " + value);
            WebBrowser.CookieValue = value;
            cookieVisited.complete(true);
            return 0;
        }
        return 1;
    }

    public boolean back() {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (this.canGoBack) {
            ChromiumLib.cefswt_go_back(this.browser);
            return true;
        }
        return false;
    }

    public boolean execute(String script) {
        if (!this.jsEnabled) {
            return false;
        }
        this.enableProgress.thenRun(() -> ChromiumLib.cefswt_execute(this.browser, script));
        return true;
    }

    public Object evaluate(String script) throws SWTException {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (!this.jsEnabled) {
            return null;
        }
        if (this.browser == 0L && this.paintListener != null) {
            if (!Boolean.getBoolean("swt.chromium.headless")) {
                this.chromium.removePaintListener(this.paintListener);
            }
            this.paintListener = null;
            this.createBrowser();
        }
        this.checkBrowser();
        Object[] ret = new Object[2];
        EvalReturned callback = (loop, type, valuePtr) -> {
            if (loop == 1) {
                if (!loopDisable || !"cocoa".equals(SWT.getPlatform()) && !"gtk".equals(SWT.getPlatform())) {
                    this.chromium.getDisplay().readAndDispatch();
                }
            } else {
                String value = ChromiumLib.cefswt_cstring_to_java(valuePtr, loop == -1);
                this.debugPrint("eval returned: " + type + ":" + value);
                try {
                    objectArray[0] = this.mapType(type, value);
                }
                catch (SWTException e) {
                    objectArray[1] = e;
                }
            }
        };
        CallbackExt callback_cb = new CallbackExt((Object)callback, "invoke", Void.TYPE, new Type[]{Integer.TYPE, Integer.TYPE, Long.TYPE});
        StringBuilder buffer = new StringBuilder("(function() {");
        buffer.append("\n");
        buffer.append(script);
        buffer.append("\n})()");
        boolean returnSt = ChromiumLib.cefswt_eval(this.browser, buffer.toString(), this.reentrant != 0 ? this.reentrant : 0, Chromium.checkGetAddress(callback_cb));
        Chromium.disposeCallback(callback_cb);
        if (!returnSt) {
            throw new SWTException("Script that was evaluated failed");
        }
        if (ret[1] != null) {
            throw (SWTException)((Object)ret[1]);
        }
        return ret[0];
    }

    private Object mapType(int type, String value) throws SWTException {
        if (type == CEFFactory.ReturnType.Error.intValue()) {
            if ("51".equals(value)) {
                throw new SWTException(51);
            }
            throw new SWTException(50, value);
        }
        if (type == CEFFactory.ReturnType.Null.intValue()) {
            return null;
        }
        if (type == CEFFactory.ReturnType.Bool.intValue()) {
            return "1".equals(value) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (type == CEFFactory.ReturnType.Double.intValue()) {
            return Double.parseDouble(value);
        }
        if (type == CEFFactory.ReturnType.Array.intValue()) {
            String value_unquoted = value.substring(1, value.length() - 1);
            String[] elements = value_unquoted.split(";(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
            Object[] array = value_unquoted.isEmpty() ? new Object[]{} : new Object[elements.length];
            int i = 0;
            while (i < array.length) {
                Object elemValue;
                String elemUnquoted = elements[i].substring(1, elements[i].length() - 1);
                String[] parts = elemUnquoted.split(",(?=(?:[^']*'[^']*')*[^']*$)", 2);
                CEFFactory.ReturnType elemType = CEFFactory.ReturnType.from(parts[0]);
                array[i] = elemValue = this.mapType(elemType.intValue(), parts[1]);
                ++i;
            }
            return array;
        }
        if (type == CEFFactory.ReturnType.Str.intValue() && value == null) {
            return "";
        }
        return value;
    }

    public boolean forward() {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (this.canGoForward) {
            ChromiumLib.cefswt_go_forward(this.browser);
            return true;
        }
        return false;
    }

    public String getBrowserType() {
        return "chromium";
    }

    public String getText() {
        if (this.browser != 0L && !this.isDisposed() && this.disposing == Dispose.No) {
            cef_string_visitor_t textVisitor = this.set_text_visitor();
            try {
                this.textVisited = new CompletableFuture();
                ChromiumLib.cefswt_get_text(this.browser, textVisitor.ptr);
                Display display = this.chromium.getDisplay();
                while (!this.textVisited.isDone() && !display.isDisposed()) {
                    Chromium.debug("in text loop");
                    loopWorkRunnable.run();
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                try {
                    String string = this.textVisited.get();
                    return string;
                }
                catch (InterruptedException | ExecutionException exception) {
                }
            }
            finally {
                Chromium.disposeCallback(textVisitor.visit_cb);
                C.free((long)textVisitor.ptr);
                this.textVisited = null;
            }
        }
        return "";
    }

    public String getUrl() {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (this.browser == 0L) {
            if (this.url == null) {
                return "about:blank";
            }
            return Chromium.getPlainUrl(this.url);
        }
        long urlPtr = ChromiumLib.cefswt_get_url(this.browser);
        String cefurl = null;
        if (urlPtr != 0L) {
            cefurl = ChromiumLib.cefswt_cstring_to_java(urlPtr, true);
        }
        if (cefurl == null) {
            cefurl = Chromium.getPlainUrl(this.url);
        }
        return cefurl;
    }

    public boolean isBackEnabled() {
        return this.canGoBack;
    }

    public boolean isForwardEnabled() {
        return this.canGoForward;
    }

    public void refresh() {
        if (lib == null) {
            SWT.error((int)47);
        }
        this.jsEnabled = this.jsEnabledOnNextPage;
        if (this.browser != 0L) {
            ChromiumLib.cefswt_reload(this.browser);
        }
    }

    public boolean setText(String html, boolean trusted) {
        String texturl = DATA_TEXT_URL + Base64.getEncoder().encodeToString(html.getBytes());
        return this.setUrl(texturl, null, null);
    }

    private static String getPlainUrl(String url) {
        if (url != null && url.startsWith(DATA_TEXT_URL)) {
            return url.substring(0, DATA_TEXT_URL.length() - 8);
        }
        return url;
    }

    public boolean setUrl(String url, String postData, String[] headers) {
        this.url = url;
        this.postData = postData;
        this.headers = headers;
        this.jsEnabled = this.jsEnabledOnNextPage;
        if (!this.isDisposed() && this.browser != 0L) {
            this.debugPrint("set url: " + Chromium.getPlainUrl(url));
            this.doSetUrl(url, postData, headers);
        }
        return true;
    }

    private CompletableFuture<Void> doSetUrl(String url, String postData, String[] headers) {
        return this.enableProgress.thenRun(() -> {
            if (this.isDisposed()) {
                return;
            }
            Chromium.doSetUrlPost(this.browser, url, postData, headers);
        });
    }

    private static void doSetUrlPost(long browser, String url, String postData, String[] headers) {
        byte[] bytes = postData != null ? postData.getBytes(Charset.forName("ASCII")) : null;
        int bytesLength = postData != null ? bytes.length : 0;
        int headersLength = headers != null ? headers.length : 0;
        String joinHeaders = headers == null ? null : String.join((CharSequence)"::", headers);
        ChromiumLib.cefswt_load_url(browser, url, bytes, bytesLength, joinHeaders, headersLength);
    }

    public void stop() {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (this.browser != 0L) {
            ChromiumLib.cefswt_stop(this.browser);
        }
    }

    boolean isDisposed() {
        return this.chromium == null || this.chromium.isDisposed();
    }

    private static Chromium safeGeInstance(int id) {
        Chromium c = instances.get(id);
        if (c == null) {
            throw new SWTError("Wrong chromium id " + id);
        }
        return c;
    }

    static long checkGetAddress(CallbackExt cb) {
        long address = cb.getAddress();
        if (address == 0L) {
            throw new SWTError(3);
        }
        return address;
    }

    static void disposeCallback(CallbackExt cb) {
        if (cb != null) {
            cb.dispose();
        }
    }

    class AuthDialog
    extends Dialog {
        public AuthDialog(Shell parent) {
            super(parent);
        }

        public void open(final AuthenticationEvent authEvent, String realm) {
            Shell parent = this.getParent();
            final Shell shell = new Shell(parent, 67696);
            shell.setText("Authentication Required");
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            shell.setLayout((Layout)layout);
            Label info = new Label((Composite)shell, 64);
            StringBuilder infoText = new StringBuilder(authEvent.location);
            infoText.append(" is requesting you username and password.");
            if (realm != null) {
                infoText.append(" The site says: \"").append(realm).append("\"");
            }
            info.setText(infoText.toString());
            info.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            Label label1 = new Label((Composite)shell, 0);
            label1.setText("User Name: ");
            final Text username = new Text((Composite)shell, 2052);
            username.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Label label2 = new Label((Composite)shell, 0);
            label2.setText("Password: ");
            final Text password = new Text((Composite)shell, 2052);
            password.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            password.setEchoChar('*');
            Composite bar = new Composite((Composite)shell, 0);
            bar.setLayoutData((Object)new GridData(0x1000008, 0x1000008, false, true, 2, 1));
            bar.setLayout((Layout)new GridLayout(2, true));
            Button cancelButton = new Button(bar, 8);
            cancelButton.setText("Cancel");
            cancelButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    authEvent.doit = false;
                    shell.close();
                }
            });
            GridData cancelData = new GridData(0x1000000, 0x1000008, false, false);
            cancelData.widthHint = 80;
            cancelButton.setLayoutData((Object)cancelData);
            Button okButton = new Button(bar, 8);
            okButton.setText("Ok");
            okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    authEvent.user = username.getText();
                    authEvent.password = password.getText();
                    shell.close();
                }
            });
            GridData okData = new GridData(0x1000000, 0x1000008, false, false);
            okData.minimumWidth = -1;
            okData.widthHint = 80;
            okButton.setLayoutData((Object)okData);
            shell.pack();
            shell.open();
            Display display = parent.getDisplay();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    private final class CefFocusListener
    implements FocusListener {
        private boolean enabled = true;

        private CefFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            if (!this.enabled) {
                return;
            }
            this.enabled = false;
            Chromium.this.browserFocus(false);
            Chromium.this.hasFocus = false;
            this.enabled = true;
        }

        public void focusGained(FocusEvent e) {
            if (!this.enabled) {
                return;
            }
            this.enabled = false;
            Chromium.this.browserFocus(true);
            this.enabled = true;
        }
    }

    static enum Dispose {
        No,
        FromDispose,
        FromClose,
        FromBrowser,
        Unload,
        UnloadClosed,
        UnloadCancel,
        WaitIfClosed,
        DoIt;

    }

    static class Download {
        static final Map<Integer, Download> downloads = new HashMap<Integer, Download>();
        private int id;
        private String name;
        private Shell shell;
        private Label statusLabel;
        private Button cancel;
        private long cancel_cb;
        private boolean open;
        private Label nameLabel;
        private ProgressBar pb;
        final Listener cancelListener = event -> {
            this.pb.setState(4);
            ChromiumLib.cefswt_download_callback(this.cancel_cb, null, 0);
            this.dispose();
        };

        public Download(DownloadItem item, String name, Chromium browser) {
            this.id = item.id;
            this.name = name;
            downloads.put(item.id, this);
            this.shell = new Shell();
            String msg = Compatibility.getMessage((String)"SWT_FileDownload");
            this.shell.setText(msg);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 15;
            gridLayout.marginWidth = 15;
            gridLayout.verticalSpacing = 20;
            this.shell.setLayout((Layout)gridLayout);
            this.nameLabel = new Label((Composite)this.shell, 64);
            this.setText(item);
            GridData data = new GridData();
            Monitor monitor = browser.chromium.getMonitor();
            int maxWidth = monitor.getBounds().width / 2;
            int width = this.nameLabel.computeSize((int)-1, (int)-1).x;
            data.widthHint = Math.min(width, maxWidth);
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.nameLabel.setLayoutData((Object)data);
            int pbStyle = item.percent == -1 ? 65794 : 65792;
            this.pb = new ProgressBar((Composite)this.shell, pbStyle);
            this.pb.setSelection(item.percent);
            this.pb.setMinimum(0);
            this.pb.setMaximum(100);
            this.pb.setState(0);
            this.pb.setLayoutData((Object)new GridData(4, 1, true, false));
            this.statusLabel = new Label((Composite)this.shell, 0);
            this.statusLabel.setText(Compatibility.getMessage((String)"SWT_Download_Started"));
            data = new GridData(1808);
            this.statusLabel.setLayoutData((Object)data);
            this.cancel = new Button((Composite)this.shell, 8);
            this.cancel.setText(Compatibility.getMessage((String)"SWT_Cancel"));
            data = new GridData();
            data.horizontalAlignment = 2;
            this.cancel.setLayoutData((Object)data);
            this.cancel.addListener(13, this.cancelListener);
        }

        private void show() {
            this.open = true;
            this.shell.pack();
            this.shell.open();
        }

        private void update(DownloadItem item, long cancel_cb) {
            this.cancel_cb = cancel_cb;
            int status = item.status;
            if (this.shell.isDisposed()) {
                this.dispose();
                return;
            }
            if (status == 2) {
                Display.getDefault().timerExec(3000, this::dispose);
            }
            this.setText(item);
            long current = item.received / 1024L;
            long total = item.total / 1024L;
            String message = Compatibility.getMessage((String)"SWT_Download_Status", (Object[])new Object[]{current, new Long(total)});
            message = String.valueOf(message) + " at " + item.speed / 1024L + " KB/s " + (item.percent != -1 ? "(" + item.percent + "%)" : "");
            this.statusLabel.setText(message);
            this.pb.setSelection(item.percent);
            if (status == 0 || status == 3) {
                this.pb.setState(1);
                this.statusLabel.setText(Compatibility.getMessage((String)"SWT_Download_Error"));
                this.cancel.removeListener(13, this.cancelListener);
                this.cancel.addListener(13, event -> this.dispose());
                return;
            }
        }

        private void setText(DownloadItem item) {
            String nameString = item.file != 0L ? ChromiumLib.cefswt_cefstring_to_java(item.file) : this.name;
            String urlString = ChromiumLib.cefswt_cefstring_to_java(item.url);
            String msg = Compatibility.getMessage((String)"SWT_Download_Location", (Object[])new Object[]{String.valueOf(nameString) + "\n", urlString});
            this.nameLabel.setText(msg);
        }

        private void dispose() {
            downloads.remove(this.id);
            ChromiumLib.cefswt_ref(this.cancel_cb, 0);
            this.shell.dispose();
        }
    }

    public static interface EvalReturned {
        public void invoke(int var1, int var2, long var3);
    }

    private static enum cef_event_flags {
        NONE(0),
        CAPS_LOCK_ON(1),
        SHIFT_DOWN(2, 131072),
        CONTROL_DOWN(4, 262144),
        ALT_DOWN(8, 65536),
        COMMAND_DOWN(128, 0x400000),
        NUM_LOCK_ON(256),
        IS_KEY_PAD(512),
        IS_LEFT(1024),
        IS_RIGHT(2048);

        int cefFlag;
        private int swtKey;

        private cef_event_flags(int flag) {
            this(flag, 0);
        }

        private cef_event_flags(int flag, int swtKey) {
            this.cefFlag = flag;
            this.swtKey = swtKey;
        }

        boolean shouldSetState(int modifiers, Event event) {
            if (this.isSet(modifiers)) {
                return event.type != 1 || event.keyCode != this.swtKey || this.swtKey == 0;
            }
            return event.type == 2 && event.keyCode == this.swtKey && this.swtKey != 0;
        }

        boolean isSet(int modifiers) {
            return (modifiers & this.cefFlag) != 0;
        }
    }
}

