/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.controls;

import ch.elexis.data.PersistentObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GenericSelectionComposite
extends Composite
implements ISelectionProvider {
    private ListenerList selectionListeners = new ListenerList();
    private List<?> input;
    private IStructuredSelection selection;
    private Label selectLabel;
    private Button selectButton;

    public GenericSelectionComposite(Composite parent, int style) {
        super(parent, style);
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.selectLabel = new Label((Composite)this, 0);
        this.selectLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.selectButton = new Button((Composite)this, 0);
        this.selectButton.setText("...");
        this.selectButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GenericSelectionComposite.this.input != null && !GenericSelectionComposite.this.input.isEmpty()) {
                    GenericSelectionDialog dialog = new GenericSelectionDialog(GenericSelectionComposite.this.getShell(), GenericSelectionComposite.this.input);
                    if (GenericSelectionComposite.this.selection != null) {
                        dialog.setSelection(GenericSelectionComposite.this.selection.toList());
                    }
                    if (dialog.open() == 0) {
                        GenericSelectionComposite.this.setSelection((ISelection)dialog.getSelection());
                        GenericSelectionComposite.this.callSelectionListeners();
                    }
                }
            }
        });
    }

    private void updateLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.selection != null && !this.selection.isEmpty()) {
            for (Object object : this.selection.toList()) {
                String label = GenericSelectionDialog.getLabel(object);
                if (label == null || label.isEmpty()) continue;
                if (sb.length() > 0) {
                    sb.append(", ").append(label);
                    continue;
                }
                sb.append(label);
            }
            this.selectLabel.setText(sb.toString());
        } else {
            this.selectLabel.setText("");
        }
        this.getParent().layout();
    }

    public void setInput(List<?> input) {
        this.input = input;
    }

    private void callSelectionListeners() {
        Object[] listeners = this.selectionListeners.getListeners();
        if (listeners != null && listeners.length > 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                ((ISelectionChangedListener)object).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
                ++n2;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        if (this.selection != null) {
            return this.selection;
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            this.updateLabel();
        }
    }

    public static class GenericSelectionDialog
    extends Dialog {
        private List<?> input;
        private Map<Object, Button> buttonMap = new HashMap<Object, Button>();
        private List<Object> selection = new LinkedList<Object>();

        public GenericSelectionDialog(Shell parentShell, List<?> input) {
            super(parentShell);
            this.input = input;
        }

        public void setSelection(List<Object> selection) {
            this.selection = new LinkedList<Object>(selection);
        }

        public IStructuredSelection getSelection() {
            return new StructuredSelection(this.selection);
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = (Composite)super.createDialogArea(parent);
            ScrolledComposite sc = new ScrolledComposite(ret, 768);
            Composite child = new Composite((Composite)sc, 0);
            child.setLayout((Layout)new GridLayout());
            GridData data = new GridData(4, 4, true, true);
            data.heightHint = 400;
            sc.setLayoutData((Object)data);
            Label title = new Label(child, 0);
            title.setText("Auswahl:");
            for (final Object object : this.input) {
                final Button button = new Button(child, 32);
                button.setText(GenericSelectionDialog.getLabel(object));
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (button.getSelection()) {
                            selection.add(object);
                        } else {
                            selection.remove(object);
                        }
                    }
                });
                this.buttonMap.put(object, button);
            }
            sc.setMinSize(child.computeSize(-1, -1));
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            sc.setContent((Control)child);
            this.updateSelectionUi();
            return ret;
        }

        private void updateSelectionUi() {
            if (this.selection != null && !this.selection.isEmpty() && !this.buttonMap.isEmpty()) {
                for (Object object : this.selection) {
                    this.buttonMap.get(object).setSelection(true);
                }
            }
        }

        protected static String getLabel(Object object) {
            if (object instanceof PersistentObject) {
                return ((PersistentObject)object).getLabel();
            }
            if (object != null) {
                return object.toString();
            }
            return "";
        }
    }
}

