/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.handler;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.documents.Messages;
import ch.elexis.core.ui.documents.service.DocumentStoreServiceHolder;
import ch.elexis.core.ui.documents.service.LocalLockServiceHolder;
import ch.elexis.core.ui.documents.views.DocumentsMetaDataDialog;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentCrudHandler
extends AbstractHandler
implements IHandler {
    private static Logger logger = LoggerFactory.getLogger(DocumentCrudHandler.class);
    public static final String CMD_NEW_DOCUMENT = "ch.elexis.core.ui.documents.commandCreate";
    public static final String CMD_UPDATE_DOCUMENT = "ch.elexis.core.ui.documents.commandUpdate";
    public static final String CMD_DELETE_DOCUMENT = "ch.elexis.core.ui.documents.commandDelete";
    public static final String PARAM_DOC_CATEGORY = "documents.category";
    public static final String PARAM_FILE_PATH = "documents.file.path";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block22: {
            block20: {
                Patient patient = ElexisEventDispatcher.getSelectedPatient();
                if (patient == null || patient.getId() == null) break block20;
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                switch (event.getCommand().getId()) {
                    case "ch.elexis.core.ui.documents.commandCreate": {
                        IDocument document;
                        File file;
                        String category = null;
                        String path = null;
                        if (event.getParameter(PARAM_FILE_PATH) == null) {
                            FileDialog fd = new FileDialog(shell, 4096);
                            path = fd.open();
                        } else {
                            path = event.getParameter(PARAM_FILE_PATH);
                            category = event.getParameter(PARAM_DOC_CATEGORY);
                        }
                        if (path != null && this.validateFile(file = new File(path)) && (document = DocumentStoreServiceHolder.getService().createDocument(null, patient.getId(), path, category)) != null) {
                            return this.openMetaDataDialog(shell, document, file, 1);
                        }
                        break block22;
                    }
                    case "ch.elexis.core.ui.documents.commandUpdate": {
                        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                        if (selection instanceof StructuredSelection && !((StructuredSelection)selection).isEmpty()) {
                            List iDocuments = ((StructuredSelection)selection).toList();
                            for (Object documentToEdit : iDocuments) {
                                if (!(documentToEdit instanceof IDocument)) continue;
                                return this.openMetaDataDialog(shell, (IDocument)documentToEdit, null, 4);
                            }
                        }
                        break block22;
                    }
                    case "ch.elexis.core.ui.documents.commandDelete": {
                        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                        if (selection instanceof StructuredSelection && !((StructuredSelection)selection).isEmpty()) {
                            List iDocuments = ((StructuredSelection)selection).toList();
                            for (Object documentToEdit : iDocuments) {
                                if (!(documentToEdit instanceof IDocument)) continue;
                                this.openDeleteDialog(shell, (IDocument)documentToEdit, 2);
                            }
                        }
                        break block22;
                    }
                }
                break block22;
            }
            SWTHelper.showInfo((String)"Kein Patient ausgew\u00e4hlt", (String)"Bitte w\u00e4hlen Sie einen Patienten aus!");
        }
        return null;
    }

    private boolean validateFile(File file) {
        if (!file.canRead()) {
            SWTHelper.showError((String)Messages.DocumentView_cantReadCaption, (String)MessageFormat.format(Messages.DocumentView_cantReadText, file));
            return false;
        }
        if (file.getName().length() > 255) {
            SWTHelper.showError((String)Messages.DocumentView_cantReadCaption, (String)Messages.DocumentView_fileNameTooLong);
            return false;
        }
        return true;
    }

    private void openDeleteDialog(Shell shell, final IDocument document, final int eventType) {
        if (SWTHelper.askYesNo((String)Messages.DocumentView_reallyDeleteCaption, (String)MessageFormat.format(Messages.DocumentView_reallyDeleteContents, document.getTitle()))) {
            Optional documentPo = DocumentStoreServiceHolder.getService().getPersistenceObject(document);
            if (documentPo.isPresent()) {
                AcquireLockBlockingUi.aquireAndRun((Identifiable)((Identifiable)documentPo.get()), (ILockHandler)new ILockHandler(){

                    public void lockFailed() {
                    }

                    public void lockAcquired() {
                        DocumentStoreServiceHolder.getService().removeDocument(document);
                        ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((Object)document, IDocument.class, eventType, 10000)});
                    }
                });
            } else {
                DocumentStoreServiceHolder.getService().removeDocument(document);
                ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((Object)document, IDocument.class, eventType, 10000)});
            }
        }
    }

    private Optional<IDocument> openMetaDataDialog(final Shell shell, final IDocument document, final File file, final int eventType) {
        if (eventType == 1) {
            Optional<IDocument> newDocument = this.openMetaDataDialogNoLocking(shell, document, file, eventType);
            newDocument.ifPresent(doc -> {
                Optional documentPo = DocumentStoreServiceHolder.getService().getPersistenceObject(doc);
                documentPo.ifPresent(po -> {
                    LocalLockServiceHolder.get().acquireLock(po);
                    LocalLockServiceHolder.get().releaseLock(po);
                });
            });
            return newDocument;
        }
        Optional documentPo = DocumentStoreServiceHolder.getService().getPersistenceObject(document);
        if (!documentPo.isPresent()) {
            return this.openMetaDataDialogNoLocking(shell, document, file, eventType);
        }
        AcquireLockBlockingUi.aquireAndRun((Identifiable)((Identifiable)documentPo.get()), (ILockHandler)new ILockHandler(){

            public void lockFailed() {
            }

            public void lockAcquired() {
                DocumentCrudHandler.this.openMetaDataDialogNoLocking(shell, document, file, eventType);
            }
        });
        return Optional.empty();
    }

    private Optional<IDocument> openMetaDataDialogNoLocking(Shell shell, IDocument document, File file, int eventType) {
        DocumentsMetaDataDialog documentsMetaDataDialog = new DocumentsMetaDataDialog(document, shell);
        if (documentsMetaDataDialog.open() == 0 && file != null) {
            try {
                Throwable throwable = null;
                Object var7_10 = null;
                try (FileInputStream fin = new FileInputStream(file);){
                    IDocument savedDocument = DocumentStoreServiceHolder.getService().saveDocument(document, (InputStream)fin);
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((Object)savedDocument, IDocument.class, eventType, 10000)});
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)document);
                    return Optional.of(savedDocument);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                logger.error("file not found", (Throwable)e);
                SWTHelper.showError((String)Messages.DocumentView_importErrorCaption, (String)Messages.DocumentView_importErrorText2);
            }
            catch (ElexisException e) {
                logger.error("cannot save", (Throwable)e);
                SWTHelper.showError((String)Messages.DocumentView_saveErrorCaption, (String)Messages.DocumentView_saveErrorText);
            }
        }
        return Optional.empty();
    }
}

