/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging.slf4j;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jSessionLogger
extends AbstractSessionLog {
    public static final String ECLIPSELINK_NAMESPACE = "org.eclipse.persistence.logging";
    public static final String DEFAULT_CATEGORY = "default";
    public static final String DEFAULT_ECLIPSELINK_NAMESPACE = "org.eclipse.persistence.logging.default";
    private static Map<Integer, LogLevel> MAP_LEVELS = new HashMap<Integer, LogLevel>();
    private Map<String, Logger> categoryLoggers = new HashMap<String, Logger>();

    static {
        MAP_LEVELS.put(0, LogLevel.TRACE);
        MAP_LEVELS.put(1, LogLevel.TRACE);
        MAP_LEVELS.put(2, LogLevel.TRACE);
        MAP_LEVELS.put(3, LogLevel.DEBUG);
        MAP_LEVELS.put(4, LogLevel.INFO);
        MAP_LEVELS.put(5, LogLevel.INFO);
        MAP_LEVELS.put(6, LogLevel.WARN);
        MAP_LEVELS.put(7, LogLevel.ERROR);
    }

    public Slf4jSessionLogger() {
        this.createCategoryLoggers();
    }

    public void log(SessionLogEntry entry) {
        if (!this.shouldLog(entry.getLevel(), entry.getNameSpace())) {
            return;
        }
        Logger logger = this.getLogger(entry.getNameSpace());
        LogLevel logLevel = this.getLogLevel(entry.getLevel());
        StringBuilder message = new StringBuilder();
        message.append(this.getSupplementDetailString(entry));
        message.append(this.formatMessage(entry));
        switch (logLevel) {
            case TRACE: {
                logger.trace(message.toString());
                break;
            }
            case DEBUG: {
                logger.debug(message.toString());
                break;
            }
            case INFO: {
                logger.info(message.toString());
                break;
            }
            case WARN: {
                logger.warn(message.toString());
                break;
            }
            case ERROR: {
                logger.error(message.toString());
                break;
            }
        }
    }

    public boolean shouldLog(int level, String category) {
        Logger logger = this.getLogger(category);
        LogLevel logLevel = this.getLogLevel(level);
        switch (logLevel) {
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
            case ERROR: {
                return logger.isErrorEnabled();
            }
        }
        return true;
    }

    public boolean shouldLog(int level) {
        return this.shouldLog(level, DEFAULT_CATEGORY);
    }

    public boolean shouldDisplayData() {
        if (this.shouldDisplayData != null) {
            return this.shouldDisplayData;
        }
        return false;
    }

    private void createCategoryLoggers() {
        String[] stringArray = SessionLog.loggerCatagories;
        int n = SessionLog.loggerCatagories.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            this.addLogger(category, "org.eclipse.persistence.logging." + category);
            ++n2;
        }
        this.addLogger(DEFAULT_CATEGORY, DEFAULT_ECLIPSELINK_NAMESPACE);
    }

    private void addLogger(String loggerCategory, String loggerNameSpace) {
        this.categoryLoggers.put(loggerCategory, LoggerFactory.getLogger((String)loggerNameSpace));
    }

    private Logger getLogger(String category) {
        if (!Slf4jSessionLogger.hasText(category) || !this.categoryLoggers.containsKey(category)) {
            category = DEFAULT_CATEGORY;
        }
        return this.categoryLoggers.get(category);
    }

    private LogLevel getLogLevel(Integer level) {
        LogLevel logLevel = MAP_LEVELS.get(level);
        if (logLevel == null) {
            logLevel = LogLevel.OFF;
        }
        return logLevel;
    }

    public static boolean hasText(String str) {
        return str != null;
    }

    static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        OFF;

    }
}

