/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.views.nattable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;

public class NatTableWrapper
implements ISelectionProvider {
    private NatTable natTable;
    private IDataProvider dataProvider;
    private SelectionLayer selectionLayer;
    private List<Object> currentSelection = new ArrayList<Object>();
    private ListenerList<IDoubleClickListener> doubleClickListeners = new ListenerList();
    private ListenerList<ISelectionChangedListener> selectionListener = new ListenerList();

    public NatTableWrapper(NatTable natTable, IDataProvider dataProvider, SelectionLayer selectionLayer) {
        this.natTable = natTable;
        this.dataProvider = dataProvider;
        this.selectionLayer = selectionLayer;
    }

    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public IDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public boolean isDisposed() {
        return this.natTable == null || this.natTable.isDisposed();
    }

    public void configure() {
        this.natTable.addLayerListener(new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof CellSelectionEvent) {
                    Object[] listeners;
                    NatTableWrapper.this.currentSelection.clear();
                    CellSelectionEvent cellEvent = (CellSelectionEvent)event;
                    Collection cells = cellEvent.getSelectionLayer().getSelectedCells();
                    for (ILayerCell iLayerCell : cells) {
                        Object selectedObj = NatTableWrapper.this.dataProvider.getDataValue(iLayerCell.getColumnIndex(), iLayerCell.getRowIndex());
                        if (!(selectedObj instanceof List)) continue;
                        NatTableWrapper.this.currentSelection.addAll((List)selectedObj);
                    }
                    Object[] objectArray = listeners = NatTableWrapper.this.selectionListener.getListeners();
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        ((ISelectionChangedListener)object).selectionChanged(new SelectionChangedEvent((ISelectionProvider)NatTableWrapper.this, (ISelection)new StructuredSelection(NatTableWrapper.this.currentSelection)));
                        ++n2;
                    }
                }
            }
        });
        this.natTable.addConfiguration((IConfiguration)new AbstractUiBindingConfiguration(){

            public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                uiBindingRegistry.registerDoubleClickBinding((IMouseEventMatcher)new MouseEventMatcher(0, "BODY", 1), (IMouseAction)new DblClickMouseAction());
            }

            class DblClickMouseAction
            implements IMouseAction {
                DblClickMouseAction() {
                }

                public void run(NatTable natTable, MouseEvent event) {
                    if (NatTableWrapper.this.currentSelection != null) {
                        Object[] listeners;
                        Object[] objectArray = listeners = NatTableWrapper.this.doubleClickListeners.getListeners();
                        int n = listeners.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            ((IDoubleClickListener)object).doubleClick(NatTableWrapper.this, NatTableWrapper.this.getSelection());
                            ++n2;
                        }
                    }
                }
            }
        });
        this.natTable.configure();
    }

    public NatTable getNatTable() {
        return this.natTable;
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.doubleClickListeners.add((Object)listener);
    }

    public void removeDoubleClickListener(IDoubleClickListener listener) {
        this.doubleClickListeners.remove((Object)listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListener.add((Object)listener);
    }

    public ISelection getSelection() {
        if (!this.currentSelection.isEmpty()) {
            return new StructuredSelection(this.currentSelection);
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListener.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
    }

    public void addContextMenu(String string, IWorkbenchPartSite iWorkbenchPartSite) {
        MenuManager mgr = new MenuManager();
        final Menu popupmenu = new PopupMenuBuilder(this.natTable, mgr).build();
        iWorkbenchPartSite.registerContextMenu(string, mgr, null);
        this.natTable.addConfiguration((IConfiguration)new AbstractUiBindingConfiguration(){

            public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, null, 3), (IMouseAction)new PopupMenuAction(popupmenu));
            }
        });
    }

    public static interface IDoubleClickListener {
        public void doubleClick(NatTableWrapper var1, ISelection var2);
    }
}

