/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.pdfbox.ui.parts;

import ch.elexis.core.pdfbox.ui.parts.PdfPreviewPartLoadHandler;
import ch.elexis.core.services.IConfigService;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PdfPreviewPart {
    @Inject
    private IConfigService configService;
    private Composite previewComposite;
    private ScrolledComposite scrolledComposite;
    private PdfPreviewPartLoadHandler pdfPreviewPartLoadHandler;

    @PostConstruct
    public void postConstruct(Composite parent) throws IOException {
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.previewComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)this.previewComposite);
        this.previewComposite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(this.previewComposite, 0);
        label.setText("Kein PDF selektiert");
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setMinSize(this.previewComposite.computeSize(-1, -1));
    }

    @Inject
    @Optional
    void updatePreview(@UIEventTopic(value="ui/preview/mimetype/application/pdf") InputStream pdfInputStream) {
        if (this.pdfPreviewPartLoadHandler != null) {
            this.pdfPreviewPartLoadHandler.close();
        }
        String zoomLevel = this.configService.getActiveUserContact("pdfPreviewPart/defaultZoomLevel", "1.2f");
        this.pdfPreviewPartLoadHandler = new PdfPreviewPartLoadHandler(pdfInputStream, new Float(zoomLevel), this.previewComposite, this.scrolledComposite);
    }

    public void changeScalingFactor(Float _zoomLevel) {
        this.pdfPreviewPartLoadHandler.changeScalingFactor(_zoomLevel);
    }
}

