/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.templates.ui.dlg;

import ch.elexis.core.findings.templates.model.FindingsTemplate;
import ch.elexis.core.findings.templates.model.FindingsTemplates;
import ch.elexis.core.findings.templates.model.InputDataGroup;
import ch.elexis.core.findings.templates.model.InputDataGroupComponent;
import ch.elexis.core.findings.templates.ui.util.FindingsTemplateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class FindingsSelectionDialog
extends TitleAreaDialog {
    private final FindingsTemplates model;
    private List<FindingsTemplate> selections;
    private TableViewer viewer;
    private boolean multiSelection;
    private FindingsTemplate current;
    private boolean dndReordering;

    public FindingsSelectionDialog(Shell parentShell, FindingsTemplates model, List<FindingsTemplate> selections, boolean multiSelection, FindingsTemplate current, boolean dndReordering) {
        super(parentShell);
        this.setShellStyle(16);
        this.model = model;
        this.current = current;
        this.selections = selections;
        this.multiSelection = multiSelection;
        this.dndReordering = dndReordering;
    }

    protected Control createDialogArea(Composite parent) {
        StringBuilder message = new StringBuilder();
        if (this.multiSelection) {
            message.append("W\u00e4hlen Sie Vorlagen aus");
        } else {
            message.append("W\u00e4hlen Sie eine Vorlage aus");
        }
        if (this.dndReordering) {
            message.append("\nDie Reihenfolge des Auswahls kann per Drag & Drop ge\u00e4ndert werden.");
        }
        this.setMessage(message.toString());
        this.setTitle("Befund Vorlage");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        BasicEList eTemplates = ECollections.newBasicEList();
        this.viewer = new TableViewer(composite, 0x10800 | (this.multiSelection ? 2 : 4));
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof FindingsTemplate) {
                    return ((FindingsTemplate)element).getTitle();
                }
                return "";
            }

            public Image getImage(Object object) {
                Image img = FindingsTemplateUtil.getImage(object);
                return img != null ? img : super.getImage(object);
            }
        });
        this.viewer.setComparer(new IElementComparer(){

            public int hashCode(Object element) {
                return element.hashCode();
            }

            public boolean equals(Object a, Object b) {
                if (a.equals(b)) {
                    return true;
                }
                if (a instanceof FindingsTemplate && b instanceof FindingsTemplate) {
                    FindingsTemplate findingsTemplate1 = (FindingsTemplate)a;
                    FindingsTemplate findingsTemplate2 = (FindingsTemplate)b;
                    return StringUtils.equals((CharSequence)findingsTemplate1.getTitle(), (CharSequence)findingsTemplate2.getTitle());
                }
                return false;
            }
        });
        if (this.dndReordering) {
            Transfer[] dragTransferTypes = new Transfer[]{TextTransfer.getInstance()};
            this.viewer.addDragSupport(2, dragTransferTypes, (DragSourceListener)new DragSourceAdapter(){

                public void dragSetData(DragSourceEvent event) {
                    Object item;
                    IStructuredSelection selection = (IStructuredSelection)FindingsSelectionDialog.this.viewer.getSelection();
                    if (selection != null && !selection.isEmpty() && (item = selection.getFirstElement()) instanceof FindingsTemplate) {
                        FindingsTemplate findingsTemplate = (FindingsTemplate)selection.getFirstElement();
                        event.data = findingsTemplate.getTitle();
                    }
                }
            });
            this.viewer.addDropSupport(2, dragTransferTypes, (DropTargetListener)new DropTargetAdapter((EList)eTemplates){
                private final /* synthetic */ EList val$eTemplates;
                {
                    this.val$eTemplates = eList;
                }

                public void dragEnter(DropTargetEvent event) {
                    event.detail = 2;
                }

                public void drop(DropTargetEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)FindingsSelectionDialog.this.viewer.getSelection();
                    TableItem tableItem = (TableItem)event.item;
                    if (tableItem != null) {
                        FindingsTemplate findingsTemplate;
                        int idx = FindingsSelectionDialog.this.viewer.getTable().indexOf(tableItem);
                        if (selection != null && !selection.isEmpty() && (findingsTemplate = (FindingsTemplate)selection.getFirstElement()) != null && this.val$eTemplates.remove((Object)findingsTemplate)) {
                            this.val$eTemplates.add(idx, (Object)findingsTemplate);
                            FindingsSelectionDialog.this.viewer.refresh();
                        }
                    }
                }
            });
        }
        Object templatesTemp = null;
        if (this.current != null) {
            if (this.current.getInputData() instanceof InputDataGroupComponent) {
                templatesTemp = this.model.getFindingsTemplates().stream().filter(item -> !(item.getInputData() instanceof InputDataGroup) && !(item.getInputData() instanceof InputDataGroupComponent)).collect(Collectors.toList());
                for (FindingsTemplate findingsTemplate : ((InputDataGroupComponent)this.current.getInputData()).getFindingsTemplates()) {
                    if (templatesTemp.contains(findingsTemplate)) continue;
                    templatesTemp.add(findingsTemplate);
                }
            } else {
                templatesTemp = this.model.getFindingsTemplates().stream().filter(item -> !item.equals(this.current)).collect(Collectors.toList());
            }
        } else {
            templatesTemp = this.model.getFindingsTemplates();
        }
        if (templatesTemp != null) {
            eTemplates.addAll((Collection)templatesTemp);
            ECollections.sort((EList)eTemplates, (l, r) -> {
                if (l == null || r == null) {
                    return l != null ? 1 : -1;
                }
                int titleCompare = ObjectUtils.compare((Comparable)((Object)l.getTitle().toLowerCase()), (Comparable)((Object)r.getTitle().toLowerCase()));
                if ((l.getInputData() instanceof InputDataGroup || r.getInputData() instanceof InputDataGroup) && l.getInputData().getClass() != r.getInputData().getClass()) {
                    return l.getInputData() instanceof InputDataGroup ? -1 : 1;
                }
                if ((l.getInputData() instanceof InputDataGroupComponent || r.getInputData() instanceof InputDataGroupComponent) && l.getInputData().getClass() != r.getInputData().getClass()) {
                    return l.getInputData() instanceof InputDataGroupComponent ? -1 : 1;
                }
                return titleCompare;
            });
        }
        this.viewer.setInput((Object)eTemplates);
        this.viewer.setSelection((ISelection)new StructuredSelection(this.selections));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selectedObj;
                StructuredSelection selection = (StructuredSelection)FindingsSelectionDialog.this.viewer.getSelection();
                if (!selection.isEmpty() && (selectedObj = selection.getFirstElement()) instanceof FindingsTemplate) {
                    FindingsSelectionDialog.this.selections = new ArrayList();
                    FindingsSelectionDialog.this.selections.add((FindingsTemplate)selectedObj);
                    FindingsSelectionDialog.this.close();
                }
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.selections = new ArrayList<FindingsTemplate>();
        StructuredSelection structuredSelection = (StructuredSelection)this.viewer.getSelection();
        Object[] objectArray = structuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof FindingsTemplate) {
                this.selections.add((FindingsTemplate)o);
            }
            ++n2;
        }
        super.okPressed();
    }

    public List<FindingsTemplate> getSelection() {
        if (this.selections == null) {
            this.selections = Collections.emptyList();
        }
        return this.selections;
    }

    public FindingsTemplate getSingleSelection() {
        List<FindingsTemplate> findingsTemplates = this.getSelection();
        if (findingsTemplates.size() > 0) {
            return findingsTemplates.get(0);
        }
        return null;
    }
}

