/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.equals;

import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsImplementationRegistry;
import com.phloc.commons.state.ETriState;
import com.phloc.commons.state.ITriState;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class EqualsUtils {
    private static final EqualsUtils s_aInstance = new EqualsUtils();

    private EqualsUtils() {
    }

    public static boolean equals(boolean bl, boolean bl2) {
        return bl == bl2;
    }

    public static boolean equals(byte by, byte by2) {
        return by == by2;
    }

    public static boolean equals(char c, char c2) {
        return c == c2;
    }

    public static boolean equals(double d, double d2) {
        return d == d2 || Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static boolean equals(float f, float f2) {
        return f == f2 || Float.floatToIntBits(f) == Float.floatToIntBits(f2);
    }

    public static boolean equals(int n, int n2) {
        return n == n2;
    }

    public static boolean equals(long l, long l2) {
        return l == l2;
    }

    public static boolean equals(short s, short s2) {
        return s == s2;
    }

    public static boolean equals(@Nullable Object object, @Nullable Object object2) {
        return EqualsImplementationRegistry.areEqual(object, object2);
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
    public static boolean nullSafeEqualsIgnoreCase(@Nullable String string, @Nullable String string2) {
        return string == null ? string2 == null : string.equalsIgnoreCase(string2);
    }

    @Nonnull
    public static ITriState equalsTrivial(@Nonnull Object object, @Nullable Object object2) {
        if (object == null) {
            throw new NullPointerException("aThis");
        }
        if (object2 == object) {
            return ETriState.TRUE;
        }
        if (object2 == null || !object.getClass().equals(object2.getClass())) {
            return ETriState.FALSE;
        }
        return ETriState.UNDEFINED;
    }

    public static boolean equals(@Nullable Collection<?> collection, @Nullable Collection<?> collection2) {
        boolean bl;
        boolean bl2 = ContainerHelper.isEmpty(collection);
        if (bl2 != (bl = ContainerHelper.isEmpty(collection2))) {
            return false;
        }
        if (!bl2) {
            return ContainerHelper.getDifference(collection, collection2).isEmpty() && ContainerHelper.getDifference(collection2, collection).isEmpty();
        }
        return true;
    }
}

