/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.model.service;

import ch.elexis.core.findings.IAllergyIntolerance;
import ch.elexis.core.findings.IClinicalImpression;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IDocumentReference;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFamilyMemberHistory;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.IProcedureRequest;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class FindingsService
implements IFindingsService {
    @Reference(target="(service.model.name=ch.elexis.core.findings.model)")
    private IModelService findingsModelService;

    public <T extends IFinding> List<T> getPatientsFindings(String patientId, Class<T> filter) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (patientId != null && !patientId.isEmpty()) {
            if (filter.isAssignableFrom(IEncounter.class)) {
                ret.addAll(this.queryByPatientId(patientId, IEncounter.class));
            }
            if (filter.isAssignableFrom(ICondition.class)) {
                ret.addAll(this.queryByPatientId(patientId, ICondition.class));
            }
            if (filter.isAssignableFrom(IClinicalImpression.class)) {
                ret.addAll(this.queryByPatientId(patientId, IClinicalImpression.class));
            }
            if (filter.isAssignableFrom(IObservation.class)) {
                ret.addAll(this.queryByPatientId(patientId, IObservation.class));
            }
            if (filter.isAssignableFrom(IProcedureRequest.class)) {
                ret.addAll(this.queryByPatientId(patientId, IProcedureRequest.class));
            }
            if (filter.isAssignableFrom(IFamilyMemberHistory.class)) {
                ret.addAll(this.queryByPatientId(patientId, IFamilyMemberHistory.class));
            }
            if (filter.isAssignableFrom(IAllergyIntolerance.class)) {
                ret.addAll(this.queryByPatientId(patientId, IAllergyIntolerance.class));
            }
        }
        return ret;
    }

    private <T> List<T> queryByPatientId(String patientId, Class<T> clazz) {
        if (patientId != null) {
            INamedQuery query = this.findingsModelService.getNamedQuery(clazz, new String[]{"patientid"});
            return query.executeWithParameters(query.getParameterMap(new Object[]{"patientid", patientId}));
        }
        return Collections.emptyList();
    }

    private Optional<IEncounter> getEncounter(String consultationId) {
        INamedQuery query = this.findingsModelService.getNamedQuery(IEncounter.class, new String[]{"consultationid"});
        List encounters = query.executeWithParameters(query.getParameterMap(new Object[]{"consultationid", consultationId}));
        if (!encounters.isEmpty()) {
            if (encounters.size() > 1) {
                LoggerFactory.getLogger(this.getClass()).warn("Got more than one encounter for consultation id [" + consultationId + "] using first");
            }
            return Optional.of((IEncounter)encounters.get(0));
        }
        return Optional.empty();
    }

    public <T extends IFinding> List<T> getConsultationsFindings(String consultationId, Class<T> filter) {
        Optional<IEncounter> encounter;
        ArrayList<Object> ret = new ArrayList<Object>();
        if (consultationId != null && !consultationId.isEmpty() && (encounter = this.getEncounter(consultationId)).isPresent()) {
            if (filter.isAssignableFrom(IEncounter.class)) {
                ret.add((IFinding)encounter.get());
            }
            if (filter.isAssignableFrom(IClinicalImpression.class)) {
                ret.addAll(this.queryByEncounterId(encounter.get().getId(), IClinicalImpression.class));
            }
            if (filter.isAssignableFrom(IObservation.class)) {
                ret.addAll(this.queryByEncounterId(encounter.get().getId(), IObservation.class));
            }
            if (filter.isAssignableFrom(IProcedureRequest.class)) {
                ret.addAll(this.queryByEncounterId(encounter.get().getId(), IProcedureRequest.class));
            }
        }
        return ret;
    }

    private <T> List<T> queryByEncounterId(String consultationId, Class<T> clazz) {
        if (consultationId != null) {
            INamedQuery query = this.findingsModelService.getNamedQuery(clazz, new String[]{"encounterid"});
            return query.executeWithParameters(query.getParameterMap(new Object[]{"encounterid", consultationId}));
        }
        return Collections.emptyList();
    }

    public boolean saveFinding(IFinding finding) {
        return this.findingsModelService.save((Identifiable)finding);
    }

    public void deleteFinding(IFinding finding) {
        this.findingsModelService.delete((Deleteable)finding);
    }

    public <T extends IFinding> T create(Class<T> type) {
        IFinding created = (IFinding)this.findingsModelService.create(type);
        ModelUtil.initFhir((IFinding)created, type);
        return (T)created;
    }

    public <T extends IFinding> Optional<T> findById(String id, Class<T> clazz, boolean skipChecks) {
        return this.findingsModelService.load(id, clazz, skipChecks);
    }

    public <T extends IFinding> List<T> getDocumentFindings(String documentid, Class<T> filter) {
        if (filter.isAssignableFrom(IDocumentReference.class)) {
            INamedQuery query = this.findingsModelService.getNamedQuery(filter, new String[]{"documentid"});
            return query.executeWithParameters(query.getParameterMap(new Object[]{"documentid", documentid}));
        }
        return Collections.emptyList();
    }
}

