/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.model;

import ca.uhn.fhir.model.primitive.IdDt;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IProcedureRequest;
import ch.elexis.core.findings.fhir.model.AbstractFindingModelAdapter;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.model.IXid;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.LoggerFactory;

public class ProcedureRequest
extends AbstractFindingModelAdapter<ch.elexis.core.jpa.entities.ProcedureRequest>
implements IProcedureRequest {
    public ProcedureRequest(ch.elexis.core.jpa.entities.ProcedureRequest entity) {
        super(entity);
    }

    public String getPatientId() {
        return ((ch.elexis.core.jpa.entities.ProcedureRequest)this.getEntity()).getPatientId();
    }

    public void setPatientId(String patientId) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            org.hl7.fhir.dstu3.model.ProcedureRequest fhirProcedureRequest = (org.hl7.fhir.dstu3.model.ProcedureRequest)resource.get();
            fhirProcedureRequest.setSubject(new Reference((IIdType)new IdDt("Patient", patientId)));
            this.saveResource(resource.get());
        }
        ((ch.elexis.core.jpa.entities.ProcedureRequest)this.getEntity()).setPatientId(patientId);
    }

    public List<ICoding> getCoding() {
        org.hl7.fhir.dstu3.model.ProcedureRequest fhirProcedureRequest;
        CodeableConcept codeableConcept;
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent() && (codeableConcept = (fhirProcedureRequest = (org.hl7.fhir.dstu3.model.ProcedureRequest)resource.get()).getCode()) != null) {
            return ModelUtil.getCodingsFromConcept((CodeableConcept)codeableConcept);
        }
        return Collections.emptyList();
    }

    public void setCoding(List<ICoding> coding) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            org.hl7.fhir.dstu3.model.ProcedureRequest fhirProcedureRequest = (org.hl7.fhir.dstu3.model.ProcedureRequest)resource.get();
            CodeableConcept codeableConcept = fhirProcedureRequest.getCode();
            if (codeableConcept == null) {
                codeableConcept = new CodeableConcept();
            }
            ModelUtil.setCodingsToConcept((CodeableConcept)codeableConcept, coding);
            fhirProcedureRequest.setCode(codeableConcept);
            this.saveResource(resource.get());
        }
    }

    public Optional<IEncounter> getEncounter() {
        String encounterId = ((ch.elexis.core.jpa.entities.ProcedureRequest)this.getEntity()).getEncounterId();
        if (encounterId != null && !encounterId.isEmpty()) {
            return ModelUtil.loadFinding((String)encounterId, IEncounter.class);
        }
        return Optional.empty();
    }

    public void setEncounter(IEncounter encounter) {
        String patientId;
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            org.hl7.fhir.dstu3.model.ProcedureRequest fhirProcedureRequest = (org.hl7.fhir.dstu3.model.ProcedureRequest)resource.get();
            fhirProcedureRequest.setContext(new Reference((IIdType)new IdDt("Encounter", encounter.getId())));
            this.saveResource(resource.get());
        }
        if ((patientId = encounter.getPatientId()) != null && !patientId.isEmpty() && this.getPatientId() == null) {
            this.setPatientId(patientId);
        }
        ((ch.elexis.core.jpa.entities.ProcedureRequest)this.getEntity()).setEncounterId(encounter.getId());
    }

    public Optional<LocalDateTime> getScheduledTime() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            org.hl7.fhir.dstu3.model.ProcedureRequest fhirProcedureRequest = (org.hl7.fhir.dstu3.model.ProcedureRequest)resource.get();
            try {
                if (fhirProcedureRequest.hasOccurrence()) {
                    return Optional.of(this.getLocalDateTime((Date)fhirProcedureRequest.getOccurrenceDateTimeType().getValue()));
                }
            }
            catch (FHIRException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Could not access scheduled time.", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public void setScheduledTime(LocalDateTime time) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            org.hl7.fhir.dstu3.model.ProcedureRequest fhirProcedureRequest = (org.hl7.fhir.dstu3.model.ProcedureRequest)resource.get();
            fhirProcedureRequest.setOccurrence((Type)new DateTimeType(this.getDate(time)));
            this.saveResource(resource.get());
        }
    }

    public IFinding.RawContentFormat getRawContentFormat() {
        return IFinding.RawContentFormat.FHIR_JSON;
    }

    public String getRawContent() {
        return ((ch.elexis.core.jpa.entities.ProcedureRequest)this.getEntity()).getContent();
    }

    public void setRawContent(String content) {
        ((ch.elexis.core.jpa.entities.ProcedureRequest)this.getEntity()).setContent(content);
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return false;
    }

    public IXid getXid(String domain) {
        return null;
    }
}

