/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.model;

import ca.uhn.fhir.model.primitive.IdDt;
import ch.elexis.core.findings.IClinicalImpression;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.fhir.model.AbstractFindingModelAdapter;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.model.IXid;
import java.util.Optional;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class ClinicalImpression
extends AbstractFindingModelAdapter<ch.elexis.core.jpa.entities.ClinicalImpression>
implements IClinicalImpression {
    public ClinicalImpression(ch.elexis.core.jpa.entities.ClinicalImpression entity) {
        super(entity);
    }

    public String getPatientId() {
        return ((ch.elexis.core.jpa.entities.ClinicalImpression)this.getEntity()).getPatientid();
    }

    public void setPatientId(String patientId) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            org.hl7.fhir.dstu3.model.ClinicalImpression fhirClinicalImpression = (org.hl7.fhir.dstu3.model.ClinicalImpression)resource.get();
            fhirClinicalImpression.setSubject(new Reference((IIdType)new IdDt("Patient", patientId)));
            this.saveResource(resource.get());
        }
        ((ch.elexis.core.jpa.entities.ClinicalImpression)this.getEntity()).setPatientid(patientId);
    }

    public Optional<IEncounter> getEncounter() {
        String encounterId = ((ch.elexis.core.jpa.entities.ClinicalImpression)this.getEntity()).getEncounterid();
        if (encounterId != null && !encounterId.isEmpty()) {
            return ModelUtil.loadFinding((String)encounterId, IEncounter.class);
        }
        return Optional.empty();
    }

    public void setEncounter(IEncounter encounter) {
        String patientId;
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            org.hl7.fhir.dstu3.model.ClinicalImpression fhirClinicalImpression = (org.hl7.fhir.dstu3.model.ClinicalImpression)resource.get();
            fhirClinicalImpression.setContext(new Reference((IIdType)new IdDt("Encounter", encounter.getId())));
            this.saveResource(resource.get());
        }
        if ((patientId = encounter.getPatientId()) != null && !patientId.isEmpty() && this.getPatientId() == null) {
            this.setPatientId(patientId);
        }
        ((ch.elexis.core.jpa.entities.ClinicalImpression)this.getEntity()).setEncounterid(encounter.getId());
    }

    public IFinding.RawContentFormat getRawContentFormat() {
        return IFinding.RawContentFormat.FHIR_JSON;
    }

    public String getRawContent() {
        return ((ch.elexis.core.jpa.entities.ClinicalImpression)this.getEntity()).getContent();
    }

    public void setRawContent(String content) {
        ((ch.elexis.core.jpa.entities.ClinicalImpression)this.getEntity()).setContent(content);
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return false;
    }

    public IXid getXid(String domain) {
        return null;
    }
}

