/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.handlers;

import ch.elexis.core.mail.MailAccount;
import ch.elexis.core.mail.MailMessage;
import ch.elexis.core.mail.TaskUtil;
import ch.elexis.core.mail.ui.client.MailClientComponent;
import ch.elexis.core.mail.ui.handlers.EncounterUtil;
import ch.elexis.core.mail.ui.handlers.OutboxUtil;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.data.Mandant;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.LoggerFactory;

public class SendMailNoUiHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional taskDescriptor;
        MailAccount mailAccount = null;
        String accountId = event.getParameter("ch.elexis.core.mail.ui.sendMailNoUi.accountid");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accountId})) {
            mailAccount = MailClientComponent.getMailClient().getAccount(accountId).orElse(null);
        }
        if (mailAccount == null && (mailAccount = this.getMailAccount(event.getParameter("ch.elexis.core.mail.ui.sendMailNoUi.mandant"))) == null) {
            Mandant mandant = Mandant.load((String)event.getParameter("ch.elexis.core.mail.ui.sendMailNoUi.mandant"));
            return "No account for mandant [" + mandant.getLabel(false) + "]";
        }
        String attachments = event.getParameter("ch.elexis.core.mail.ui.sendMailNoUi.attachments");
        String to = event.getParameter("ch.elexis.core.mail.ui.sendMailNoUi.to");
        if (StringUtils.isBlank((CharSequence)to)) {
            return "No to address";
        }
        String subject = event.getParameter("ch.elexis.core.mail.ui.sendMailNoUi.subject");
        String text = event.getParameter("ch.elexis.core.mail.ui.sendMailNoUi.text");
        MailMessage message = new MailMessage().to(to).subject(StringUtils.defaultString((String)subject)).text(StringUtils.defaultString((String)text));
        if (attachments != null && !attachments.isEmpty()) {
            message.setAttachments(attachments);
        }
        if ((taskDescriptor = TaskUtil.createSendMailTaskDescriptor((String)mailAccount.getId(), (MailMessage)message)).isPresent()) {
            block8: {
                ITask task = TaskUtil.executeTaskSync((ITaskDescriptor)((ITaskDescriptor)taskDescriptor.get()), (IProgressMonitor)new NullProgressMonitor());
                if (!task.isSucceeded()) break block8;
                OutboxUtil.getOrCreateElement((ITaskDescriptor)taskDescriptor.get(), true);
                EncounterUtil.addMailToEncounter((ITaskDescriptor)taskDescriptor.get());
                return null;
            }
            try {
                return MailClientComponent.getLastErrorMessage();
            }
            catch (TaskException e) {
                LoggerFactory.getLogger(TaskUtil.class).error("Error executing mail task", (Throwable)e);
            }
        }
        return "Error executing mail task";
    }

    private MailAccount getMailAccount(String mandantId) {
        List accounts = MailClientComponent.getMailClient().getAccounts();
        for (String string : accounts) {
            Optional account = MailClientComponent.getMailClient().getAccount(string);
            if (!account.isPresent() || ((MailAccount)account.get()).getType() != MailAccount.TYPE.SMTP || !((MailAccount)account.get()).isForMandant(mandantId)) continue;
            return (MailAccount)account.get();
        }
        return null;
    }
}

