/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.io;

import ch.rgw.io.Settings;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.JdbcLinkExceptionTranslation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSettings
extends Settings {
    private static final Logger logger = LoggerFactory.getLogger(SqlSettings.class);
    private static final long serialVersionUID = 7848755852540263456L;
    volatile JdbcLink j;
    volatile String tbl;
    volatile String constraint = null;
    volatile String paramColumn = "param";
    volatile String valueColumn = "wert";
    private static final String LASTUPDATE_COLUMN = "lastupdate";
    private HashMap<String, Long> lastUpdateMap = new HashMap();

    public static final String Version() {
        return "1.2.0";
    }

    public SqlSettings(JdbcLink j, String tablename, String paramColumn, String valueColumn, String constraint) {
        this.j = j;
        this.tbl = tablename;
        this.constraint = constraint;
        this.paramColumn = paramColumn;
        this.valueColumn = valueColumn;
        this.undo();
    }

    public SqlSettings(JdbcLink j, String tablename) {
        this.j = j;
        this.tbl = tablename;
        this.undo();
    }

    @Override
    public void remove(String key) {
        super.remove(key);
        JdbcLink.Stm stm = this.j.getStatement();
        StringBuilder sql = new StringBuilder(300);
        sql.append("DELETE FROM ").append(this.tbl).append(" WHERE ");
        if (this.constraint != null) {
            sql.append(this.constraint).append(" AND ");
        }
        sql.append(this.paramColumn).append(" LIKE ").append(JdbcLink.wrap(String.valueOf(key) + "%"));
        stm.exec(sql.toString());
        this.j.releaseStatement(stm);
    }

    @Override
    protected void flush_absolute() {
        Iterator<String> it = this.iterator();
        PreparedStatement selectStatement = null;
        PreparedStatement deleteStatement = null;
        PreparedStatement updateStatement = null;
        PreparedStatement insertStatement = null;
        try {
            try {
                String[] constraintParts;
                String constraintKey = null;
                String constraintValue = null;
                if (this.constraint != null && (constraintParts = this.constraint.split("=")).length == 2) {
                    constraintKey = this.unwrap(constraintParts[0]);
                    constraintValue = this.unwrap(constraintParts[1]);
                }
                StringBuilder sql = new StringBuilder(300);
                sql.append("SELECT ").append(this.valueColumn).append(" FROM ").append(this.tbl).append(" WHERE ");
                sql.append(this.paramColumn).append("= ?");
                if (constraintKey != null && constraintValue != null) {
                    sql.append(" AND ").append(constraintKey).append("= ?");
                }
                selectStatement = this.j.getPreparedStatement(sql.toString());
                sql = new StringBuilder(200);
                sql.append("DELETE FROM ").append(this.tbl).append(" WHERE ");
                sql.append(this.paramColumn).append("= ?");
                if (constraintKey != null && constraintValue != null) {
                    sql.append(" AND ").append(constraintKey).append("= ?");
                }
                deleteStatement = this.j.getPreparedStatement(sql.toString());
                sql = new StringBuilder(200);
                sql.append("UPDATE ").append(this.tbl).append(" SET ").append(this.valueColumn).append("= ?,").append(LASTUPDATE_COLUMN).append("= ?").append(" WHERE ");
                sql.append(this.paramColumn).append("= ?");
                if (constraintKey != null && constraintValue != null) {
                    sql.append(" AND ").append(constraintKey).append("= ?");
                }
                updateStatement = this.j.getPreparedStatement(sql.toString());
                sql = new StringBuilder(200);
                sql.append("INSERT INTO ").append(this.tbl).append("(").append(this.paramColumn).append(",").append(this.valueColumn).append(",").append(LASTUPDATE_COLUMN);
                if (constraintKey != null && constraintValue != null) {
                    sql.append(",").append(constraintKey);
                }
                sql.append(") VALUES (").append("?").append(",").append("?").append(",").append("?");
                if (constraintKey != null && constraintValue != null) {
                    sql.append(",?");
                }
                sql.append(")");
                insertStatement = this.j.getPreparedStatement(sql.toString());
                long timestamp = System.currentTimeMillis();
                while (it.hasNext()) {
                    ResultSet res;
                    String parameterName = it.next();
                    String parameterValue = this.get(parameterName, null);
                    selectStatement.setString(1, parameterName);
                    if (constraintKey != null && constraintValue != null) {
                        selectStatement.setString(2, constraintValue);
                    }
                    if ((res = selectStatement.executeQuery()).next()) {
                        String existingValue = res.getString(1);
                        if (existingValue != null && !existingValue.equals(parameterValue)) {
                            if (this.lastUpdateChanged(parameterName)) {
                                logger.warn("Did not flush parameter [" + parameterName + "] because it was changed. Timestamp local (" + this.getLastUpdate(parameterName) + ") db (" + this.getSqlLastUpdate(parameterName) + ")");
                                continue;
                            }
                            if (parameterValue == null) {
                                deleteStatement.setString(1, parameterName);
                                if (constraintKey != null && constraintValue != null) {
                                    deleteStatement.setString(2, constraintValue);
                                }
                                if (this.getSettingChangedListener() != null) {
                                    this.getSettingChangedListener().settingRemoved(parameterName);
                                }
                                deleteStatement.executeUpdate();
                            } else {
                                updateStatement.setString(1, parameterValue);
                                updateStatement.setLong(2, timestamp);
                                updateStatement.setString(3, parameterName);
                                if (constraintKey != null && constraintValue != null) {
                                    updateStatement.setString(4, constraintValue);
                                }
                                updateStatement.executeUpdate();
                                if (this.getSettingChangedListener() != null) {
                                    this.getSettingChangedListener().settingWritten(parameterName, parameterValue);
                                }
                                this.setLastUpdate(parameterName, timestamp);
                            }
                        }
                    } else {
                        if (parameterValue == null) continue;
                        insertStatement.setString(1, parameterName);
                        insertStatement.setString(2, parameterValue);
                        insertStatement.setLong(3, timestamp);
                        if (constraintKey != null && constraintValue != null) {
                            insertStatement.setString(4, constraintValue);
                        }
                        insertStatement.executeUpdate();
                        if (this.getSettingChangedListener() != null) {
                            this.getSettingChangedListener().settingWritten(parameterName, parameterValue);
                        }
                        this.setLastUpdate(parameterName, timestamp);
                    }
                    res.close();
                }
            }
            catch (SQLException e) {
                throw JdbcLinkExceptionTranslation.translateException(e);
            }
        }
        catch (Throwable throwable) {
            this.j.releasePreparedStatement(selectStatement);
            this.j.releasePreparedStatement(deleteStatement);
            this.j.releasePreparedStatement(updateStatement);
            this.j.releasePreparedStatement(insertStatement);
            throw throwable;
        }
        this.j.releasePreparedStatement(selectStatement);
        this.j.releasePreparedStatement(deleteStatement);
        this.j.releasePreparedStatement(updateStatement);
        this.j.releasePreparedStatement(insertStatement);
    }

    private String unwrap(String wrapped) {
        if (wrapped.startsWith("'") && wrapped.endsWith("'")) {
            return wrapped.substring(1, wrapped.length() - 1);
        }
        return wrapped;
    }

    @Override
    public void undo() {
        PreparedStatement selectStatement = null;
        try {
            try {
                String[] constraintParts;
                String constraintKey = null;
                String constraintValue = null;
                if (this.constraint != null && (constraintParts = this.constraint.split("=")).length == 2) {
                    constraintKey = this.unwrap(constraintParts[0]);
                    constraintValue = this.unwrap(constraintParts[1]);
                }
                StringBuilder sql = new StringBuilder(300);
                sql.append("SELECT * FROM ").append(this.tbl);
                if (constraintKey != null && constraintValue != null) {
                    sql.append(" WHERE ").append(constraintKey).append("= ?");
                }
                selectStatement = this.j.getPreparedStatement(sql.toString());
                if (constraintKey != null && constraintValue != null) {
                    selectStatement.setString(1, constraintValue);
                }
                ResultSet resultSet = selectStatement.executeQuery();
                while (resultSet != null && resultSet.next()) {
                    String parm = resultSet.getString(this.paramColumn);
                    String val = resultSet.getString(this.valueColumn);
                    long lastUpdate = resultSet.getLong(LASTUPDATE_COLUMN);
                    this.set(parm, val);
                    this.setLastUpdate(parm, lastUpdate != 0L ? lastUpdate : -1L);
                }
                this.cleaned();
            }
            catch (SQLException e) {
                throw JdbcLinkExceptionTranslation.translateException(e);
            }
        }
        catch (Throwable throwable) {
            this.j.releasePreparedStatement(selectStatement);
            throw throwable;
        }
        this.j.releasePreparedStatement(selectStatement);
    }

    private boolean lastUpdateChanged(String param) {
        long sqlLastUpdate;
        long localLastUpdate = this.getLastUpdate(param);
        return localLastUpdate != (sqlLastUpdate = this.getSqlLastUpdate(param));
    }

    private void setLastUpdate(String param, long timestamp) {
        this.lastUpdateMap.put(param, timestamp);
    }

    private long getLastUpdate(String param) {
        Long ret = this.lastUpdateMap.get(param);
        if (ret != null) {
            return ret;
        }
        return -1L;
    }

    private long getSqlLastUpdate(String param) {
        PreparedStatement selectStatement = null;
        try {
            long lastUpdate;
            ResultSet resultSet;
            String[] constraintParts;
            String constraintKey = null;
            String constraintValue = null;
            if (this.constraint != null && (constraintParts = this.constraint.split("=")).length == 2) {
                constraintKey = this.unwrap(constraintParts[0]);
                constraintValue = this.unwrap(constraintParts[1]);
            }
            StringBuilder sql = new StringBuilder(300);
            sql.append("SELECT ").append(LASTUPDATE_COLUMN).append(" FROM ").append(this.tbl).append(" WHERE ").append(this.paramColumn).append("= ?");
            if (constraintKey != null && constraintValue != null) {
                sql.append(" AND ").append(constraintKey).append("= ?");
            }
            selectStatement = this.j.getPreparedStatement(sql.toString());
            selectStatement.setString(1, param);
            if (constraintKey != null && constraintValue != null) {
                selectStatement.setString(2, constraintValue);
            }
            if ((resultSet = selectStatement.executeQuery()) != null && resultSet.next() && (lastUpdate = resultSet.getLong(LASTUPDATE_COLUMN)) != 0L) {
                long l = lastUpdate;
                this.j.releasePreparedStatement(selectStatement);
                return l;
            }
        }
        catch (SQLException e) {
            try {
                throw JdbcLinkExceptionTranslation.translateException(e);
            }
            catch (Throwable throwable) {
                this.j.releasePreparedStatement(selectStatement);
                throw throwable;
            }
        }
        this.j.releasePreparedStatement(selectStatement);
        return -1L;
    }
}

