/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.accessor;

import ca.uhn.fhir.model.primitive.IdDt;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.IdentifierSystem;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.fhir.accessor.AbstractFindingsAccessor;
import ch.elexis.core.findings.util.fhir.accessor.EnumMapping;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Element;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.codesystems.ObservationCategory;
import org.hl7.fhir.instance.model.api.IIdType;

public class ObservationAccessor
extends AbstractFindingsAccessor {
    private EnumMapping categoryMapping = new EnumMapping(ObservationCategory.class, null, IObservation.ObservationCategory.class, null);

    public Optional<LocalDateTime> getEffectiveTime(DomainResource resource) {
        Observation fhirObservation = (Observation)resource;
        Type effective = fhirObservation.getEffective();
        if (effective instanceof DateTimeType) {
            return Optional.of(this.getLocalDateTime((Date)((DateTimeType)effective).getValue()));
        }
        if (effective instanceof Period) {
            Date start = ((Period)effective).getStart();
            if (start != null) {
                return Optional.of(this.getLocalDateTime(start));
            }
            Date end = ((Period)effective).getEnd();
            if (end != null) {
                return Optional.of(this.getLocalDateTime(end));
            }
        }
        return Optional.empty();
    }

    public void setEffectiveTime(DomainResource resource, LocalDateTime time) {
        Observation fhirObservation = (Observation)resource;
        fhirObservation.setEffective((Type)new DateTimeType(this.getDate(time)));
    }

    public IObservation.ObservationCategory getCategory(DomainResource resource) {
        Observation fhirObservation = (Observation)resource;
        if (!fhirObservation.getCategory().isEmpty()) {
            for (CodeableConcept categoryConcept : fhirObservation.getCategory()) {
                List coding = categoryConcept.getCoding();
                for (Coding code : coding) {
                    IObservation.ObservationCategory mappedCategory;
                    if (!(code.getSystem().equals("http://hl7.org/fhir/observation-category") ? (mappedCategory = (IObservation.ObservationCategory)this.categoryMapping.getLocalEnumValueByCode(code.getCode().toUpperCase())) != null : code.getSystem().equals(IdentifierSystem.ELEXIS_SOAP.getSystem()) && (mappedCategory = (IObservation.ObservationCategory)this.categoryMapping.getLocalEnumValueByCode("SOAP_" + code.getCode().toUpperCase())) != null)) continue;
                    return mappedCategory;
                }
            }
        }
        return IObservation.ObservationCategory.UNKNOWN;
    }

    public void setCategory(DomainResource resource, IObservation.ObservationCategory category) {
        Observation fhirObservation = (Observation)resource;
        CodeableConcept categoryCode = new CodeableConcept();
        if (category.name().startsWith("SOAP_")) {
            categoryCode.setCoding(Collections.singletonList(new Coding(IdentifierSystem.ELEXIS_SOAP.getSystem(), category.getCode(), category.getLocalized())));
        } else {
            ObservationCategory fhirCategoryCode = (ObservationCategory)this.categoryMapping.getFhirEnumValueByEnum((Enum<?>)category);
            if (fhirCategoryCode != null) {
                categoryCode.setCoding(Collections.singletonList(new Coding(fhirCategoryCode.getSystem(), fhirCategoryCode.toCode(), fhirCategoryCode.getDisplay())));
            } else {
                throw new IllegalStateException("Unknown observation category " + category);
            }
        }
        if (!categoryCode.getCoding().isEmpty()) {
            fhirObservation.setCategory(Collections.singletonList(categoryCode));
        }
    }

    public List<ICoding> getCoding(DomainResource resource) {
        Observation fhirObservation = (Observation)resource;
        CodeableConcept codeableConcept = fhirObservation.getCode();
        if (codeableConcept != null) {
            return ModelUtil.getCodingsFromConcept(codeableConcept);
        }
        return Collections.emptyList();
    }

    public void setCoding(DomainResource resource, List<ICoding> coding) {
        Observation fhirObservation = (Observation)resource;
        CodeableConcept codeableConcept = fhirObservation.getCode();
        if (codeableConcept == null) {
            codeableConcept = new CodeableConcept();
        }
        ModelUtil.setCodingsToConcept(codeableConcept, coding);
        fhirObservation.setCode(codeableConcept);
    }

    public void setPatientId(DomainResource resource, String patientId) {
        Observation fhirObservation = (Observation)resource;
        fhirObservation.setSubject(new Reference((IIdType)new IdDt("Patient", patientId)));
    }

    public void addComponent(DomainResource resource, ObservationComponent iComponent) {
        Observation fhirObservation = (Observation)resource;
        Observation.ObservationComponentComponent observationComponentComponent = new Observation.ObservationComponentComponent();
        observationComponentComponent.setId(UUID.randomUUID().toString());
        CodeableConcept codeableConcept = observationComponentComponent.getCode();
        if (codeableConcept == null) {
            codeableConcept = new CodeableConcept();
        }
        ModelUtil.setCodingsToConcept(codeableConcept, iComponent.getCoding());
        observationComponentComponent.setCode(codeableConcept);
        this.setExtensions(iComponent, (Element)observationComponentComponent);
        if (iComponent.getStringValue().isPresent()) {
            StringType stringType = new StringType();
            stringType.setValue((Object)((String)iComponent.getStringValue().get()));
            observationComponentComponent.setValue((Type)stringType);
        } else if (iComponent.getNumericValue().isPresent() || iComponent.getNumericValueUnit().isPresent()) {
            Quantity quantity = new Quantity();
            quantity.setValue(iComponent.getNumericValue().isPresent() ? (BigDecimal)iComponent.getNumericValue().get() : null);
            iComponent.getNumericValueUnit().ifPresent(item -> {
                Quantity quantity2 = quantity.setUnit((String)iComponent.getNumericValueUnit().get());
            });
            observationComponentComponent.setValue((Type)quantity);
        }
        fhirObservation.addComponent(observationComponentComponent);
    }

    private void setExtensions(ObservationComponent iComponent, Element observationComponentComponent) {
        for (String url : iComponent.getExtensions().keySet()) {
            Extension extension = new Extension(url);
            extension.setValue((Type)new StringType().setValue((Object)((String)iComponent.getExtensions().get(url))));
            observationComponentComponent.addExtension(extension);
        }
    }

    private Map<String, String> getExtensions(Element observationComponentComponent) {
        List extensions = observationComponentComponent.getExtension();
        return extensions.stream().filter(extension -> extension.getValue() instanceof StringType).collect(Collectors.toMap(extension -> extension.getUrl(), extension -> ((StringType)extension.getValue()).getValueAsString()));
    }

    public List<ObservationComponent> getComponents(DomainResource resource) {
        Observation fhirObservation = (Observation)resource;
        ArrayList<ObservationComponent> components = new ArrayList<ObservationComponent>();
        for (Observation.ObservationComponentComponent o : fhirObservation.getComponent()) {
            ObservationComponent component = new ObservationComponent(o.getId());
            CodeableConcept codeableConcept = o.getCode();
            if (codeableConcept != null) {
                component.setCoding(ModelUtil.getCodingsFromConcept(codeableConcept));
                component.setExtensions(this.getExtensions((Element)o));
                if (o.hasValueQuantity()) {
                    Quantity quantity = (Quantity)o.getValue();
                    component.setNumericValue(quantity.getValue());
                    component.setNumericValueUnit(quantity.getUnit());
                } else if (o.hasValueStringType()) {
                    StringType stringType = (StringType)o.getValue();
                    component.setStringValue((String)stringType.getValue());
                }
            }
            components.add(component);
        }
        return components;
    }

    public void updateComponent(DomainResource resource, ObservationComponent component) {
        Observation fhirObservation = (Observation)resource;
        for (Observation.ObservationComponentComponent o : fhirObservation.getComponent()) {
            if (!component.getId().equals(o.getId())) continue;
            ObservationComponent tmpObservationComponent = new ObservationComponent(null);
            tmpObservationComponent.setExtensions(this.getExtensions((Element)o));
            IObservation.ObservationType observationType = (IObservation.ObservationType)tmpObservationComponent.getTypeFromExtension(IObservation.ObservationType.class);
            if (IObservation.ObservationType.NUMERIC.equals((Object)observationType)) {
                Quantity q = new Quantity();
                if (o.hasValueQuantity()) {
                    q = (Quantity)o.getValue();
                }
                q.setUnit(component.getNumericValueUnit().orElse(""));
                q.setValue((BigDecimal)component.getNumericValue().orElse(null));
                o.setValue((Type)q);
                continue;
            }
            if (!IObservation.ObservationType.TEXT.equals((Object)observationType)) continue;
            StringType stringType = new StringType();
            if (o.hasValueStringType()) {
                stringType = (StringType)o.getValue();
            }
            stringType.setValue((Object)component.getStringValue().orElse(""));
            o.setValue((Type)stringType);
        }
    }

    public void setStringValue(DomainResource resource, String value) {
        Observation fhirObservation = (Observation)resource;
        StringType q = new StringType();
        q.setValue((Object)value);
        fhirObservation.setValue((Type)q);
    }

    public Optional<String> getStringValue(DomainResource resource) {
        StringType value;
        Observation fhirObservation = (Observation)resource;
        if (fhirObservation.hasValueStringType() && (value = (StringType)fhirObservation.getValue()).getValue() != null) {
            return Optional.of((String)value.getValue());
        }
        return Optional.empty();
    }

    public void setBooleanValue(DomainResource resource, Boolean value) {
        Observation fhirObservation = (Observation)resource;
        BooleanType q = new BooleanType();
        q.setValue((Object)value);
        fhirObservation.setValue((Type)q);
    }

    public Optional<Boolean> getBooleanValue(DomainResource resource) {
        BooleanType value;
        Observation fhirObservation = (Observation)resource;
        if (fhirObservation.hasValueBooleanType() && (value = fhirObservation.getValueBooleanType()).getValue() != null) {
            return Optional.of((Boolean)value.getValue());
        }
        return Optional.empty();
    }

    public void setDateTimeValue(DomainResource resource, Date value) {
        Observation fhirObservation = (Observation)resource;
        DateTimeType q = new DateTimeType();
        q.setValue(value);
        fhirObservation.setValue((Type)q);
    }

    public Optional<Date> getDateTimeValue(DomainResource resource) {
        DateTimeType value;
        Observation fhirObservation = (Observation)resource;
        if (fhirObservation.hasValueDateTimeType() && (value = fhirObservation.getValueDateTimeType()).getValue() != null) {
            return Optional.of((Date)value.getValue());
        }
        return Optional.empty();
    }

    public void setNumericValue(DomainResource resource, BigDecimal value, String unit) {
        Observation fhirObservation = (Observation)resource;
        Quantity q = new Quantity();
        q.setUnit(unit);
        q.setValue(value);
        fhirObservation.setValue((Type)q);
    }

    public Optional<BigDecimal> getNumericValue(DomainResource resource) {
        Quantity quantity;
        Observation fhirObservation = (Observation)resource;
        if (fhirObservation.hasValueQuantity() && (quantity = (Quantity)fhirObservation.getValue()).getValue() != null) {
            return Optional.of(quantity.getValue());
        }
        return Optional.empty();
    }

    public Optional<String> getNumericValueUnit(DomainResource resource) {
        Quantity quantity;
        Observation fhirObservation = (Observation)resource;
        if (fhirObservation.hasValueQuantity() && (quantity = (Quantity)fhirObservation.getValue()).getUnit() != null) {
            return Optional.of(quantity.getUnit());
        }
        return Optional.empty();
    }

    public void setComment(DomainResource resource, String comment) {
        Observation fhirObservation = (Observation)resource;
        fhirObservation.setComment(comment);
    }

    public Optional<String> getComment(DomainResource resource) {
        Observation fhirObservation = (Observation)resource;
        if (fhirObservation.hasComment()) {
            return Optional.of(fhirObservation.getComment());
        }
        return Optional.empty();
    }
}

