/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;

public class SessionLoaderException
extends EclipseLinkException {
    public static final int FINAL_EXCEPTION = 9000;
    public static final int UNKNOWN_TAG = 9001;
    public static final int UNABLE_TO_LOAD_PROJECT_CLASS = 9002;
    public static final int UNABLE_TO_PROCESS_TAG = 9003;
    public static final int COULD_NOT_FIND_PROJECT_XML = 9004;
    public static final int FAILED_TO_LOAD_PROJECT_XML = 9005;
    public static final int UNABLE_TO_PARSE_XML = 9006;
    public static final int NON_PARSE_EXCEPTION = 9007;
    public static final int UN_EXPECTED_VALUE_OF_TAG = 9008;
    public static final int UNKNOWN_ATTRIBUTE_OF_TAG = 9009;
    public static final int XML_SCHEMA_PARSING_ERROR = 9010;
    public static final int SERVER_PLATFORM_NO_LONGER_SUPPORTED = 9011;
    public static final int INVALID_SESSION_XML = 9012;
    private Vector<Throwable> exceptionList;

    public SessionLoaderException() {
    }

    protected SessionLoaderException(String message) {
        super(message);
    }

    protected SessionLoaderException(String message, Throwable internalException) {
        super(message);
        this.setInternalException(internalException);
    }

    public static SessionLoaderException couldNotFindProjectXml(String fileName) {
        Object[] args = new Object[]{fileName};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9004, args));
        sessionLoaderException.setErrorCode(9004);
        return sessionLoaderException;
    }

    public static SessionLoaderException unkownTagAtNode(String tagName, String nodeName, Throwable exception) {
        Object[] args = new Object[]{tagName, nodeName};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9001, args), exception);
        sessionLoaderException.setErrorCode(9001);
        return sessionLoaderException;
    }

    public static SessionLoaderException failedToLoadProjectClass(String className, Throwable exception) {
        Object[] args = new Object[]{className};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9002, args), exception);
        sessionLoaderException.setErrorCode(9002);
        return sessionLoaderException;
    }

    public static SessionLoaderException failedToLoadProjectXml(String fileName, Throwable exception) {
        Object[] args = new Object[]{fileName};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9005, args), exception);
        sessionLoaderException.setErrorCode(9005);
        return sessionLoaderException;
    }

    public static SessionLoaderException failedToLoadTag(String parentNode, String nodeValue, Throwable exception) {
        Object[] args = new Object[]{parentNode, nodeValue};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9003, args), exception);
        sessionLoaderException.setErrorCode(9003);
        return sessionLoaderException;
    }

    public static SessionLoaderException finalException(Vector exceptionList) {
        Object[] args = new Object[]{exceptionList.size()};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9000, args));
        sessionLoaderException.setErrorCode(9000);
        sessionLoaderException.setExceptionList(exceptionList);
        return sessionLoaderException;
    }

    public static SessionLoaderException failedToParseXML(String message, int lineNumber, int columnNumber, Throwable exception) {
        Object[] args = new Object[]{message, lineNumber, columnNumber};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9006, args), exception);
        sessionLoaderException.setErrorCode(9006);
        return sessionLoaderException;
    }

    public static SessionLoaderException failedToParseXML(String message, Throwable exception) {
        Object[] args = new Object[]{message};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9010, args), exception);
        sessionLoaderException.setErrorCode(9010);
        return sessionLoaderException;
    }

    public static SessionLoaderException nonParseException(Throwable exception) {
        Object[] args = new Object[]{};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9007, args), exception);
        sessionLoaderException.setErrorCode(9007);
        return sessionLoaderException;
    }

    public static SessionLoaderException unexpectedValueOfTag(String nodeValue, String parentNode) {
        Object[] args = new Object[]{nodeValue, parentNode};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9008, args));
        sessionLoaderException.setErrorCode(9008);
        return sessionLoaderException;
    }

    public static SessionLoaderException unknownAttributeOfTag(String nodeName) {
        Object[] args = new Object[]{nodeName};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9009, args));
        sessionLoaderException.setErrorCode(9009);
        return sessionLoaderException;
    }

    public static SessionLoaderException serverPlatformNoLongerSupported(String serverPlatformClassName) {
        Object[] args = new Object[]{serverPlatformClassName};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9011, args));
        sessionLoaderException.setErrorCode(9011);
        return sessionLoaderException;
    }

    public static SessionLoaderException InvalidSessionXML() {
        Object[] args = new Object[]{};
        SessionLoaderException sessionLoaderException = new SessionLoaderException(ExceptionMessageGenerator.buildMessage(SessionLoaderException.class, 9012, args));
        sessionLoaderException.setErrorCode(9012);
        return sessionLoaderException;
    }

    public void setExceptionList(Vector<Throwable> list) {
        this.exceptionList = list;
    }

    public Vector<Throwable> getExceptionList() {
        return this.exceptionList;
    }

    @Override
    public void printStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
        if (this.getExceptionList() != null) {
            writer.println("SessionLoaderExceptions:");
            Iterator<Throwable> exceptionList = this.getExceptionList().iterator();
            while (exceptionList.hasNext()) {
                writer.write("***");
                writer.write(SessionLoaderException.cr());
                exceptionList.next().printStackTrace(writer);
                writer.write(SessionLoaderException.cr());
            }
        }
        writer.flush();
    }

    @Override
    public String toString() {
        if (this.getErrorCode() == 9000) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getMessage());
            buffer.append(SessionLoaderException.cr());
            Iterator<Throwable> exceptionList = this.getExceptionList().iterator();
            while (exceptionList.hasNext()) {
                buffer.append("***");
                buffer.append(SessionLoaderException.cr());
                buffer.append(exceptionList.next().toString());
                buffer.append(SessionLoaderException.cr());
            }
            return buffer.toString();
        }
        return super.toString();
    }
}

